/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Resources.subproj/PDFFont.h,v 1.1 1999/02/03 10:25:53 bungi Exp $ */

#import <OmniPDF/PDFResource.h>

@class NSArray;
@class NSMutableArray;
@class NSData;
@class PDFObject;

#define  ENCODING_LENGTH 256

typedef enum {
    FONT_TYPE_1, FONT_TYPE_3
} PDFFontType;

#import <OmniPDF/PDFDrawState.h>

typedef unsigned char PDFEncodingConversionArray[ENCODING_LENGTH];

@interface PDFFont : PDFResource
{
    NSString		       *pdfFontName;
    NSString		       *postscriptFontName;
    NSString		       *residentFontName;
    NSDictionary	       *fontDictionary;
    NSDictionary	       *fontDescriptor;
    BOOL			isDownloaded;

@public
    PDFFontType			type;
    NSRect			boundingBox;
    PDFMatrix                   fontMatrix;
    double			horizontalStretch;
    double                      widths[ENCODING_LENGTH];
    PDFEncodingConversionArray	nativeToNextStepEncoding;
    NSArray		       *nativeEncoding;
    unsigned char		spaceCharacterInFontEncoding;
    BOOL			allCaps;
}

+ (PDFEncodingConversionArray *)pdfToNextStepConversionArray;

- (void)executeWithSize:(float)fontSize;

- (NSString *)residentFontName;

@end
