/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/PDFEncryptionHandlerProtocol.h,v 1.1 1999/02/03 10:25:20 bungi Exp $ */

#ifndef _PDF_ENCRYPTION_HANDLER_PROTOCOL_
#define _PDF_ENCRYPTION_HANDLER_PROTOCOL_

@class NSData;
@class NSMutableData;
@class PDFDictionary;

@protocol PDFSpecificEncryptionHandler
- (NSData *)decryptData:(NSData *)data;
- (void)decryptMutableData:(NSMutableData *)data;
@end

@protocol PDFEncryptionHandler
- initFromTrailer:(NSDictionary *)trailerDictionary;
- (NSData *)decryptData:(NSData *)data
            inObject:(unsigned long)objectNumber
	    generation:(unsigned)generation;
- (void)decryptMutableData:(NSMutableData *)data
        inObject:(unsigned long)objectNumber
	generation:(unsigned)generation;
- (id <PDFSpecificEncryptionHandler, NSObject>)
  handlerForObject:(unsigned long)num
  generation:(unsigned long)gen;
@end

#endif
