/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Drawing.subproj/PDFDrawer.h,v 1.1 1999/02/03 10:25:39 bungi Exp $ */

#import <OmniFoundation/OFObject.h>

@class NSFont;
@class NSData;
@class NSMutableArray;
@class PDFArray;
@class PDFDrawState;
@class PDFName;
@class PDFPageLays;
@class PDFParser;
@class PDFString;
@class PDFView;
@class PDFParserDispatchTable;

#import <OmniPDF/PDFDrawState.h>
#import <OmniPDF/FrameworkDefines.h>

OmniPDF_EXTERN NSDictionary *PDFDrawerNameForAbbreviationDictionary;

@interface PDFDrawer : OFObject
{
    PDFView	        *pdfView;
    PDFParser	        *parser;
    NSMutableArray      *drawStateHistoryArray;
    PDFDrawState        *drawState;
    
    PDFPageLays		*pageLays;
}

+ (void)setupParserDispatchTable:(PDFParserDispatchTable **)table;
+ (PDFParserDispatchTable *)parserDispatchTable;

- initWithParser:(PDFParser *)newParser
    pdfView:(PDFView *)view
    addToPageLays:(PDFPageLays *)newPageLays;

- (void)beginDrawing;
- (void)endDrawing;


/**************************************************************************
 * PDF methods
 **************************************************************************/

/* 7.3 Graphics state operators */
- (void)save; /* q */
- (void)restore; /* Q */
- (void)concat:(float)a :(float)b :(float)c
        :(float)d :(float)x :(float)y; /* cm */
- (void)setdashArray:(PDFArray *)pdfArray phase:(float)phase; /* d */
- (void)setflat:(float)flat; /* i */
- (void)setlinejoin:(float)linejoin; /* j */
- (void)setlinecap:(float)linecap; /* J */
- (void)setmiterlimit:(float)miterlimit; /* M */
- (void)setlinewidth:(float)linewidth; /* w */

/* 7.4 Color operators */
- (void)setgrayFill:(float)gray; /* g */
- (void)setgrayStroke:(float)gray; /* G */
- (void)setcmykcolorFill:(float)c :(float)m :(float)y :(float)k; /* k */
- (void)setcmykcolorStroke:(float)c :(float)m :(float)y :(float)k; /* K */
- (void)setrgbcolorFill:(float)r :(float)g :(float)b; /* rg */
- (void)setrgbcolorStroke:(float)r :(float)g :(float)b; /* RG */

/* 7.5 Path operators */
/* 7.5.1 path segment operators */
- (void)moveto:(float)x :(float)y; /* m */
- (void)rmoveto:(float)x :(float)y; /* not in spec */
- (void)lineto:(float)x :(float)y; /* l */
- (void)curveto:(float)x1 :(float)y1 :(float)x2 :(float)y2
     :(float)x3 :(float)y3; /* c */
- (void)curvetoDoubleFirstPoint:(float)x2 :(float)y2
     :(float)x3 :(float)y3; /* v */
- (void)curvetoDoubleFinalPoint:(float)x1 :(float)y1
     :(float)x3 :(float)y3; /* y */
- (void)rectangle:(float)x :(float)y
     :(float)width :(float)height; /* re */
- (void)closepath; /* h */
/* 7.5.2 path painting operators */
- (void)newpath; /* n */
- (void)stroke; /* S */
- (void)closepathStroke; /* s */
- (void)fill; /* f */ /* F */
- (void)eofill; /* f* */
- (void)fillStroke; /* B */
- (void)closepathFillStroke; /* b */
- (void)eofillStroke; /* B* */
- (void)closePathEofillStroke; /* b* */
/* 7.5.3 path clipping operators */
- (void)clip; /* W */
- (void)eoclip; /* W* */

/* 7.6 Text state */
/* 7.7.1 Text object operators */
- (void)beginText; /* BT */
- (void)endText; /* ET */
/* 7.7.2 Text state operators (in or out of text) */
- (void)setCharacterSpace:(float)characterSpace; /* Tc */
- (void)setTextFont:(PDFName *)pdfName size:(float)size; /* Tf */
- (void)setTextLeading:(float)leading; /* TL */
- (void)setTextRenderingMode:(PDFRenderingModes)renderingMode; /* Tr */
- (void)setTextRise:(float)rise; /* Ts */
- (void)setWordSpace:(float)wordSpace; /* Tw */
- (void)setTextHorizontalScale:(float)horizontalScale; /* Tz */
/* 7.7.3 Text positioning operators (only within text) */
- (void)nextLineX:(float)dx y:(float)dy; /* Td */
- (void)nextLineX:(float)dx ySetLeading:(float)dy; /* TD */
- (void)setTextMatrix:(float)a :(float)b :(float)c
        :(float)d :(float)x :(float)y; /* Tm */
- (void)nextLine; /* T* */
/* 7.7.4 Text string operators */
- (void)show:(PDFString *)pdfString; /* Tj */
- (void)showNextLine:(PDFString *)pdfString; /* ' */
- (void)showNextLineWordSpace:(float)wordSpace
    characterSpace:(float)characterSpace
    pdfString:(PDFString *)pdfString; /* " */
- (void)showKerned:(PDFArray *)pdfArray; /* TJ */

/* 7.8 XObject operator */
- (void)xObject:(PDFName *)pdfName; /* Do */

/* 7.9 In-line image operators */
- (void)beginImage; /* BI */
- (void)imageData; /* ID */
- (void)endImage; /* EI */

/* 7.10 Type 3 font operators*/
- (void)setcharwidth:(float)wx :(float)wy; /* d0 */
- (void)setcachedevice:(float)wx :(float)wy
  :(float)llx :(float)lly :(float)urx :(float)ury; /* d1 */

@end
