/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Drawing.subproj/PDFDrawState.h,v 1.1 1999/02/03 10:25:38 bungi Exp $ */

#import <OmniFoundation/OFObject.h>
#import <OmniAppKit/ps.h>

#import <OmniPDF/PDFColorSpace.h>

typedef enum {
    PDF_NO_CLIP, PDF_CLIP, PDF_EOCLIP
} PDFClipping;

typedef enum {
    PDF_FILL_TEXT, PDF_STROKE_TEXT, PDF_FILL_STROKE_TEXT,
    PDF_INVISIBLE_TEXT, PDF_FILL_CLIP_TEXT, PDF_STROKE_CLIP_TEXT,
    PDF_FILL_STROKE_CLIP_TEXT, PDF_CLIP_TEXT
} PDFRenderingModes;

typedef struct {
    double a, b, c, d, x, y;
} PDFMatrix;

#define PDF_IDENTITY_MATRIX ((PDFMatrix){1.,0.,0.,1.,0.,0.})

@class PDFFont;

#import <Foundation/NSGeometry.h> /* For NSRect, etc... */

@interface PDFDrawState : OFObject
{
@public
    /* General graphics state (Table 7.1) */
    PDFColor                    wantStrokeColor, wantFillColor;
    PDFMatrix                   transformationMatrix;

    /* Text-specific graphics state (Table 7.2) */
    float                       characterSpace;
    float                       horizontalScale;
    float                       leading;
    PDFMatrix                   textMatrix;
    PDFFont                    *pdfFont;
    float                       rise;
    float                       fontSize;
    PDFRenderingModes           renderingMode;
    float                       wordSpace;
    NSPoint                     textLineStartPoint;
    
    /* Internal state */
    PDFClipping                 clipping;
    
    /* Postscript interpreter state */
    PDFColor                    currentColor;
    NSPoint			currentPoint;
    BOOL			hasCurrentPoint;
    NSPoint			subpathStartPoint;
}

+ drawStateFromState:(PDFDrawState *)oldState;
- initFromState:(PDFDrawState *)oldState;

- (void)useFillColor;
- (void)useStrokeColor;


@end

#define MIN_DETERMINANT 1e-9

static inline const PDFMatrix
pdfInvertMatrix(const PDFMatrix mx)
{
    double determinant;
    double ai, bi, ci, di;
    
    determinant = mx.a * mx.d - mx.b * mx.c;
    
    if(fabs(determinant) < MIN_DETERMINANT) {
        return PDF_IDENTITY_MATRIX;
    }
    
    ai =      mx.d / determinant;
    bi = -1 * mx.b / determinant;
    ci = -1 * mx.c / determinant;
    di =      mx.a / determinant;
    
    return (PDFMatrix){ai, bi, ci, di,
    	-1 * ( mx.x * ai + mx.y * ci ),
	-1 * ( mx.x * bi + mx.y * di )};
}

static inline const PDFMatrix
pdfMatrixMultiply(const PDFMatrix m, const PDFMatrix n)
{
    return (PDFMatrix)
    {
        m.a * n.a + m.b * n.c,
	m.a * n.b + m.b * n.d,
	m.c * n.a + m.d * n.c,
	m.c * n.b + m.d * n.d,
	m.x * n.a + m.y * n.c + n.x,
	m.x * n.b + m.y * n.d + n.y
    };
}

static inline const NSPoint
pdfMatrixTransformPoint(const PDFMatrix mx, const NSPoint pt)
{
    return NSMakePoint(mx.a * pt.x + mx.c * pt.y + mx.x,
                       mx.b * pt.x + mx.d * pt.y + mx.y);
}

static inline const NSRect
pdfMatrixTransformRect(const PDFMatrix mx, const NSRect rect)
{
    NSPoint		point1, point2, point3, point4;
    NSRect		newRect;

    point1 = pdfMatrixTransformPoint(mx, NSMakePoint(NSMinX(rect), NSMinY(rect)));
    point2 = pdfMatrixTransformPoint(mx, NSMakePoint(NSMaxX(rect), NSMinY(rect)));
    point3 = pdfMatrixTransformPoint(mx, NSMakePoint(NSMaxX(rect), NSMaxY(rect)));
    point4 = pdfMatrixTransformPoint(mx, NSMakePoint(NSMinX(rect), NSMaxY(rect)));

    newRect.origin.x = MIN(point1.x, MIN(point2.x, MIN(point3.x, point4.x)));
    newRect.origin.y = MIN(point1.y, MIN(point2.y, MIN(point3.y, point4.y)));
    newRect.size.width = MAX(point1.x, MAX(point2.x, MAX(point3.x, point4.x)))
                         - newRect.origin.x;
    newRect.size.height = MAX(point1.y, MAX(point2.y, MAX(point3.y, point4.y)))
                          - newRect.origin.y;
    return newRect;
}

static inline void
pdfPSconcat(const PDFMatrix m)
{
    float	msingle[6] = {m.a, m.b, m.c, m.d, m.x, m.y};

//    msingle[0] = m.a; msingle[1] = m.b; msingle[2] = m.c;
//    msingle[3] = m.d; msingle[4] = m.x; msingle[5] = m.y;
    
    PSconcat(msingle);
}
