// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/PDFDisplay.h,v 1.2 1999/02/06 08:26:00 bungi Exp $

#import <OmniFoundation/OFObject.h>
#import <AppKit/NSNibDeclarations.h> // For IBAction
#import <Foundation/NSRange.h>

#import <OmniAppKit/OAPageSelectableDocumentProtocol.h>
#import <OmniAppKit/OAFindControllerTargetProtocol.h>
#import <OmniAppKit/OAThumbnailView.h>

@class PDFStorage, PDFScrollView, PDFView, PDFPage;
@class NSBox, NSPrintInfo;

@interface PDFDisplay : OFObject <OAThumbnailProvider, OAFindControllerTarget, OAPageSelectableDocument>
{
    NSBox         *nonretainedBox;
    int            pageIndex;
    PDFStorage    *pdfStorage;
    PDFScrollView *scrollView;
    PDFView       *pdfView;

    id             delegate;
}

- initWithPDFStorage: (PDFStorage *) newStorage box: (NSBox *) newBox;

// API
- (void) setDelegate: (id) newDelegate;
- (id) delegate;

- (PDFView *) view;
- (PDFStorage *) storage;
- (int)pageIndex;
- (void)displayPage:(PDFPage *)page setSelectionRange:(NSRange)selectionRange;
- (void)displayPage:(PDFPage *)page;
- (void)displayPageNumber:(int)pageNumber;
- (void)displayPageObjectNumber:(int)pageObjectNumber;
- (void)pageUp;
- (void)pageDown;

- (void)saveAsType:(NSString *)type fileType:(NSString *)fileType;
- (void)printShowingPrintPanel:(BOOL)flag printInfo: (NSPrintInfo *) printInfo;

@end


@interface NSObject (PDFDisplayDelegate)
- (void) pdfDisplay: (PDFDisplay *) display willDrawPage: (PDFPage *) page;
- (void) pdfDisplay: (PDFDisplay *) display didDrawPage: (PDFPage *) page;
@end
