/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Resources.subproj/PDFColorSpace.h,v 1.1 1999/02/03 10:25:52 bungi Exp $ */

#import <OmniPDF/PDFResource.h>
#import <OmniPDF/FrameworkDefines.h>

@class NSArray;
@class NSMutableArray;
@class NSData;
@class PDFObject;
@class PDFColorSpace;
@class PDFString;

typedef enum {
    DEVICE_GRAY, DEVICE_RGB, DEVICE_CMYK,
    CAL_GRAY, CAL_RGB, LAB, CAL_CMYK, INDEXED,
    COLOR_SPACE_COUNT
} PDFColorSpaceType;

typedef struct {
    float c0, c1, c2, c3;
} PDFColorComponents;

typedef struct {
    PDFColorSpace              *space;
    PDFColorComponents          components;
} PDFColor;

OmniPDF_EXTERN int PDFColorSpaceComponentCountTable[];

OmniPDF_EXTERN PDFColorSpace *PDFDeviceGray, *PDFDeviceRGB, *PDFDeviceCMYK;

@interface PDFColorSpace : PDFResource
{
@public
    PDFColorSpaceType colorSpaceType;
    NSDictionary *dictionary;
    /* Only for indexed spaces */
    PDFColorSpace *base;
    int hiValue;
    PDFString *lookup;
}

+ (PDFColorSpaceType)colorSpaceTypeNamed:(NSString *)colorSpaceName;

- initFromObject:(PDFObject *)object;

- (PDFColorSpaceType)colorSpaceType;
- (int)numberOfComponents;

- (void)useColorSpace;
- (void)useComponents:(PDFColorComponents)components;

@end
