/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Atoms.subproj/PDFArray.h,v 1.1 1999/02/03 10:25:28 bungi Exp $ */

#import <OmniPDF/PDFObject.h>

typedef enum {
    PDF_STACK_FLOAT, PDF_STACK_INT, PDF_STACK_OBJECT
} PDFStackObjectType;

typedef struct {
    PDFStackObjectType          objectType;
    union {
	PDFObject                  *object;
	float                       floatValue;
	int                         intValue;
    }                           value;
}                           PDFStackObject;

#import <Foundation/NSGeometry.h> /* For NSRect, etc... */
#import <Foundation/NSString.h>	/* for the inline below that uses strings */

@class NSColor;

@interface PDFArray : PDFObject
{
@public
    PDFStackObject		*stack;
    int				 count;
    int				 maxSize;
}

- initFromArray:(PDFArray *)array;

/* Simple access */
- (int)count;
- objectAtIndex:(unsigned)index;
- (float)floatAtIndex:(unsigned)index;
- (int)intAtIndex:(unsigned)index;
- (void)addObject:object;
- lastObject;

/* Complex access */
- (NSRect)rect;
- (NSRect)rectScaledBy:(NSSize)scale;
- (NSColor *)color;
- (void)fillFloatBuffer:(float *)floatBuffer length:(int)length;
- (void)fillIntBuffer:(int *)intBuffer length:(int)length;

/* Changing */
- (void)addObject:object;
- (void)addFloat:(float)floatValue;
- (void)addInt:(int)intValue;

- (id)pop;
- (float)popFloat;
- (int)popInt;


@end

#import <OmniBase/system.h>

#import <Foundation/NSException.h>

static inline void
pdfArraySetCount(PDFArray *self, int count)
{
    if (count > self->maxSize) {
        if (!self->stack) {
            self->maxSize = count;
            self->stack = (PDFStackObject *) NSZoneMalloc(NULL, self->maxSize * sizeof(PDFStackObject));
        } else {
            while (self->maxSize < count)
                self->maxSize *= 2;
            self->stack = (PDFStackObject *) NSZoneRealloc(NULL, self->stack,
                                                           self->maxSize * sizeof(PDFStackObject));
        }
    }
    self->count = count;
}

static inline void
pdfArrayBoundsCheck(int index, int count) 
{
    if (index >= count)
	[NSException raise:@"BoundsCheck Failed"
	 format:@"Array length %d indexed by %d!", count, index];
}

/* Mutable */

static inline float
pdfArrayPopFloat(PDFArray *self)
{
    PDFStackObject		stackObject;
    
    pdfArrayBoundsCheck(0, self->count);
    stackObject = self->stack[self->count-1];
    pdfArraySetCount(self, self->count-1);
    switch (stackObject.objectType) {
    case PDF_STACK_FLOAT:
	return stackObject.value.floatValue;
    case PDF_STACK_INT:
	return stackObject.value.intValue;
    case PDF_STACK_OBJECT:
    default:
        [stackObject.value.object release];
	return 0;
    }
}

static inline int
pdfArrayPopInt(PDFArray *self)
{
    PDFStackObject		stackObject;
    
    pdfArrayBoundsCheck(0, self->count);
    stackObject = self->stack[self->count-1];
    pdfArraySetCount(self, self->count-1);
    switch (stackObject.objectType) {
    case PDF_STACK_FLOAT:
	return stackObject.value.floatValue;
    case PDF_STACK_INT:
	return stackObject.value.intValue;
    case PDF_STACK_OBJECT:
    default:
        [stackObject.value.object release];
	return 0;
    }
}

static inline void
pdfArrayAddFloat(PDFArray *self, float floatValue)
{
    pdfArraySetCount(self, self->count+1);
    self->stack[self->count-1].objectType = PDF_STACK_FLOAT;
    self->stack[self->count-1].value.floatValue = floatValue;
}

static inline void
pdfArrayAddInt(PDFArray *self, int intValue)
{
    pdfArraySetCount(self, self->count+1);
    self->stack[self->count-1].objectType = PDF_STACK_INT;
    self->stack[self->count-1].value.intValue = intValue;
}
