/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Drawing.subproj/PDFAnnotation.h,v 1.1 1999/02/03 10:25:38 bungi Exp $ */

#import <OmniFoundation/OFObject.h>
#import <AppKit/NSNibDeclarations.h> // For IBOutlet

@class PDFView;
@class PDFStorage;
@class PDFDisplay;
@class PDFXref;
@class PDFAction;

typedef enum {
    ANNOTATION_TYPE_UNKNOWN, ANNOTATION_TYPE_TEXT, ANNOTATION_TYPE_LINK
} PDFAnnotationType;

#import <Foundation/NSGeometry.h> /* For NXRect, etc... */

@class NSColor, NSPanel, NSTextView;

@interface PDFAnnotation : OFObject
{
    NSDictionary	*annotationDictionary;
    
    NSRect		 bounds;
    float		 borderWidth;
    NSColor *		 color;
    
    /* Outlets */
    IBOutlet NSPanel    *window; /* Really only for Text subtype */
    IBOutlet NSTextView *text;   /* Really only for Text subtype */

    PDFAnnotationType    type;
    union {
	struct {
	    NSString		*string;
	    BOOL		 shouldOpen;
	    NSRect		 buttonBounds;
	} text;
	struct {
	    PDFAction		*action;
	} link;
    } typeData;

    struct {
        unsigned int invisibleIfUnknown:1;
        unsigned int hidden:1;
        unsigned int print:1;
    } flags;
}

- initFromXref:(PDFXref *)resourceXref
  pdfStorage:(PDFStorage *)pdfStorage;

- (BOOL)clickable;
- (PDFAnnotationType)type;
- (NSRect)bounds;

- (BOOL)respondToMouseHit:(NSPoint)mousePoint inDisplay:(PDFDisplay *) aDisplay;
- (void)hide;
- (void)activateInDisplay:(PDFDisplay *) display;
- (BOOL)drawInDisplay:(PDFDisplay *)display;
- (BOOL)drawIfLink;

@end

/* Sample
{
    A = {D = (0, FitR, -12, 284, 625, 797);
         F = "../PAPERS/P120.PDF";
         S = GoToR; }
    Border = (0, 0, 0); 
    Rect = (250, 272, 269, 605); 
    Subtype = Link; 
    Type = Annot; 
}
*/
