#pragma once
#include <wx/wx.h>
#include <wxFlatNotebook.h>
#include "enjTelnetPanel.h"

class Frame :
	public wxFrame
{
public:
	// Construction of MainFrame
	Frame(wxWindow* parent, const wxChar *title);
	virtual ~Frame(void);
	bool Create(wxFrame * parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style );
	wxWindow* CreatePage();

	// Menus
	wxMenu* m_fileMenu;
	wxMenu* m_editMenu;
	wxMenuBar* m_menuBar;
	wxFlatNotebookImageList m_ImageList;

//#ifdef DEVELOPMENT
	wxLog *m_logTargetOld;
//#endif

	// Event handlers

	// Menu
	virtual void OnQuit(wxCommandEvent& WXUNUSED(event));
	virtual void OnDeleteAll(wxCommandEvent& WXUNUSED(event));
	virtual void OnAddPage(wxCommandEvent& WXUNUSED(event));
	virtual void OnDeletePage(wxCommandEvent& WXUNUSED(event));
	virtual void OnSetSelection(wxCommandEvent& WXUNUSED(event));
	virtual void OnAdvanceSelectionFwd(wxCommandEvent& WXUNUSED(event));
	virtual void OnAdvanceSelectionBack(wxCommandEvent& WXUNUSED(event));
	virtual void OnShowImages(wxCommandEvent& WXUNUSED(event));
	virtual void OnVC71Style(wxCommandEvent& WXUNUSED(event));
	virtual void OnDefaultStyle(wxCommandEvent& WXUNUSED(event));
	virtual void OnFancyStyle(wxCommandEvent& WXUNUSED(event));
	virtual void OnSelectColor(wxCommandEvent& event);
	virtual void OnSetPageImageIndex(wxCommandEvent& event);
	virtual void OnStyle(wxCommandEvent& event);
	virtual void OnAbout(wxCommandEvent& event);
	virtual void OnManual(wxCommandEvent& event);
	virtual void OnOpenServer(wxCommandEvent &event);
	virtual void OnCloseSession(wxCommandEvent &event);
	virtual void OnReconnectSession(wxCommandEvent &event);
	virtual void OnDupSession(wxCommandEvent &event);
	virtual void OnChangeFont(wxCommandEvent &event);
	virtual void OnSplitVert(wxCommandEvent &event);
	virtual void OnSplitHor(wxCommandEvent &event);
	virtual void OnHideScrollBar(wxCommandEvent &event);
	void OnEditServerList(wxCommandEvent &event);
	void OnVisitHomePage(wxCommandEvent &event);
	void OnRenewServerList(wxCommandEvent &event);
	void OnKeyDown(wxKeyEvent& event);
	void RenewServerList();
	MySplitterWindow *GetSplitedParentWin(wxWindow *cu,wxWindow **removed);
	void GetHorSplitedWin(MySplitterWindow *ro,wxRect cu,wxWindow **ta,int side);
	void OnFullScreen(wxCommandEvent &event);
	void OnSaveConfig(wxCommandEvent &event);
	void LoadConfig();
	void ResetDefaultConfig(wxCommandEvent &event);
	void OnChangeBufferSize(wxCommandEvent &event);
	void OnRenameTabPage(wxCommandEvent &event);
	void OnChangeBackground(wxCommandEvent &event);
	
	

	virtual void OnEnableTab(wxCommandEvent& event);
	virtual void OnDisableTab(wxCommandEvent& event);
	virtual void OnEnableDrag(wxCommandEvent& event);

	// Notebook
	virtual void OnPageChanging(wxFlatNotebookEvent& event);
	virtual void OnPageChanged(wxFlatNotebookEvent& event);
	virtual void OnPageClosing(wxFlatNotebookEvent& event);
	virtual void OnSetAllPagesShapeAngle(wxCommandEvent& WXUNUSED(event));
	void NewTelnetPage(wxString hostname);
	void NewTelnetPage(SiteInfo *si);
	void OnAddressTextEnter(wxCommandEvent &event);

	wxFlatNotebook *book;
	wxFlatNotebook *secondBook;
	bool m_bShowImages;
	bool m_bVCStyle;
	wxTextCtrl     *text;
    wxImageList *m_imageList;
	//wxTextCtrl *txtAddress;
	wxComboBox *txtAddress;
	

	DECLARE_EVENT_TABLE()
};
