#include "App.h"
#include <wx/image.h>
#include <wx/xrc/xmlres.h>
#include "Frame.h"
#include <wx/sysopt.h>
#include <wx/fontmap.h>
 
IMPLEMENT_APP(App)

Frame *pMainFrame = (Frame *) NULL;
wxPrintData *g_printData = (wxPrintData*) NULL;
wxPageSetupData *g_pageSetupData = (wxPageSetupData*) NULL;
int g_argc=0;
wxChar **g_argv;

// Externs
extern void InitXmlResource();

App::App(void)
{
}

App::~App(void)
{
}

// Initialize our application
bool App::OnInit(void)
{ 
	/*
	wxLogMessage("%s",wxFontMapper::GetEncodingDescription(wxFONTENCODING_DEFAULT));
	wxLogMessage("%s",wxFontMapper::GetEncodingName(wxFONTENCODING_DEFAULT));
	wxFontEncoding enc = wxFontMapper::GetEncodingFromName(wxString("BIG5"));
	wxLogMessage("%s",wxFontMapper::GetEncodingDescription(enc));
	wxLogMessage("%s",wxFontMapper::GetEncodingName(enc));
	wxFont::SetDefaultEncoding(enc);
	*/

	// Init resources and add the PNG handler
	wxSystemOptions::SetOption(wxT("msw.remap"), 0); 
	wxXmlResource::Get()->InitAllHandlers(); 
 	wxImage::AddHandler( new wxPNGHandler ); 
	wxImage::AddHandler( new wxCURHandler ); 
	wxImage::AddHandler( new wxBMPHandler );
	wxImage::AddHandler( new wxXPMHandler );

	InitXmlResource();
	g_argc = argc;
	g_argv = argv;

	pMainFrame = new Frame(NULL, wxT("Frame"));
	 
	// initialize print data and setup
    g_printData = new wxPrintData;
    g_pageSetupData = new wxPageSetupDialogData;

	// show the main frame
	pMainFrame->Show(TRUE);

	// set the main frame to be the main window
	SetTopWindow(pMainFrame);
	
	return TRUE;	
}

int App::OnExit(void) 
{
    // delete global print data and setup
    if (g_printData) delete g_printData;
    if (g_pageSetupData) delete g_pageSetupData;
	return 0;
}
