#ifndef __ENJ_TELNET_PANEL_H__
#define __ENJ_TELNET_PANEL_H__

#if defined(__GNUG__) && !defined(__APPLE__)
    #pragma implementation
    #pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

// for all others, include the necessary headers
#ifndef WX_PRECOMP
#  include "wx/wx.h"
#endif


#include "wx/socket.h"
#include "wx/splitter.h"
#include "wx/gizmos/splittree.h"
#include "bbsrc/scd_telnet.h"
#include "bbsrc/common.h"
#include "bbsrc/ds.h"


#define TELNET_SCROLL_BAR_WIDTH 12
#define TELNET_PING_INTERVAL			600000
#define TELNET_TIMER			10

class enjTelnetPanel : public wxWindow
//class enjTelnetPanel : public wxScrolledWindow
{
private:
	bool isAltDown;

public:
	enjTelnetPanel(){};
	enjTelnetPanel(wxWindow *parent, wxWindow *tab= NULL, wxWindowID id = wxID_ANY, const wxPoint &pos = wxDefaultPosition, const wxSize &size = wxDefaultSize);
	~enjTelnetPanel();

	bool NewConnection(wxString hostname,int port);
	bool NewConnection(SiteInfo *site);
//	GetCaret();
  // socket event handler
  	void OnSocketEvent(wxSocketEvent& event);
	void OnKeyDown(wxKeyEvent& event);
	void OnKeyUp(wxKeyEvent& event);
	void OnChar(wxKeyEvent& event);
	void OnPaint(wxPaintEvent& event);
	void OnResize(wxSizeEvent& event);
	void OnMouseLeftDoubleClick(wxMouseEvent& event);
	void OnMouseLeftDown(wxMouseEvent& event);
	void OnMouseRightUp(wxMouseEvent& event);
	void OnMouseMotion(wxMouseEvent& event);
	void OnMouseWheel(wxMouseEvent& event);
	void OnMouseLeftUp(wxMouseEvent& event);
	void AssignScrollBar(wxScrollBar *sb);
	void OnScroll(wxScrollEvent & event);
	void OnKillFocus(wxFocusEvent &event);
	void OnSetFocus(wxFocusEvent &event);
	void OnEraseBackground(wxEraseEvent &event);
	void OnTimer(wxTimerEvent &event);
	void OnClose(wxCloseEvent &event);
	void Reconnect(){telnet->reconnect();};
	void HideScrollBar(){
		wxSize sz=GetParent()->GetSize();
		if (sbar->IsShown()){
			sbar->Hide();
			SetSize(sz);
		}else{
			SetSize(sz.x-TELNET_SCROLL_BAR_WIDTH,sz.y);
			sbar->SetSize(sz.x-TELNET_SCROLL_BAR_WIDTH,0,TELNET_SCROLL_BAR_WIDTH+2,sz.y);
			sbar->Show();
		}
		//GetParent()->Layout();
	};
    void OnProcessTerm(wxProcessEvent& event);
	

	//void SetTelnet(SCD_Telnet *t);
/*

	void OnMouseMiddleDown(wxMouseEvent& event);
	void OnSocketEvent( wxSocketEvent &e );
	void OnFocus(wxFocusEvent& event);
*/

	int sockid;
	SCD_Telnet *telnet;
	wxCaret *caret;
	wxScrollBar *sbar;
	wxWindow	*tabwin;
	int connect_state;//0:connecting;1:connected;2:close
	wxTimer m_timer;
	int is_show;
	wxFont pre_fnt;
	wxColor pre_bg;
	//int ping_interval;
	int	ticks;
	SiteInfo *si;
	int control_down;

private:

//	DECLARE_DYNAMIC_CLASS(enjTelnetPanel)
    DECLARE_EVENT_TABLE()
};



class enjScrollTelnetPanel : public wxPanel
//class enjTelnetPanel : public wxScrolledWindow
{
private:
	enjTelnetPanel *telpanel;
	wxScrollBar *sb;

public:
	enjScrollTelnetPanel(){};
	enjScrollTelnetPanel(wxWindow *parent, wxWindow *tabwin = NULL, wxWindowID id = wxID_ANY, const wxPoint &pos = wxDefaultPosition, const wxSize &size = wxDefaultSize);
	//~enjScrollTelnetPanel(){delete sb; };
	void OnScroll(wxScrollEvent &event);
	void OnResize(wxSizeEvent& event);
	bool NewConnection(wxString hostname);
	bool NewConnection(SiteInfo *site);
	void OnKeyDown(wxKeyEvent &event);
	void Reconnect(){telpanel->Reconnect();};

private:

    DECLARE_EVENT_TABLE()
};

class MySplitterWindow : public wxThinSplitterWindow
{
public:
    MySplitterWindow(wxWindow *parent);

    // event handlers
    void OnPositionChanged(wxSplitterEvent& event);
    void OnPositionChanging(wxSplitterEvent& event);
    void OnDClick(wxSplitterEvent& event);
    void OnUnsplitEvent(wxSplitterEvent& event);

private:
    wxFrame *m_frame;

    DECLARE_EVENT_TABLE()
    DECLARE_NO_COPY_CLASS(MySplitterWindow)
};
#ifdef __WXGTK__
extern wxWindow *g_focustelnet;
#endif

/*!
 * PersonalRecordDialog class declaration
 */
/*
typedef struct  enjConfig
{
public:
private:
wxString    m_server;
int         m_port;
int         m_protocol;
wxString 	m_ssh_private_key_file;
};
*/

class PersonalRecordDialog: public wxDialog
{
    DECLARE_CLASS( PersonalRecordDialog )
    DECLARE_EVENT_TABLE()

public:
    // Constructors
    PersonalRecordDialog( );
    PersonalRecordDialog( SiteInfo *site,wxWindow* parent,
      wxWindowID id = wxID_ANY,
      const wxString& caption = wxT("Personal Record"),
      const wxPoint& pos = wxDefaultPosition,
      const wxSize& size = wxDefaultSize,
      long style = wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU );

    // Initialize our variables
    void Init();

    // Creation
    bool Create( wxWindow* parent,
      wxWindowID id = wxID_ANY,
      const wxString& caption = wxT("Personal Record"),
      const wxPoint& pos = wxDefaultPosition,
      const wxSize& size = wxDefaultSize,
      long style = wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU );

    // Creates the controls and sizers
    void CreateControls();
	void OnBrowserButton(wxCommandEvent &event);
	void OnTelnetRaButton(wxCommandEvent &event);
	void OnSSHRaButton(wxCommandEvent &event);
	void OnShellRaButton(wxCommandEvent &event);

virtual bool TransferDataToWindow();
virtual bool TransferDataFromWindow();

private:
SiteInfo *si;
// Data members
//bool        m_vote;

wxComboBox* nameCtrl;
wxTextCtrl* portCtrl;
wxRadioButton *telnetRa;
long telnetRa_id;
wxRadioButton *sshRa;
long sshRa_id;
wxRadioButton *shellRa;
long shellRa_id;
wxTextCtrl* sshPrivateKeyFileCtrl;
long		browser_id;
//wxChoice* proChoice;
//wxSpinCtrl* ageSpin;
//wxCheckBox* voteCheckBox;
};


#endif

