#include "enjTelnetPanel.h"
#include <wx/app.h>


BEGIN_EVENT_TABLE(enjScrollTelnetPanel, wxPanel)
  	EVT_SIZE(enjScrollTelnetPanel::OnResize)
	EVT_SCROLL(enjScrollTelnetPanel::OnScroll)
END_EVENT_TABLE()


enjScrollTelnetPanel::enjScrollTelnetPanel(wxWindow *parent, wxWindow *tabwin, wxWindowID id, const wxPoint &pos, const wxSize &size)
		 : wxPanel( parent, id, pos, size)
{
  wxBoxSizer *midsizer = new wxBoxSizer( wxVERTICAL  );
  telpanel = new enjTelnetPanel(this,tabwin);
  telpanel->SetCursor(wxCursor(wxCURSOR_IBEAM));
  //SetSize(800,600);
  //int w,h ; 
   //parent->GetSize(&w,&h);
//  telpanel->SetSize(w-25,-1);
  sb = new wxScrollBar(this,wxID_ANY,wxDefaultPosition,wxDefaultSize,wxSB_VERTICAL);
  //sb->SetScrollBar(0,1,1,1);
  //sb->SetSize(10,10);
  //sb->SetSizeHints(10,10,10,-1,0);
  telpanel->AssignScrollBar(sb);
  midsizer->Add(telpanel,0,wxEXPAND);
 // SetBackgroundColour(*wxBLACK);
 // midsizer->Add(sb,1,wxEXPAND);
 // SetAutoLayout( true );
  SetSizer(midsizer);
}

void enjScrollTelnetPanel::OnScroll(wxScrollEvent &event)
{
	//wxLogMessage("OnScroll enjScrollTelnetPanel");
	telpanel->OnScroll(event);
	telpanel->SetFocus();
}

void enjScrollTelnetPanel::OnResize(wxSizeEvent &event)
{
	int w,h;
	int w1,h1;
	int w2,h2;
	//GetParent()->GetSize(&w1,&h1);
	//GetParent()->GetParent()->GetSize(&w2,&h2);
	//if (((wxTopLevelWindow *)(wxTheApp->GetTopWindow()))->IsMaximized()) return;
	GetSize(&w1,&h1);
	if (((wxFrame *)(wxTheApp->GetTopWindow()))->IsFullScreen()){
		sb->Hide();
	}else{
		sb->Show();
	}
//	wxLogMessage("w h %d %d,w2 h2 %d %d telpanel w1-15 hl %d %d",w,h,w2,h2,w1-15,h1);
	if (sb->IsShown())	{
		telpanel->SetSize(w1-TELNET_SCROLL_BAR_WIDTH,h1);
		sb->SetSize(w1-TELNET_SCROLL_BAR_WIDTH,0,TELNET_SCROLL_BAR_WIDTH+2,h1);
	}else{
		telpanel->SetSize(w1,h1);
	}

	sb->SetScrollbar(0,1,1,1);
}

bool enjScrollTelnetPanel::NewConnection(wxString hostname)
{
  	return telpanel->NewConnection(hostname,23);
}

bool enjScrollTelnetPanel::NewConnection(SiteInfo *si)
{
  	return telpanel->NewConnection(si);
}

void enjScrollTelnetPanel::OnKeyDown(wxKeyEvent &event)
{
	GetParent()->ProcessEvent(event);
}
