/******************************************************************************
 * Name:        scd_wxssh.cpp
 * Purpose:     a wrapper of SSH in libssh library
 * Author:      Xie, Chun-Da (jakky1)
 * E-mail:      jakky1@gmail.com
 * Created:     2004.7
 * Copyright:   (C) 2004 Xie, Chun-Da
 * Licence:     GPL : http://www.gnu.org/licenses/gpl.html
 * Modified by:
 ******************************************************************************/


#ifndef SCD_WXEXEC_H
#define SCD_WXEXEC_H
#include "common.h"
#include "ds.h"
#include <wx/socket.h>

#include "wx/txtstrm.h"
#include "wx/numdlg.h"
#include "wx/ffile.h"

#include "wx/process.h"

#include "wx/mimetype.h"

//#include "scd_wxsftp.h"

//#include "ssh/libssh.h"
//#include <wx/thread.h>

// This is the handler for process termination events
class enjProcess : public wxProcess
{
public:
    enjProcess(int flags)
        : wxProcess(flags)
    {
        //m_parent = parent;
		closed=false;
    }

    // instead of overriding this virtual function we might as well process the
    // event from it in the frame class - this might be more convenient in some
    // cases
    virtual void OnTerminate(int pid, int status);

	bool closed;

protected:
    wxWindow *m_parent;
    wxString m_cmd;
};


class SCD_wxEXEC
{
public:
	void *parent;
	void *m_handler;
public:
//	wxString ip;
public:
//	int port;
//	wxString username, password;

	//ФŦsoܼ
//	bool not_read_after_notify;
	wxEvtHandler *evt_handler;
	int evt_id;
	void SendEvent(wxSocketNotify v);

public:
private:

//	char unread_buf[ SCD_wxSSH_UNREAD_BUF_SIZE ];
//	unsigned int unread_len;

	void *m_clientdata;

	unsigned char connect_state;	//0(close) 1(connecting) 2(connected)
	bool blLogined;
	int intLastCount;


	

public:
	SCD_wxEXEC(wxSocketFlags /*flags*/);
	~SCD_wxEXEC();

	//because the ssh must be closed after all of its sftp are closed,
	//but it may be a trouble for users if you cancel all the sftp immediately
	//when closing ssh, so if you want to delete ssh, try to call Destroy() instead.
	//*** DON'T delete SCD_wxSSH DIRECTLY ***
private:
	//bool m_destroyed;
public:
	bool Destroy();

	//
	bool Connect(wxIPV4address& address, wxString _username);
	bool Login(wxString _username, wxString _password);
	bool isLogined();
	void Close();

	bool IsDisconnected();
	bool IsConnected();

	void Read(void * buffer, wxUint32 nbytes);
	void Write(const void * buffer, wxUint32 nbytes);
	void WriteSpecialKey(int key);
	void Unread(const void * buffer, wxUint32 nbytes);
	wxUint32 LastCount();

	void SetEventHandler(wxEvtHandler& handler, int id = -1);

	void SetClientData(void *data);
	void* GetClientData();
	void SetInputBuffer(char *buf,int len);
	void ReSize(int width,int height);
//	int from_backend(int is_stderr,const char *data, int len);
	void close_session();
	bool Connect(SiteInfo &si);
	void SetCMDParent(void *evt) {parent=evt;};
	void SetScrollBarPos(int ydelta);
	void SendTextToConsole(char *text);
	void AdjustBufferSize(int lines);
	

	//-------------------------------------------------
public:
//	SCD_wxSFTP* CreateSFTP();

	int session_closed;
	//void *logctx;
	//struct unicode_data ucsdata;
	//wxTimer m_timer;
	bool inited;
	//wxString outbuf;
	//SCD_Terminal *disp;
	char unread[30000];
	char input_buf[30000];
	int input_len;
	int unread_len;
    wxProcess *process;
	wxString send_buf;
	int caret_pos;
    wxOutputStream *m_out;
    wxInputStream *m_in,
                  *m_err;
	int m_pid;
	HWND m_hwnd;
	wxString title;
	wxArrayString his_com;
	int his_pos;
	int iswincmd;
	int	showed;
	
};


// ============================================================================
#endif //__SCD_WXEXEC_H__
