/******************************************************************************
 * Name:        scd_terminal.cpp
 * Purpose:     terminal display, data storing
 * Author:      Xie, Chun-Da (jakky1)
 * E-mail:      jakky1@gmail.com
 * Created:     2004.7
 * Copyright:   (C) 2004 Xie, Chun-Da
 * Licence:     GPL : http://www.gnu.org/licenses/gpl.html
 * Modified by:
 ******************************************************************************/


#ifndef SCD_TERMINAL_H
#define SCD_TERMINAL_H

#include "common.h"
#include <wx/caret.h>
#include <wx/clipbrd.h>
#include <ctype.h>

// ============================================================================



//typedef struct TerminalChar
struct TerminalChar
{
public:
	//bΦr , ΦrĤ@byte , ΦrĤGbyte
	typedef enum { CH_CHAR , CH_WORDFIRST , CH_WORDLAST } CHAR_TYPE;

private:

	struct		//Cݩ
	{
		unsigned char TextColor : 4;	//rC
		unsigned char BackColor : 4;	//IC
	} Color;

	struct 		//Sݩ
	{
		unsigned char isHighlight : 1;	//G
		unsigned char isUnderline : 1;	//u
		unsigned char isBlink : 1;		//{{

		unsigned char chartype : 2;
		unsigned char linktype : 3;
	} property;

public:

	char ch;

	static bool getAlwaysHighlight();
	static void setAlwaysHighlight(bool b);

	//wӦrO [bΦr] [ΦrĤ@ byte] [ΦrĤG byte]
	inline void setCharType( CHAR_TYPE t )
	{	property.chartype = t;	}
	inline CHAR_TYPE getCharType()
	{	return (CHAR_TYPE)property.chartype;	}

	//ӦrO_@p@
	inline void setLinkType( LINK_TYPE _l )
	{	property.linktype = _l;	}
	inline LINK_TYPE getLinkType()
	{	return (LINK_TYPE)property.linktype;	}

	//rSݩ
	inline void setHighlight(bool to_highlight)
	{	property.isHighlight = to_highlight ? 1 : 0;	}
	bool getHighlight()
	{	return (getAlwaysHighlight() || property.isHighlight) ? true : false;	}
	inline void setBlink(bool to_blink)
	{	property.isBlink = to_blink ? 1 : 0;	}
	inline bool getBlink()
	{	return property.isBlink ? true : false;	}
	inline void setUnderline(bool to_Underline)
	{	property.isUnderline = to_Underline ? 1 : 0;	}
	inline bool getUnderline()
	{
/*
#if defined(__WXGTK__)	//GTK ثe䴩ur, ҥHu\
		return false;
#else
*/
		return property.isUnderline ? true : false;
//#endif
	}

	//rCݩ
	inline void setTextColor(int ColorCode)
	{
		if( ColorCode >= 30 && ColorCode <= 37 )
			Color.TextColor = ColorCode - 30;
	}
	wxColour getTextColor(bool _selected = false);
	wxColour &getTextColorRef(bool _selected = false);
	inline int getTextColorCode()
	{	return Color.TextColor + 30;	}

   	//rIݩ
	inline void setBgColor(int ColorCode)
	{
		if( ColorCode >= 40 && ColorCode <= 47 )
			Color.BackColor = ColorCode - 40;
	}
	wxColour getBgColor(bool _selected = false);
	wxColour &getBgColorRef(bool _selected=false);
	wxBrush &getBgBrush(bool _selected);
	inline int getBgColorCode()
	{	return Color.BackColor + 40;	}

	wxString getANSICode();
	wxString getDiffANSICode(TerminalChar & _c);

	bool withSameProperty(TerminalChar & ch);

	void setColorCode(int ColorCode);
	static TerminalChar getDefaultCharProperty();

};


//ΨӴyzC terminal char ݩ

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// *************** SCD_Terminal O ***************
//
//1. ΨӴyz terminal  (rꤺe, CӦrݩ, etc...)
//2. tdø
//      repaint() ø
//      repaint(int x, int y, int w, int h) ø
//3. parse() , Ҧpq wxSocketBase::Read() o
//
// ********************************************************


//WX_DECLARE_OBJARRAY(TerminalChar, TermArrayOfColumn);
//WX_DEFINE_ARRAY_PTR(TerminalChar*,TermArrayOfColumn);
//WX_DEFINE_ARRAY_PTR(TermArrayOfColumn*,TermArrayOfLine);
//WX_DECLARE_OBJARRAY(TermArrayOfColumn, TermArrayOfLine);

struct link_list_s{
	TerminalChar *_line;	
	int _len;
	link_list_s *_n;
	link_list_s *_p;
};
typedef struct link_list_s link_list_t;

class SCD_Terminal
{


//---------------------------------------------------------------
//pG SCD_Terminal N|b wxScrolledWindow WøϪ,
//@wn]w setScrolledWindow() oӨ禡
//oӨ禡| SCD_Terminal bø(repaint())Hβʴ(updateCaret())ɭ,
//̷ wxScrolledWindow bmX۹
//o SCD_Terminal ~b wxScrolledWindow `
private:
    wxScrolledWindow *scrollwin;
public:
    inline void setScrolledWindow(wxScrolledWindow *win)
    {	scrollwin = win;	}
	int getLineCountInView();	//oثeܰϰ@@ܴXT
	void ScrollToCaret();	//ⱲbʨЩҦbB
//---------------------------------------------------------------


private:
	wxPoint server_stored_cur_pos;

public:
	SCD_Terminal(wxWindow *win,wxScrollBar *sb);
	~SCD_Terminal();

	void ResetTerminal();	//Ψӭm terminal ]w, CssuɥIs

	void setColumnRow(int _c, int _r);	//]w, C


	//г]w
private:
	//reach_line_end OЬO_wgF
	//pG col_count=80 , h reach_line_end ЬO_ cur_x = 80
	//]ڤW cur_x ൥ 80 ]| array out-of-bound
	//]γoܼưO
	//γBOb parse() ɦpGb cur_x=80 BѥXrꪺ
	//禡|۰ʸU@ (for ssh)
	bool reach_line_end;

public:
	void getXY(int *_x, int *_y)	//oЦm
	{
		if(_x)	*_x = cur_x;
	 	if(_y)	*_y = cur_y;
	}
	void gotoXY(int _x, int _y)	//Nв (_x,_y)
	{
			/*
		if( is_X_in_bound(_x) )	cur_x = _x;
		if( is_Y_in_bound(_y) )	cur_y = _y;
		else if ( _y < 0 ) cur_y =0;
		else if ( _y >= row_count ){
				cur_y=row_count-1;
		}
		*/
		last_x = cur_x;
		last_y = cur_y;
		cur_x=_x<0?0:(_x>=col_count?col_count-1:_x);
		cur_y=_y<0?0:(_y>=row_count?row_count-1:_y);

		updateCaret();
		reach_line_end = false;
	}
	/*
	void s_gotoXY(int _x, int _y )
	{
		
		if ( is_Y_in_bound(_y)) _cursor_y = _y;
		if ( is_X_in_bound(_x)) _cursor_x = _x+ (( _cur_lines > row_count)?_cur_lines-row_count:0);
	}
	
	void s_setScrollTopBottom(int _t,int _b)
	{
		_scroll_top = _top + _t;
		_scroll_bottom
	}
	*/
	inline void goUp(int _v = 1)			//ЩW
	{	gotoXY( cur_x , cur_y - _v );	ScrollToCaret();	}
	void goDown(int _v = 1)		//ЩU
	{	gotoXY( cur_x , cur_y + _v );	ScrollToCaret();	}
	void goLeft(int _v = 1)		//Щ
	{	gotoXY( cur_x - _v , cur_y );	ScrollToCaret();	}
	void goRight(int _v = 1)		//Щk
	{
		bool b = (cur_x >= col_count - 1);
		gotoXY( cur_x + _v , cur_y );
		ScrollToCaret();
		if(b)	reach_line_end = true;
	}
	void goLineHead()			//вP@檺}Y
	{	gotoXY( 0 , cur_y );	}
	void updateCaret();			//sЦm


	//ʵ
private:
	int m_scroll_region_top , m_scroll_region_bottom;
	bool m_isset_scroll_region_bottom;
public:
	inline void ScrollUp(int _v = 1);		//W
	void ScrollUp(int top, int bottom, int _v = 1);
	inline void ScrollDown(int _v = 1);	//U
	void ScrollDown(int top, int bottom, int _v = 1);

	//M
 	void cleanScreen(int type = 2);			//Mù
	void CleanLineTail();		//M
	void CleanLine(int _y);		//M

	void abs_InsertChar(int _v = 1);
	void abs_DeleteChar(int _v = 1);

	//J
	int parse(char *str , int len = -1 ,  int *scroll_count = NULL);		//Xr (䤤iHX)

	wxSize getWindowSize()	{	return wxSize( col_count*char_width, row_count*char_height );	}
	wxSize getCharSize()	{	return wxSize( char_width, char_height );	}

	//{{r method
private:
	bool hasBlinkChar;
protected:
	inline void setHasBlinkChar(bool _v)	{	hasBlinkChar = _v;	}
public:
	inline bool getHasBlinkChar()	{	return hasBlinkChar;	}
	void setBlinkCharVisibility(bool _v);	//O_ܰ{{r
	inline bool getBlinkCharVisibility()	{	return blBlinkCharVisibility;	}

	//sø
	void OnPaint(wxPaintEvent& event);
	void OnPaint(wxDC *dc);
	void repaint(bool eraseBackground = false);
	void repaint(wxDC *dc, int x, int y, int w, int h);

public:
	//ø
	void repaintChar(int _x, int _y);	//ܦm (_x,_y) r
	void repaintLine(int _y = -1);

	//Nƹyഫ۹ry
	void MouseXY_to_TextXY(int m_x, int m_y, int & t_x, int & t_y);

protected:
	void updateScrollBar(int linecount)
 	{
      	row_count = linecount;
      	if( scrollwin )	scrollwin->SetVirtualSize( getWindowSize() );
	}
private:
	TerminalChar  now_char_property;	//ثerݩ

	int col_count, row_count;	//terminal C
	int cur_x, cur_y;			//ЩҦbm
public:
	int getLineLength(int _line = -1);
	inline void getColumnRowCount(int *_col, int *_row)
 	{
		if(_col)	*_col = col_count;
		if(_row)	*_row = row_count;
  	}

private:

	int screen_width, screen_height;	//ee
	int char_width, char_height;	//reװ

	bool blBlinkCharVisibility;	//O_ܰ{{r

	bool is_X_in_bound(int _x)
	{	return ( _x >= 0 ) && ( _x < col_count );	}
	bool is_Y_in_bound(int _y)
	{	return ( _y >= 0 ) && ( _y < row_count );	}

	wxWindow *parentWindow;
	wxScrolledWindow *frontend;
	wxDC *currentDC;
	bool blEnableDrawing;

protected:
	void adjustLineCharInfo(int _y = -1);	//sYҦr type ݩ (P_bΦrMΦr)
	inline bool isWord(char first, char last);

public:
	//קKtΦ]shܧƤeӳye{{
	void BeginDrawing(wxDC *dc);
	void EndDrawing();
	void EndDrawing_NoCaret();
	void EnableDrawing(bool b)	{	blEnableDrawing = b;	}
public:
	inline bool isDrawing()	{	return (currentDC != NULL);	}
	inline wxDC* getDC()	//oثe DC
 	{
      	if( ! blEnableDrawing || ! getVisible() )	return NULL;
  		return currentDC;
    }

	wxCaret* getCaret()
 	{	return ( parentWindow == NULL ) ? NULL : parentWindow->GetCaret();	}

protected:
	bool isCurrentAWord();	//ХثeҳBmO_ΦrĤ@ byte
	bool isLeftAWord();		//ХثeҳBmO_Φr

private: bool isVisible;
public:
	void Show();
	inline void Hide()	{	isVisible = false;	getCaret()->Hide();		}
	inline bool getVisible()	{	
			if (!isVisible || !blEnableDrawing) 
					wxLogMessage("visible %d blEnableDrawing %d",isVisible,blEnableDrawing);
			return isVisible;	
	}

	inline wxWindow* getParentWindow()	{	return parentWindow;	}

	wxFont term_fnt;
	void SetFont(const wxFont& fnt);
	wxFont& GetFont()	{	return term_fnt;	}

private:
	typedef void (*ON_LINK_CLICKED_FUNC)(char *, LINK_TYPE);
	ON_LINK_CLICKED_FUNC OnLinkClickedFunc;
public:
	void SetOnLinkClickedFunc( ON_LINK_CLICKED_FUNC _f )	{	OnLinkClickedFunc = _f;	}

	//***** ƹƥ, ΨӺ޲z [r] ʧ@ *****//

protected:
	int start_x, start_y, end_x, end_y;	//rd򪺶}YM
	unsigned char selectState;	//0:| 1:U 2:br 3: (OdХ)
	inline bool isCharSelected(int _x, int _y);
	inline void getSelectionInfo(int *sx, int *sy, int *ex, int *ey)
	{
     	if( start_y < end_y
			|| ( start_y == end_y  &&  start_x <= end_x )  )
		{	*sx = start_x;	*sy = start_y;	*ex = end_x;	*ey = end_y;	}
		else
		{	*ex = start_x;	*ey = start_y;	*sx = end_x;	*sy = end_y;	}
	}

public:
	void OpenSelectionAsHyperlink();

	//ask if someone call you (find is any rung bell)
private:
	bool bBell;
public:
	bool isBell()
 	{
  		if( bBell )
  		{	bBell = false;	return true;	}
  		else return false;
	}


private:
    bool blEnableDoubleByteDetection;	//O_}줸\
public:
	inline void setEnableDoubleByteDetection(bool b)
    {
    	if( blEnableDoubleByteDetection == b )	return;
    	blEnableDoubleByteDetection = b;
    }
	inline bool getEnableDoubleByteDetection()
	{	return blEnableDoubleByteDetection;	}

protected:
	wxString GetLineWrapedString(char *txt);	//N txt ۰_, ϨC@檺rƤ|WLw
public:
	static void SetLineWrapedLength(int len);	//]w۰_檺
	static int GetLineWrapedLength();

public:

	//r, ƻsr
	void SelectAll();
	void CancelSelection();	//
	wxString GetSelectionContent(bool withANSI);	//oҿr
	wxString GetAllContent(bool withANSI);			//oҦr
	void CopySelectionToClipboard(bool withANSI);	//NrƻsŶKï
	inline bool isSelected()	{	return (selectState == 2 || selectState == 3);	}

	//ƹƥ (Bzrʧ@)
	void OnMouseLeftDown(wxMouseEvent& event);
	void OnMouseMotion(wxMouseEvent& event);
	void OnMouseLeftUp(wxMouseEvent& event);
	void OnMouseLeftDoubleClick(wxMouseEvent& event);

	void setTermMaxLine(int _l );
	void setLines(int _c,int _r);
	void assignDataTerm(int _c,int _r);
	void assignDispTerm(int _c,int _r);
	void repaintDispTerm(int _v,int orient);
	int getCurLines(){return _cur_lines;}
	void AdjustScrollBar();
	void ScrolledInt(wxScrollEvent &event);
	void repaintFull();
	void ScrollPageUp();
	void ScrollHalfPageInt(int orient);
	void DrawCaret();
	void HideCaret();
	void OnKillFocus(wxFocusEvent &event);
	void OnSetFocus(wxFocusEvent &event);
	void EndDrawing(int del);

	int wordtype(int uc);
	wxScrollBar *sbar;
	int lost_focus;
	bool app_keypad_keys;//command line modes or app mode,i.e vim
	void ResizeBufferSize(int new_buffer_size);
	int GetBufferSize(){return _max_line;}

//	TermArrayOfColumn * NewLine();
public:
	short wordness[256];
	int _max_line;
	int _dispcursy;
	int _dispcursx;
	int _cur_lines;
	int _top   ;
	int _bottom;
	int _old_sbar_pos;
	int _sbar_pos;
	int _sbar_bottom_pos;
	/*
	int _region_top =0;
	int _region_bottom =0;
	int _cursor_x =0;
	int _cursor_y =0;
	*/
	//wxBaseArrayPtrVoid *_lines;
	//TermArrayOfLine *_lines;
	TerminalChar **data_term;
	TerminalChar **disp_term;
	TerminalChar  **term_data;	//terminal CӦr, ݩ
	int head_step;
	link_list_t  *cur_disp_head;
	link_list_t *head;
	link_list_t *cur_head;
	int is_set_disp_cursor;
	int hide_cursor;
	int last_x;
	int last_y;
	wxBitmap *_caretbm;
	void *handle;
	wxBrush defaultBrush;
	int	pre_top;
	int updated;
	int alt_down;
	int *line_array;
	//int left_b;
	//int right_b;
};



// ============================================================================
#endif
