#ifndef SCD_TERMINAL_CPP
#define SCD_TERMINAL_CPP

#include "scd_terminal.h"
#include <wx/fontmap.h>

		//support scroll term screen
		//we need ignore _r number
		//new input socket data, will be always append to the end
		//so link list structure will be used, the origin array data
		//structure need to be redesigned.
		//two new data structure added,
		//dynamic line array and dynamic column array.
		//
		/*
		//no need to modify top bottom.
		if ( '\n' && '_cursor_x == _region_bottom ) {
			insert one new line at _cursor_x;
			//equal to scroll text up.
		}
		if ( 'L' ) {
			//for save max_lines usage,
			//we just replace the lines.
			clean lines at _cursor_x
			//equal to scroll text down
		}
		if ( 'M' ) {
			clean lines at _cursor_x
			move lines from _cursor_x to _region_bottom 
			//equal to scroll text up
		}
		 */
/*
#include <wx/arrimpl.cpp>

WX_DEFINE_OBJARRAY(TermArrayOfColumn);
*/


// ============================================================================

static bool always_highlight = false;	//ǤHqWr|㪺SOt, oӿﶵL̥iHҦrܦG
static int line_wraped_length = 80;
extern int global_max_lines;
int global_max_columns = 500;

#define TerminalColorTypeCount 8

//terminal rC
/*
static wxColour TerminalColors[2][TerminalColorTypeCount] =
{
	{	//`r (¬ŵQ)
		wxColour(  0,  0,  0), wxColour(128,  0,  0), wxColour(  0,128,  0), wxColour(128,128,  0),
		wxColour(  0,  0,128), wxColour(128,  0,128), wxColour(  0,128,128), wxColour(192,192,192)
	} ,
	{	//G
		wxColour(128,128,128), wxColour(255,  0,  0), wxColour(  0,255,  0), wxColour(255,255,  0),
		wxColour(  0,  0,255), wxColour(255,  0,255), wxColour(  0,255,255), wxColour(255,255,255)
	}
};
*/
//0		1	2	  3      4    5
//black red green yellow blue purple dian white
wxColour TerminalColors[2][TerminalColorTypeCount] =
{
	{	//`r (¬ŵQ)
		wxColour(  0,  0,  0), wxColour(187,  0,  0), wxColour(  0,187,  0), wxColour(187,187,  0),
		wxColour(  0, 0 ,187), wxColour(187,  0,187), wxColour(  0,187,187), wxColour(187,187,187)
	} ,
	{	//G
		wxColour(128,128,128), wxColour(255,  0,  0), wxColour(  0,255,  0), wxColour(255,255,  0),
		wxColour(  0,  62,255), wxColour(255,  40,255), wxColour(  0,255,255), wxColour(255,255,255)
	}
};

wxColour SelTerminalColors[2][TerminalColorTypeCount] =
{
	{	//`r (¬ŵQ)
		wxColour(  0,  0,  0), wxColour(187,  0,  0), wxColour(  0,187,  0), wxColour(187,187,  0),
		wxColour(  0, 0 ,187), wxColour(187,  0,187), wxColour(  0,187,187), wxColour(187,187,187)
	} ,
	{	//G
		wxColour(128,128,128), wxColour(255,  0,  0), wxColour(  0,255,  0), wxColour(255,255,  0),
		wxColour(  0,  62,255), wxColour(255,  40,255), wxColour(  0,255,255), wxColour(255,255,255)
	}
};

/*
static wxColour SelTerminalColors[2][TerminalColorTypeCount] =
{
	{	//`r (¬ŵQ)
		wxColour(  ~0,  ~0,  ~0), wxColour(~187,  ~0,  ~0), wxColour(  ~0,~187,  ~0), wxColour(~187,~187,  ~0),
		wxColour(  ~0, ~0 ,~187), wxColour(~187,  ~0,~187), wxColour(  ~0,~187,~187), wxColour(~187,~187,~187)
	} ,
	{	//G
		wxColour(~128,~128,~128), wxColour(~255,  ~0,  ~0), wxColour(  ~0,~255,  ~0), wxColour(~255,~255,  ~0),
		wxColour(  ~0,  ~62,~255), wxColour(~255,  ~40,~255), wxColour(  ~0,~255,~255), wxColour(~255,~255,~255)
	}
};
*/

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
wxColour TerminalChar::getTextColor(bool _selected)
{
	if( ! _selected )
		return TerminalColors[ getHighlight() ][ Color.TextColor ];
	else
	{
		wxColour c( TerminalColors[ getHighlight() ][ Color.TextColor ] );
		c.Set( ~c.Red(), ~c.Green(), ~c.Blue() );
		return c;
	}
}

wxColour &TerminalChar::getTextColorRef(bool _selected)
{
	if( ! _selected )
		return TerminalColors[ getHighlight() ][ Color.TextColor ];
	else{
		//wxColour c( TerminalColors[ getHighlight() ][ Color.TextColor ] );
		//c.Set( ~c.Red(), ~c.Green(), ~c.Blue() );
		return SelTerminalColors[0][Color.BackColor];//.Set( ~c.Red(), ~c.Green(), ~c.Blue() );
		//return SelTerminalColors[ getHighlight() ][Color.TextColor];
		//	Set( ~c.Red(), ~c.Green(), ~c.Blue() );
	//	return c;
	}
}

wxColour &TerminalChar::getBgColorRef(bool _selected)
{
	if( ! _selected )
		return TerminalColors[0][ Color.BackColor ];
	else{
//		wxColour c( TerminalColors[0][ Color.BackColor ] );
		return SelTerminalColors[ getHighlight() ][Color.TextColor];
		//return SelTerminalColors[0][Color.BackColor];//.Set( ~c.Red(), ~c.Green(), ~c.Blue() );
		//return ;
	}
}

wxColour TerminalChar::getBgColor(bool _selected)
{
	if( ! _selected )
	return TerminalColors[0][ Color.BackColor ];
	else
	{
		wxColour c( TerminalColors[0][ Color.BackColor ] );
		c.Set( ~c.Red(), ~c.Green(), ~c.Blue() );
		return c;
	}
}

// ----------------------------------------------------------------------------
bool TerminalChar::getAlwaysHighlight()
{	return always_highlight;	}
// ----------------------------------------------------------------------------
void TerminalChar::setAlwaysHighlight(bool b)
{	always_highlight = b;	}
// ----------------------------------------------------------------------------
wxString TerminalChar::getANSICode()
{
	wxString code;
	TerminalChar def_ch = getDefaultCharProperty();
	code = _T("\x1b[");
	code += _T("0");	//Gשΰ{{Ωuݩʪ
	if( getHighlight() )	code += _T(";1");
	if( getUnderline() )	code += _T(";4");
	if( getBlink() )	code += _T(";5");
	if( getTextColorCode() != def_ch.getTextColorCode() )	code += wxString::Format( _T(";%d"), getTextColorCode() );
	if( getBgColorCode()   != def_ch.getBgColorCode() )		code += wxString::Format( _T(";%d"), getBgColorCode() );
	code += _T("m");
	return code;
}
// ----------------------------------------------------------------------------
wxString TerminalChar::getDiffANSICode(TerminalChar & _c)
{
	wxString code;
	code = _T("\x1b[");

	if(  ( _c.getHighlight() && ! getHighlight() ) 	//pGݭnGשΰ{{Ωuݩʪ
		|| ( _c.getBlink() && ! getBlink() )
		|| ( _c.getUnderline() && ! getUnderline() ) )
	{
		TerminalChar def_ch = getDefaultCharProperty();
		code += _T(";");
		if( getHighlight() )	code += _T("1;");
		if( getUnderline() )	code += _T("4;");
		if( getBlink() )	code += _T("5;");
		if( getTextColorCode() != def_ch.getTextColorCode() )	code += wxString::Format( _T("%d;"), getTextColorCode() );
		if( getBgColorCode()   != def_ch.getBgColorCode() )		code += wxString::Format( _T("%d"), getBgColorCode() );
	}
	else
	{
		if( ! _c.getHighlight() && getHighlight() )	code += _T("1;");
		if( ! _c.getUnderline() && getUnderline() )	code += _T("4;");
		if( ! _c.getBlink() && getBlink() )	code += _T("5;");
		if( _c.getTextColorCode() != getTextColorCode() )	code += wxString::Format( _T("%d;"), getTextColorCode() );
		if( _c.getBgColorCode() != getBgColorCode() )		code += wxString::Format( _T("%d"), getBgColorCode() );
	}
	if( code.Last() == ';' )	code.RemoveLast();
	code += _T("m");
	return code;
}
// ----------------------------------------------------------------------------
bool TerminalChar::withSameProperty(TerminalChar & ch)
{
	if( getHighlight() != ch.getHighlight() )	return false;
	if( getBlink() != ch.getBlink() )	return false;
	if( getUnderline() != ch.getUnderline() )	return false;
	if( getTextColor() != ch.getTextColor() )	return false;
	if( getBgColorCode() != ch.getBgColorCode() )	return false;
	return true;
}
// ----------------------------------------------------------------------------
void TerminalChar::setColorCode(int ColorCode)
{
	if( ColorCode >= 30 && ColorCode <= 37 )
		setTextColor(ColorCode);
	else if( ColorCode >= 40 && ColorCode <= 47 )
		setBgColor(ColorCode);
	else if( ColorCode == 0 )
	{
		setTextColor(37);
		setBgColor(40);
		setHighlight(false);
		setBlink(false);
		setUnderline(false);
	}
	else if( ColorCode == 1 )
		setHighlight(true);
	else if( ColorCode == 4 )
		setUnderline(true);
	else if( ColorCode == 5 )
		setBlink(true);
	else if( ColorCode == 7 )	//ҰʤϬۦ
	{
		setTextColor(30);
		setBgColor(47);
	}
	else if( ColorCode == 27 )	//Ϭۦ
	{
		setTextColor(37);
		setBgColor(40);
	}else {
#ifdef __WXDEBUG__
	//	wxLogMessage("unknown setColorCode %d",ColorCode);
#endif
	}
}
// ----------------------------------------------------------------------------
TerminalChar TerminalChar::getDefaultCharProperty()
{
	TerminalChar tc;
	tc.setTextColor(37);
	tc.setBgColor(40);
	tc.setHighlight(false);
	tc.setBlink(false);
	tc.setUnderline(false);
	tc.ch = '\0';
	tc.setCharType(CH_CHAR);
	tc.setLinkType(LINK_NONE);
	return tc;
}
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
SCD_Terminal::SCD_Terminal(wxWindow *win,wxScrollBar *sb)
{
	app_keypad_keys=FALSE;
	line_array = NULL;
	char * defaults[] = {
	    ",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0",
	    ",0,1,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1",
	    ",1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2",
	    ",1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1",
	    ",1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1",
	    ",1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1",
	    ",2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2",
	    ",2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2"
	};
	for ( int i = 0; i < 256; i += 32) {
		char buf[20];
		//char buf2[256], 
		char *p;
		int j;
		p = (char *)(defaults[i / 32]);
		for (j = i; j < i + 32; j++) {
		    while (*p && *p != ',')	p++;
			//char *q = p;
			//strncpy(buf,q,p-q+1);
			//buf[p-q+1]='\0';
		    //if (*p == ',') *p++ = '\0';
			p++;
		    wordness[j] = atoi(p);
		}
    }
//	updated = 0;
	alt_down = 0;
	pre_top =0;
	lost_focus=0;
	_top   = 0;
	_bottom= 0;
	hide_cursor=0;
	head=NULL;
	cur_head=NULL;
	_dispcursy=_dispcursx=-1;
	is_set_disp_cursor=0;
	sbar=sb;
	_sbar_bottom_pos=_sbar_pos=0;
	/*
	_region_top = 0;
	_region_bottom = 0;
	_cursor_x =0;
	_cursor_y =0;
	*/
//	_lines = new TermArrayOfLine();
	_max_line = global_max_lines;
	term_data = NULL;
	data_term=NULL;
	disp_term=NULL;
	currentDC = NULL;
	scrollwin = NULL;
	parentWindow = win;
	isVisible = false;
	blEnableDrawing = true;

	SetFont( parentWindow->GetFont() );
	char_height = parentWindow->GetFont().GetPointSize();
	char_width  = char_height / 2;

	term_data = NULL;
	setLines(_max_line,24);
	m_scroll_region_top=0;
	m_scroll_region_bottom=23;
	cur_head=head;
	_cur_lines = 24;
	setColumnRow(80,24);
//	initLines();
	//setTermMaxLine(200);

	gotoXY(0,0);
	blBlinkCharVisibility = true;
	setHasBlinkChar(false);
	OnLinkClickedFunc = NULL;

	selectState = 0;	//ϥΪ̩|}lr
	blEnableDoubleByteDetection = true;

	now_char_property = now_char_property.getDefaultCharProperty();
	bBell = false;

	ResetTerminal();
}

// ----------------------------------------------------------------------------

SCD_Terminal::~SCD_Terminal()
{
//	for(int y=0;y<row_count;y++)	delete term_data[y];
	//delete term_data;
//	_lines->Clear();
//	delete _lines;
	delete disp_term;
	delete data_term;
	link_list_t *p;
	link_list_t *n=head;
	for (int i=0;i<_max_line;i++){
		p=n;
		n=p->_n;
		delete p->_line;
		delete p;
	}
	if ( line_array ) delete line_array;
	//delete term_data;
}
// ----------------------------------------------------------------------------
void SCD_Terminal::ResetTerminal()
{
	m_scroll_region_top = 0;
	m_isset_scroll_region_bottom = true;
}
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
void SCD_Terminal::SetFont(const wxFont& fnt)
{
	//]wr, rjp, 
	term_fnt = fnt;

	wxClientDC dc(parentWindow);
	dc.SetFont(fnt);
	char_width  = dc.GetCharWidth();
	char_height = dc.GetCharHeight();
/*
	wxCaret *caret = parentWindow->GetCaret();
	if(caret)	caret->SetSize( char_width, 2 );
	*/

	if( scrollwin )
	{
		int _x, _y;
		scrollwin->GetViewStart( &_x, &_y );
		scrollwin->SetScrollbars( char_width, char_height, 80, row_count, _x, _y );
	}
}
/*
void SCD_Terminal::HideCusor()
{
	
}
*/
// ----------------------------------------------------------------------------
void SCD_Terminal::OnSetFocus(wxFocusEvent &event)
{
	lost_focus=0;	
	DrawCaret();
}

void SCD_Terminal::OnKillFocus(wxFocusEvent &event)
{
	lost_focus=1;	
	DrawCaret();
}

void SCD_Terminal::Show()
{
	if( getVisible() )	return;
	if( parentWindow == NULL )	return;
	
	isVisible = true;

	if(blEnableDrawing)	repaint();	//ø

	//ܴ
	/*
	wxCaret *caret = parentWindow->GetCaret();
	if( caret == NULL )
	{
		wxMessageBox(_T("caret not found"));
		parentWindow = NULL;
	}
	else
	{
		caret->SetSize( char_width, 2 );
		caret->Show();
	}
	*/
}
// ----------------------------------------------------------------------------
void SCD_Terminal::setColumnRow(int _c, int _r)
{
	if( term_data == NULL )
	{	col_count = 0;	row_count = 0;	}

	if( _c == col_count && _r == row_count )	return;
/*	
	TerminalChar **old_term_data = term_data;

	//term_data = new (TerminalChar*)[_r];
	term_data = new (TerminalChar*[_r]);

	for(int i=0;i<_r;i++)
		term_data[i] = new TerminalChar[_c];

	TerminalChar dch = TerminalChar::getDefaultCharProperty();
	int _k = (_c > col_count) ? col_count : _c;
	for(int y=0;y<_r;y++)
	{
		int x = 0;
		if( y < row_count && old_term_data )
		{	for(x=0;x<_k;x++)	term_data[y][x] = old_term_data[y][x];	}
		for(;x<_c;x++)	term_data[y][x] = dch;
	}

	//MªO
	if( old_term_data )
	{
     	for(int y=0;y<row_count;y++)	delete old_term_data[y];
     	delete old_term_data;
	}
*/
	int tr=row_count?row_count:24;
	int back= abs(_r-tr);

	col_count = _c;
	_cur_lines -=(row_count?row_count:24);
	row_count = _r;
	if ( line_array ) {
		delete line_array;
	}
	line_array = new int[row_count];
	_cur_lines +=row_count;

	//wxLogMessage("cur_x cur_y %d %d _c _r %d %d back %d",cur_x,cur_y,_c,_r,back);
	for ( int i=0;i<back;i++){
		if ( _r > tr ) {
			if ( cur_head != head ) {
				cur_head=cur_head->_p;
				//goDown(1);
				cur_y++;
			}else{
				break;
			}
		}else{
			if ( cur_head != head ) {
			cur_head=cur_head->_n;
			//goUp(1);
			cur_y --;
			}else{
				break;
			}
		}
	}
	
		
	if (m_isset_scroll_region_bottom == true ) {
		m_scroll_region_bottom=_r -1;
//		_region_bottom = _r-1;
	}

	//wxLogMessage("cur_x cur_y %d %d",cur_x,cur_y);
	if( cur_x >= _c )	cur_x = _c - 1;
	if( cur_y >= _r )	cur_y = _r - 1;
	{
		if (data_term) delete data_term;
		data_term = new (TerminalChar*[_r]);
		if (disp_term) delete disp_term;
		disp_term = new (TerminalChar*[_r]);
		 
		assignDataTerm(_c,_r);
		assignDispTerm(_c,_r);
		AdjustScrollBar();
	}
}

void SCD_Terminal::ScrolledInt(wxScrollEvent &event)
{
	if ( event.GetPosition() != _sbar_pos ){
		//wxLogMessage("scrollbar %d",event.GetPosition());
		int old_pos =_sbar_pos; 
		_sbar_pos = event.GetPosition();
		//if ( _sbar_pos != sbar->GetRange()-sbar->GetThumbSize()){
		assignDispTerm(col_count,row_count);
		repaintDispTerm(abs(old_pos-_sbar_pos),old_pos>_sbar_pos);
		//}
	}
}

inline void SCD_Terminal::repaintDispTerm(int _v,int orient)
{
	wxDC *dc = new wxClientDC( getParentWindow() );
	/*
	{
		int _w, _h;
		_w = col_count * char_width;
		_h = ( row_count - _v ) * char_height;
	BeginDrawing(dc);
	dc->SetBrush(*wxBLACK_BRUSH);
	dc->DrawRectangle(0,0,_w,row_count*char_height);
	for(int j=0;j<row_count;j++)
	{
		repaintLine(j);
		//for (int i=0;i<col_count;i++) repaintChar(i,j);
	}
	DrawCaret();
	EndDrawing(false);
	}
	return;
	*/
	BeginDrawing(dc);
	{	
		int _w, _h;
		_w = col_count * char_width;
		_h = ( row_count - _v ) * char_height;
		
		//dc->SetBrush(*wxBLACK_BRUSH);
		if ( _v < row_count ) { 
			if (orient == 1 ){//scrollup
				dc->Blit( 0, _v*char_height, _w , _h , dc, 0, 0 );
				//dc->DrawRectangle(0,0,_w,_v*char_height);
			}else{
				dc->Blit( 0, 0, _w , _h , dc, 0, _v*char_height );
				//dc->DrawRectangle(0,(row_count - _v)*char_height,_w,_v*char_height);
			}
		}else{
		//repaintLine();
			_v = row_count;
			//dc->DrawRectangle(0,0,_w,row_count*char_height);
		}
		for ( int i=0;i<_v;i++){
			if (orient == 1) {
				repaintLine(i);
			}else{
				repaintLine(row_count-i-1);
			}
		}
	}
	DrawCaret();
	EndDrawing(true);
	/*
	if ( _sbar_pos == _sbar_bottom_pos ) {
		DrawCaret();
		EndDrawing();
	}else{
		EndDrawing_NoCaret();
	}
	*/
}

void SCD_Terminal::repaintFull()
{
		wxDC *dc = NULL;
		if( getVisible() )
		{
			AdjustScrollBar();
			dc = new wxClientDC( getParentWindow() );
			BeginDrawing(dc);
			repaint();
			DrawCaret();
			EndDrawing(true);
		}
		//if( getVisible() )	
}

inline void SCD_Terminal::AdjustScrollBar()
{
	int range=_cur_lines>_max_line?_max_line:_cur_lines;
	int pos = range - row_count;
	sbar->SetScrollbar(pos,row_count,range,row_count);
	//sbar->SetScrollbar(pos,row_count,pos,row_count);
	_sbar_bottom_pos=pos;
	_sbar_pos=pos;
	/*
	if ( _cur_lines > _max_line ){
	pos=_max_line-row_count;
		sbar->SetScrollbar(pos,row_count,_max_line,row_count);
	}else{
		pos=_cur_lines-row_count;
		sbar->SetScrollbar(pos,row_count,_cur_lines,row_count);
	}
	*/
	//wxLogMessage("adjust scroll bar %d,%d,%d",pos,row_count,range);
		/*
	wxSize char_size=getCharSize();
	_cur_lines
	->SetScrollBar(wxVERTICAL,_cur_lines,row_count,_cur_lines);
	*/
}

 void SCD_Terminal::assignDataTerm(int _c,int _r)
{
	link_list_t *p=cur_head;
	for ( int i=0; i< _r ; i++ ){
		if ( _c > p->_len ) {
			TerminalChar dch = TerminalChar::getDefaultCharProperty();
			TerminalChar *o_line=p->_line;
			p->_line=new TerminalChar[_c];
			int j=0;
			for ( j=0;j< p->_len;j++){
				p->_line[j]=o_line[j];
			}
			delete o_line;
			for ( ;j<_c;j++){
					p->_line[j]=dch;
			}
			p->_len=_c;
		}
		data_term[i]= p->_line;
		p=p->_n;
	}
	term_data=data_term;
	//disp_term=term_data;
}


void SCD_Terminal::ScrollHalfPageInt(int orient)
{
	int count=row_count/2;
//	int _old_pos = _sbar_pos;
	int c_pos = orient?_sbar_pos-count:_sbar_pos+count;
	if ( c_pos > _sbar_bottom_pos ){
		c_pos = _sbar_bottom_pos;
		count = _sbar_bottom_pos - _sbar_pos;
	}else if ( c_pos < 0 ) {
		c_pos = 0;
		count = _sbar_pos - 0;
	}
	sbar->SetThumbPosition(c_pos);	
	_sbar_pos = c_pos;
	assignDispTerm(col_count,row_count);
	repaintDispTerm(count,orient);

}

void SCD_Terminal::assignDispTerm(int _c,int _r)
{
	link_list_t *p=cur_head;
	int i=0;
	int step= _sbar_bottom_pos - _sbar_pos ;
	for ( i=0;i<step;i++){
		p=p->_p;
	}
	cur_disp_head = p;

	for ( i=0; i< _r ; i++ ){
		if ( _c > p->_len ) {
			TerminalChar dch = TerminalChar::getDefaultCharProperty();
			TerminalChar *o_line=p->_line;
			p->_line=new TerminalChar[_c];
			int j=0;
			for ( j=0;j< p->_len;j++){
				p->_line[j]=o_line[j];
			}
			delete o_line;
			for ( ;j<_c;j++){
					p->_line[j]=dch;
			}
			p->_len=_c;
		}
		disp_term[i]= p->_line;
		p=p->_n;
	}
	//wxLogMessage("assignDispTerm %d,%d",_c,_r);
	//term_data=data_term;
}
// ----------------------------------------------------------------------------
void SCD_Terminal::BeginDrawing(wxDC *dc)	//קKtΦ]shܧƤeӳye{{
{
	if( ! getVisible() )	return;
	if ( currentDC != NULL ){
		wxLogMessage("SCD_Terminal::BeginDrawing recursive call BeginDrawing?");
	}
	if (!dc->Ok()){
		wxLogMessage("DC has error!!");
		return;
	}
	currentDC = dc;
	if(currentDC == NULL)	return;
	if(scrollwin)	scrollwin->PrepareDC(*currentDC);

	if(parentWindow != NULL)
	{
		parentWindow->GetCaret()->Move(-100, -100);
		hide_cursor = 1;
		currentDC->SetFont( GetFont() );
	}
	//currentDC->Clear();
	//return;
   	currentDC->BeginDrawing();
	currentDC->SetBackgroundMode(wxSOLID);
	currentDC->SetPen(*wxTRANSPARENT_PEN);	//T DrawRectangle() ɥ Pen e
}
// ----------------------------------------------------------------------------
void SCD_Terminal::EndDrawing()
{
	if( ! getVisible() )	return;
	if( currentDC != NULL ) {
			currentDC->EndDrawing();
			//currentDC->Clear();
	//		delete currentDC;
	}
	currentDC = NULL;
	updateCaret();
}

void SCD_Terminal::EndDrawing(int del)
{
	if( ! getVisible() )	return;
	if( currentDC != NULL ) {
			currentDC->EndDrawing();
			//currentDC->Clear();
			if ( del ) delete currentDC;
	}
	currentDC = NULL;
	updateCaret();
}
//must call between BeginDrawing & EndDrawing
inline void SCD_Terminal::HideCaret()
{
	repaintChar(cur_x,cur_y);
}

inline void SCD_Terminal::DrawCaret()
{
	//return;
	if ( !getVisible()) return;
	//if ( isDrawing ()) return;
	if ( _sbar_pos != _sbar_bottom_pos ) return;

	int o=0;
	if (!currentDC){
		wxDC *dc = new wxClientDC( getParentWindow() );
		BeginDrawing(dc);
		o=1;
	}
	//wxLogMessage("cur_x cur_y %d %d",cur_x,cur_y);
				/*
		wxDC *dc =NULL;
		if( getVisible() && getDC() == NULL )
		{
			dc = new wxClientDC( getParentWindow() );
			BeginDrawing(dc);
		}

		*/
		//dc->DrawRectangle( last_x*char_width , last_y*char_height , 
		//				char_width , char_height);
		//repaintChar(last_x,last_y);
		//wxBrush ob=currentDC->GetBrush();
	if (currentDC) {
		int ol=currentDC->GetLogicalFunction();
		repaintChar(cur_x,cur_y);
		currentDC->SetLogicalFunction(wxXOR);
		if ( lost_focus ){
			//currentDC->SetBrush( wxBrush(*wxWHITE,wxSOLID ));

			currentDC->SetBrush( *wxWHITE_BRUSH);
		}else{
			//currentDC->SetBrush( wxBrush(*wxGREEN,wxSOLID ));
			currentDC->SetBrush( *wxGREEN_BRUSH);
		}
		//wxLogMessage("cur_x cur_y %d %d",cur_x,cur_y);
		currentDC->DrawRectangle( cur_x*char_width , cur_y*char_height , 
						char_width , char_height);
		currentDC->SetLogicalFunction(ol);
	}
		//currentDC->SetBrush(ob);
#ifdef __WXDEBUG__
		//wxLogMessage("draw caret %d %d",cur_x,cur_y);
#endif
		//dc->EndDrawing();
		//dc->SetBrush( ob );
	if ( o )  EndDrawing(true);
}

void SCD_Terminal::EndDrawing_NoCaret()
{
	if( ! getVisible() )	return;
	if( currentDC != NULL ) currentDC->EndDrawing();
	currentDC = NULL;
	//updateCaret();
}
// ----------------------------------------------------------------------------
int SCD_Terminal::getLineCountInView()	//oثeܰϰ@@ܴXT
{
	wxSize ws = getParentWindow()->GetClientSize();
	wxSize cs = getCharSize();
	return ws.GetHeight() / cs.GetHeight();
}
// ----------------------------------------------------------------------------
void SCD_Terminal::ScrollToCaret()
{
    if( scrollwin == NULL )	return;
    
	int lc = getLineCountInView();

	//pGЩҳBmWXbܽd, hʱb
	int _vx, _vy;
	scrollwin->GetViewStart(&_vx, &_vy);	//in scroll units
   	if( cur_y < _vy )	scrollwin->Scroll( -1, cur_y );
   	else if( cur_y >= _vy + (lc-1) )	scrollwin->Scroll( -1, cur_y - (lc-1) );
	//repaint();	//ݭn repaint() ]b wxScrolledWindow::Scroll() ɭ, wxScrolledWindow N|۰ Refresh ݭnø
}
// ----------------------------------------------------------------------------
void SCD_Terminal::updateCaret()
{
	return;
	/*
	if( isDrawing() )	return;
	if( ! getVisible() )	return;

	wxCaret *c;
	c = getCaret();
	
	if( c != NULL )
	{
     	int _x , _y;
		//int _disp_x,_disp_y;
     	_x = cur_x * char_width;
     	_y = cur_y * char_height + char_height - 2;
     	if( scrollwin )	scrollwin->CalcScrolledPosition(_x,_y,&_x,&_y);
		
		if ( _sbar_pos != _sbar_bottom_pos ) {
			c->Move(-100,-100);
			hide_cursor = 1;
		}else{
			c->Move( _x , _y );
			//hide_cursor = 0;
		}
		//c->Move( _disp_x , _disp_y );
	}
	*/
	/*
		if ( !is_set_disp_cursor ) {
			_dispcursy = cur_y;
			_dispcursx = cur_x;
		}
		_disp_x = _dispcursx * char_width;
     	_disp_y = _dispcursy * char_height + char_height - 2;
		*/
}
// ----------------------------------------------------------------------------
void SCD_Terminal::cleanScreen(int type)
{
	//type==0 : Erase from current position to end (inclusive)
	//type==1 : Erase from beginning to current position (inclusive)
	//type==2 : Erase entire display

	selectState = 0;

	TerminalChar defaultCharProperty = now_char_property.getDefaultCharProperty();
	for(int y=0;y<row_count;y++)
	{
		if( (type==0 && y>cur_y) || (type==1 && y<cur_y) || type==2 )
		{	CleanLine(y);	continue;	}
		else if(cur_y==y)
		{
			for(int x=0;x<col_count;x++)
			{
				if( (type==0 && x>=cur_x) || (type==1 && x<=cur_x) )
					term_data[y][x] = defaultCharProperty;
			}
		}
	}

	if(type==2)
	{
		setHasBlinkChar(false);
		gotoXY(0,0);
	}
	else repaintLine(cur_y);
}
// ----------------------------------------------------------------------------
void SCD_Terminal::CleanLine(int _y)
{
	TerminalChar defaultCharProperty = now_char_property.getDefaultCharProperty();

	for(int x=0;x<col_count;x++)
		term_data[_y][x] = defaultCharProperty;

	wxDC *dc = getDC();
	if(dc != NULL)
 	{
	   // dc->SetBrush( wxBrush( TerminalChar::getDefaultCharProperty().getBgColor() , wxSOLID ) );
	   //dc->SetBrush( *wxBLACK_BRUSH);
	   dc->SetBrush( TerminalColors[0][0]);
	   	dc->DrawRectangle(0, char_height * _y, char_width * col_count , char_height );
	}
}
// ----------------------------------------------------------------------------
void SCD_Terminal::CleanLineTail()
{
	TerminalChar defaultCharProperty = now_char_property.getDefaultCharProperty();

	for(int x=cur_x;x<col_count;x++)
		term_data[cur_y][x] = defaultCharProperty;
}
// ----------------------------------------------------------------------------
void SCD_Terminal::abs_InsertChar(int _v)
{
	int i=0;
	for(i=col_count-1;i-_v>=cur_x;i--)	{//eƷh᭱
		term_data[cur_y][i] = term_data[cur_y][i-_v];
	}
	TerminalChar defaultCharProperty = now_char_property.getDefaultCharProperty();
	//᭱ƲM
	for( i=0;i<_v;i++){
		term_data[cur_y][cur_x+i] = defaultCharProperty;
	}
}
// ----------------------------------------------------------------------------
void SCD_Terminal::abs_DeleteChar(int _v)
{
	int i=0;
	for(i=cur_x+_v;i<col_count;i++)	{//᭱Ʒhe
		term_data[cur_y][i-_v] = term_data[cur_y][i];
	}
	TerminalChar defaultCharProperty = now_char_property.getDefaultCharProperty();
	//᭱ƲM
	for( i=0;i<+_v;i++){
		term_data[cur_y][col_count-1-i] = defaultCharProperty;
	}
}
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
void SCD_Terminal::ScrollUp(int _v)
{
	int bot;
	if(m_isset_scroll_region_bottom)	bot = m_scroll_region_bottom;
	else bot = row_count - 1;
	ScrollUp( m_scroll_region_top , bot , _v );
}
// ----------------------------------------------------------------------------
void SCD_Terminal::ScrollUp(int top, int bottom, int _v)	//wd򪺨C@橹Wh
{
	if(_v > bottom - top)	_v = bottom - top;
	{
		//insert lines from cur_y;
		if ( bottom != row_count-1 ) {//edit mode?
			//we only replace content of line, for save max_line usage
			//user don't care about the history of edit
			//TerminalChar *tmp_lines[1000];

			//int i=0;
			//for( i=0;i<_v;i++)	{tmp_lines[i] = term_data[top+i];	}//Ȧse _v 
			for(int y=top+_v;y<=bottom;y++) //ѤWӤU, h
				for ( int i=0;i<col_count;i++){
					term_data[y-_v][i] = term_data[y][i];
				}

		}else{//command line mode?
			/*
			if ( bottom == row_count -1 ){
			}else{
				wxLogMessage("_v %d",_v);
				link_list_t *p=cur_head;
				int j=0;
				//move p to region_bottom
				for ( j=0;j<bottom;j++){
					p=p->_n;
				}
				link_list_t *r_p=p;
				link_list_t *r_a=p->_n;
				int n_data=j;
				//and then move p to term_bottom;
				for ( ;j<row_count-1;j++){
					p=p->_n;
				}
				link_list_t *b_p=p;
				//link_list_t *b_after=p->_n;
				//move lines from b_p->_n before r_p->_n;
				for ( j=0;j<_v;j++){
					p=p->_n;
					if ( p== head ) {
						//exceed max_line
						head=head->_n;
					}
					//cur_head=cur_head->_n;
				}
				r_p->_n = b_p->_n;
				b_p->_n = p->_n;
				p->_n=r_a;
			}
			*/
			for ( int j=0;j<_v;j++){
			 cur_head=cur_head->_n;
			}
			_cur_lines+=_v;
			head_step = _cur_lines < _max_line?_max_line-_cur_lines:0;

			assignDataTerm(col_count,row_count);
			AdjustScrollBar();
			//repaintChar(cur_x,cur_y);
			//repaintChar(last_x,last_y);
		}
		//wxLogMessage("_cur_lines %d",_cur_lines);
		//r_p->_n = b_after;
		//reassign data_term on link_list;
	}
	{
		wxDC *dc = getDC();
		if(dc != NULL)
		{
			int _w, _h;
			_w = col_count * char_width;
			_h = ( bottom - top + 1 - _v ) * char_height;
			/*
			dc->SetBrush(*wxBLACK_BRUSH);
			dc->DrawRectangle(0,top*char_height,_w,_v*char_height);
			*/
			dc->Blit( 0, top*char_height, _w , _h , dc, 0, (top+_v)*char_height );
		}
		for( int i=0;i<_v;i++) {
			CleanLine(bottom-_v+1+i);
	   	}
	}

/*
	for( i=0;i<_v;i++)
	{
		term_data[bottom-_v+1+i] = tmp_lines[i];
		CleanLine(bottom-_v+1+i);
	}
	*/
	/*
	//	term_data[bottom-_v+1+i] = tmp_lines[i];
	{
		i =0;
		int real_top = _top+top;
		int real_bottom = _top + bottom;
		TermArrayOfColumn *col =NULL;
				//col->Alloc();
				//col = _lines->Item(0);
		for ( i=0;i<_v;i++) {
			col=new TermArrayOfColumn();
			_lines->Insert(col,real_bottom+1);
		}
		if ( _cur_lines == _max_line ) {
			_lines->RemoveAt(0);
		}else{
			_cur_lines +=_v;
			_top +=_v;
		}
	}
	*/
}

// ----------------------------------------------------------------------------

void SCD_Terminal::ScrollDown(int _v)
{
	int bot;
	if(m_isset_scroll_region_bottom)	bot = m_scroll_region_bottom;
	else bot = row_count - 1;
	ScrollDown( m_scroll_region_top , bot , _v );
}

// ----------------------------------------------------------------------------
void SCD_Terminal::ScrollDown(int top, int bottom, int _v)
{
	//TerminalChar *tmp_lines[1000];

	if(_v > bottom - top)	_v = bottom - top;

	//int i=0;
	//for(i=0;i<_v;i++){	tmp_lines[i] = term_data[bottom-i];	}//Ȧs᭱ _v 
	for(int y=bottom-_v;y>=top;y--) //ѤUӤW, h
		for (int i =0;i<col_count;i++){
		term_data[y+_v][i] = term_data[y][i];
		}

	wxDC *dc = getDC();
	if(dc != NULL)
	{
		int _w, _h;
		_w = col_count * char_width;
		_h = ( bottom - top + 1 - _v ) * char_height;
		/*
		dc->SetBrush(*wxBLACK_BRUSH);
		dc->DrawRectangle(0,(top+_v)*char_height,_w,_v*char_height);
		*/
		dc->Blit( 0, (top+_v)*char_height, _w , _h , dc, 0, top*char_height );
	}

	for(int i=0;i<_v;i++)
	{
		//term_data[top+i] = tmp_lines[i];
		CleanLine(top+i);
	}
}
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
int SCD_Terminal::getLineLength(int _line)
{
	if( _line == -1 )	_line = cur_y;

	int i;
	for(i=col_count-1;i>=0 && term_data[_line][i].ch == '\0' ;i--);
	return i+1;
}

bool SCD_Terminal::isWord(char first, char last)
{
//	if(  (first>='\xa0' && first<='\xfe') &&
	if(  (first>='\xa0' && first<='\xf9') &&
 		( (last>='\x40' && last<='\x7e') || (last>'\xa0' && last<='\xfe') )  );
	else return false;

/*
#if defined(__WXGTK__)	//GTK UY Big5 OdϷ|y crash ҥHnưoǱ

if( (unsigned char)first == 0x81 && (unsigned char)last >= 0x40 )	return false;	//ϥΪ̳yr
if( (unsigned char)first >= 0x82 && (unsigned char)first <= 0xa0 )	return false;	//ϥΪ̳yr
if( (unsigned char)first == 0xa3 && (unsigned char)last >= 0xc0 )	return false;	//Ÿ
if( (unsigned char)first == 0xc7 && (unsigned char)last >= 0xf3 )	return false;	//Od
if( (unsigned char)first == 0xc8 )	return false;	//Od
if( (unsigned char)first == 0xfa && (unsigned char)last >= 0x40 )	return false;	//ϥΪ̳yrΤηs`Φr
if( (unsigned char)first >= 0xfb )	return false;	//ϥΪ̳yrΤηs`Φr

#endif
*/
	return true;

}
// ----------------------------------------------------------------------------
bool SCD_Terminal::isCurrentAWord()	//ХثeҳBmO_ΦrĤ@ byte
{	return term_data[cur_y][cur_x].getCharType() == TerminalChar::CH_WORDFIRST;	}
// ----------------------------------------------------------------------------
bool SCD_Terminal::isLeftAWord()		//ХثeҳBmO_Φr
{
	if( ! is_X_in_bound( cur_x - 1 ) )	return false;
	return term_data[cur_y][cur_x-1].getCharType() == TerminalChar::CH_WORDLAST;
}
// ----------------------------------------------------------------------------
int SCD_Terminal::parse(char *input , int len , int *scroll_count)
{
//	char *begin = input;
	if (len == 0 ) return 0;
	wxDC *dc = NULL;
	if( getVisible() && getDC() == NULL )
	{
		dc = new wxClientDC( getParentWindow() );
		BeginDrawing(dc);
	}

	if( len < 0 )
		len = strlen(input);

	HideCaret();

	int unread_data_len = 0;	//pG̫J챱XƤ㪺p, hR̫᪺X
								//öǦ^̫SRXƪ

	char *end = input + len;
	wxString tmp_str;

//#ifdef DEBUG_NEGOTIATION
#if 0
   	//wxLogMessage("parse() input %d end %d len %d",input,end,len);
	{
		for(int i=0;i<len;i++)
		 //tmp_str += wxString::Format("%02x(%c) ", input[i] , input[i]);
		 //tmp_str += wxString::Format("%02x(%c) ", input[i] , isascii(input[i])?input[i]:' ');
		 if ( isprint(input[i]) || isspace(input[i]) ||
			isalnum(input[i]) || iscntrl(input[i]) ) {
		 	tmp_str += wxString::Format("%c", input[i]);
		 }else {
		 //tmp_str += wxString::Format("%02x(%c) ", input[i] , isalnum(input[i])?input[i]:(iscntrl(input[i])?input[i]:' '));
		 	tmp_str += wxString::Format("(%0x)", input[i]);
		 }
		//input[] = '\0';
	//	wxLogMessage(tmp_str);
		//wxLogMessage(wxString(buf));
	}
#endif

	//OsT, Kø
	int last_line_index = cur_y;
 	bool line_updated = false;
//	char *head=input;

	while( input != end )	//pG٦
	{
		if( input > end )
  		{

// ɵ{|Jo if ϶ , OzפWӦ|iJo

				/*
    		wxLogMessage("parse() out of bound %d %d %d",input,end,len);

wxString str = wxEmptyString;
for(char *r=input-10;r<end;r++)	str += wxString::Format("%c", *r);
wxLogMessage(str);
*/


    		break;
		}
		/*
		if ( isWord(*input,*(input+1)) ) {
			if(reach_line_end)	//for ssh (XWL@檺׮ɦ۰ʴ)
			{
				reach_line_end = false;
				goLineHead();
				if( cur_y >= row_count - 1 ){
						adjustLineCharInfo( cur_y );
						repaintLine(cur_y);
						ScrollUp(0, row_count-1);
				} else	{
					goDown();
				}
			}
			term_data[cur_y][cur_x] = now_char_property;
			term_data[cur_y][cur_x].ch = *input;

			goRight();
			term_data[cur_y][cur_x] = now_char_property;
			term_data[cur_y][cur_x].ch = *input;

			line_updated = true;
			input++;
			input++;
		}
		*/
		if( *input == '\0' )	// r'\0'
		{
			//wxLogMessage("skip 0 ? %d",end-input);
			input ++;
			continue;
		}

		if( *input == '\x1b' )	//X}Y   27 \033 SEEN_ESC
  		{
			char *control_code_head = input;
			int is_query = 0;
			input ++;

//			bool has_left_quote = false;
			//wxLogMessage("SEEN_ESC %d",end-input);
			if( *input == '[' )	input++;
			else if( *input == ']' )	//ssh/telnet server pwd
			{
				while(input!=end)
				{
					if(*input == '\x07')	{	input++;	break;	}
					input++;
				}
				continue;
			}
			else	//if there is no '[' follow the '\x1b'
			{
				switch(*input)
				{
					case '=':
		    			app_keypad_keys = TRUE;
		    		break;
		  			case '>':
		    			app_keypad_keys = FALSE;
		    		break;
					case '(' :
						input++;
						input++;
						break;
					case '7' :
						server_stored_cur_pos = wxPoint( cur_x, cur_y );
						input++;
						break;
					case '8' :
						cur_x = server_stored_cur_pos.x;
						cur_y = server_stored_cur_pos.y;

						if( line_updated )	//pGeƧsL, Nøe@檺
						{
							adjustLineCharInfo( last_line_index );
							repaintLine( last_line_index );
							line_updated = false;
						}
						last_line_index = cur_y;
						input++;
						break;
					case 'M' :	//scroll up
						ScrollDown();
						input++;
         				break;
					default :
						//wxString tmpstr=*input;
						if (input == end){
							  unread_data_len=1;
							  //return 1;
						}else{
#ifdef __WXDEBUG__
						wxLogMessage(wxString::Format("unknown SEEN_ESC %02x(%c)",*input,*input, end-input));
#endif
								input++;
						}
						break;
				}
				continue;
			}
/*
  			if( input == end )	//pG [X}Y] , hX
  			{
//  			unread_data_len = 1;
  				break;
			}
			*/
			if( *input == '?' || *input == '(' )	{
					is_query = 1;
					input++;	//}Y '?' iL
			}
			//SEEN_CSI "["
			int param_count , param_list[6];	//ΨӰOXܼ
			param_count = 0;
			param_list[0] = -1;
			param_list[1] = -1;

  			while( input != end )	//}lRX
  			{
				if( isdigit( *input ) )
				{
					if( param_list[ param_count ] < 0 )
         				param_list[ param_count ] = 0;

					param_list[ param_count ] = param_list[ param_count ] * 10 + ( *input - '0' );
				}
				else if( *input == ';' )
				{
					if( param_list[ param_count ] < 0 )
						param_list[param_count] = 0;

					if(param_count < 5)	param_count ++;
					param_list[ param_count + 1 ] = -1;
				}
  				else //if( isalpha( *input ) )		//X
				{
					if ( !is_query)
     				switch( *input )
     				{
     					case 'm' :	//CX
							if(param_list[0] < 0)
								now_char_property = TerminalChar::getDefaultCharProperty();
							else
							{
	     						for(int i=0;param_list[i] >= 0;i++)
	     						{
									if( param_list[i] == 5 )	setHasBlinkChar(true);
	    	 						now_char_property.setColorCode( param_list[i] );
 	 							}
							}
     						break;
     					case 'H' :	//gotoXY
     					case 'f' :	//gotoXY
							//_dispcursy = _dispcursx=0;
							is_set_disp_cursor=1;
							if( param_list[0] < 0 || param_list[1] < 0 ){
								gotoXY(0,0);
//								s_gotoXY(0,0);
								//wxLogMessage("goto 0,0");
							}else
							{
           						if( param_list[0] == 0 )	param_list[0] = 1;
           						if( param_list[1] == 0 )	param_list[1] = 1;
								gotoXY( param_list[1] - 1 , param_list[0] - 1 );
								/*
								_dispcursy = param_list[0] -1;
								_dispcursx= param_list[1]-1;
								*/
								//wxLogMessage("goto %d,%d",param_list[1] - 1 , param_list[0] - 1);
//								s_gotoXY( param_list[1] - 1 , param_list[0] - 1 );
							}
     						break;
     					case 'J' :	//Mù
							if( param_list[0] != 1 && param_list[0] != 2)
								param_list[0] = 0;
     						cleanScreen( param_list[0] );
     						line_updated = false;
     						break;
     					case 'K' :	//M
							CleanLineTail();
							line_updated = true;
     						break;
     					case 'P' :	//Rr
							abs_DeleteChar( param_list[0] > 0 ? param_list[0] : 1 );
							line_updated = true;
     						break;
						case '@' :	//Jr
							abs_InsertChar( param_list[0] > 0 ? param_list[0] : 1 );
							line_updated = true;
							break;
     					case 'L' :	//J n  insert lines IL
//							if( param_list[0] > 0 )	ScrollUp( param_list[0] );
							{
							int c = 1;
							if( param_list[0] > 0 )	c = param_list[0];
							int tmp = m_scroll_region_top;
							m_scroll_region_top = cur_y;
							ScrollDown(c);
							m_scroll_region_top = tmp;
							}
     						break;
     					case 'M' :	//R n  DL delete lines
							{
							
							int c = 1;
							if( param_list[0] > 0 )	c = param_list[0];
							int tmp = m_scroll_region_top;
							m_scroll_region_top = cur_y;
/*
							if(has_left_quote)	ScrollUp(c);
							else ScrollDown(c);
							*/
							ScrollUp(c);

							m_scroll_region_top = tmp;
							
							}
							
     						break;
     					case 'r' :	//wʵd
							//m_isset_scroll_region_bottom = false;
							if( param_list[0] < 0 )	m_scroll_region_top = 0;
							else if( param_list[1] < 0 )
							{	m_scroll_region_top = param_list[0] - 1;}
							else
							{
								m_scroll_region_top = param_list[0] - 1;
								m_scroll_region_bottom = param_list[1] - 1;
								m_isset_scroll_region_bottom = true;
							}
#ifdef __WXDEBUG__
//wxLogMessage( wxString::Format("%d - %d (%d,%d,%d)", m_scroll_region_top, m_scroll_region_bottom , param_count, param_list[0] , param_list[1] ) );
#endif
/*
							if ( param_count == 2 ) {
								_region_top = param_list[0] - 1;
								_region_bottom = param_list[1] - 1;
							}
							*/
     						break;

     					case 'A' :	//ФW
     						if(param_list[0] >= 0)	goUp( param_list[0] );
     						else	goUp(1);
       						break;
     					case 'B' :	//ФU
     						if(param_list[0] >= 0)	goDown( param_list[0] );
     						else	goDown(1);
       						break;
     					case 'C' :	//Хk
     						if(param_list[0] >= 0)	goRight( param_list[0] );
     						else	goRight(1);
       						break;
     					case 'D' :	//Х
     						if(param_list[0] >= 0)	goLeft( param_list[0] );
     						else	goLeft(1);
       						break;
						default :	//X
#ifdef __WXDEBUG__
						    wxLogMessage(wxString::Format("unknown SEEN_CSI char %02x(%c)",*input,*input));
#endif
							break;
     				}
     				break;
				}
/*
				else
				{
					//X
				}
*/
				input ++;
  			}

			if( input >= end )	//pGF end o٨SRX
			{
				unread_data_len = (int)(end - control_code_head);
				break;
			}
    	}
    	else if( *input == '\n' )	// \x0a = 10
		{
			int c = 1;

			//ѩ``s򴫦ŸX{,
   			//pGs򴫦Ÿ, h@Ū, iHbݭn ScrollDown() ɭ,
      		//sƥHέsøϪt
      		// '\n' M '\r' ``X{
			input ++;
			while( input != end )
			{
    			if( *input == '\n' )
       			{	c++;	input++;	}
    			else if( *input == '\r' )	input++;
               	else	{	input--;	break;	}
			}
       		goLineHead();

			//ѩ goDown() i| ScrollDown()
			//C@檺ޱN|ܰ
			//]ns
			if( line_updated )	//pGeƧsL, Nøe@檺
			{

				adjustLineCharInfo( last_line_index );
				repaintLine( last_line_index );
				line_updated = false;
			}

			//
			int bot = m_scroll_region_bottom;
			if( ! m_isset_scroll_region_bottom )	bot = row_count - 1;

			int tmp_c = bot - cur_y;
			int caret_down = (c<=tmp_c) ? c : tmp_c;
			if(caret_down > 0)	goDown(caret_down);
			if( c > caret_down )
			{
				ScrollUp(c - caret_down);
				if(scroll_count != NULL)	(*scroll_count)++;
			}
			/*
			int tmp_c = bot - cur_y;
			int caret_down = (c<=tmp_c) ? c : tmp_c;
			if(caret_down > 0)	goDown(caret_down);
			if ( _dispcursy == row_count-1 ) {
				ScrollUp(c - caret_down);
				if(scroll_count != NULL)	(*scroll_count)++;
			}
			*/

			//
//wxMessageBox( wxString::Format("b: %d - %d - %d - %d", c , cur_y , bot, m_scroll_region_bottom) );
/*
			int tmp_c = row_count - cur_y - 1;
			int caret_down = (c<=tmp_c) ? c : tmp_c;
			if(caret_down > 0)	goDown(caret_down);
			if( c > caret_down )	ScrollUp(0, row_count-1, c - caret_down );
*/
			last_line_index = cur_y;
     	}
    	else if( *input == '\r' )	// \x0d
			goLineHead();
    	else if( *input == '\b' )
    	{	goLeft();	}
    	else if( *input == '\a' )
		{
			bBell = true;
/*
*end = '\0';
wxString tmp_str;
for(char *r=begin;r<end;r++)
	tmp_str += wxString::Format("%02x(%c) ", *r , isalnum(*r)?*r:' ');
wxMessageBox(tmp_str + _T("\n\n") + wxString(begin) );
*/
		}
    	else if( *input == '\xff' )
    	{	
				wxLogMessage("IAC ?? %d",end-input);	
		}
    	else if( *input == '\t' )
		{
//			while(true)
			int c = 8 - cur_x % 8;
//			TerminalChar ch;
			for(int i=0;i<c;i++)
			{
					/*
				{
					if ( _top+cur_y+1 > _cur_lines ) {
						_lines->Add(new TermArrayOfColumn(),_top+cur_y+1-_cur_lines);
						_cur_lines++;
					}
					TermArrayOfColumn * col = _lines->Item(_top+cur_y) ;
					if ( cur_x+1 > col->GetCount()) 
						col->Add(new TerminalChar());
					TerminalChar *ch = col->Item(cur_x);
					*ch = now_char_property;
					ch->ch = ' ';
				}
				*/
				term_data[cur_y][cur_x] = now_char_property;
				term_data[cur_y][cur_x].ch = ' ';
				goRight();
			
//				if( cur_x % 8 == 0 )	break;
				
				//_lines->Item(_top+cur_y)->Item(cur_x) = now_char_property;
				if( cur_x >= col_count - 1 )	break;
			}
			line_updated = true;
		}
    	else //if( ! iscntrl(*input) )
    	{
			if(reach_line_end)	//for ssh (XWL@檺׮ɦ۰ʴ)
			{
				reach_line_end = false;
				goLineHead();
				if( cur_y >= row_count - 1 ){
						adjustLineCharInfo( cur_y );
						repaintLine(cur_y);
						ScrollUp(0, row_count-1);
				} else	{
					goDown();
				}
			}
			term_data[cur_y][cur_x] = now_char_property;
			term_data[cur_y][cur_x].ch = *input;

			goRight();
			line_updated = true;
    	}
#if 0
		else{
#ifdef __WXDEBUG__
			wxLogMessage(wxString::Format("unknown input char %02x(%c)",*input,*input));
			/*
			term_data[cur_y][cur_x] = now_char_property;
			term_data[cur_y][cur_x].ch = *input;

			goRight();
			line_updated = true;
			*/
#endif
		}
#endif


		if( last_line_index != cur_y )	//pG檺ʧ@
		{
			if( line_updated )	//pGeƧsL, Nøe@檺
			{
				adjustLineCharInfo( last_line_index );
				repaintLine( last_line_index );
				line_updated = false;
			}
			last_line_index = cur_y;
		}

		//~RU@Ӧr
        input ++;
	}

	if( line_updated )	//pGeƧsL, Nøe@檺
	{
		adjustLineCharInfo( last_line_index );
		repaintLine( last_line_index );
	}

	DrawCaret();
	if( getVisible() && dc != NULL )
 	{
		//repaint();
		//parentWindow->GetCaret()->Show();
		//updateCaret();
  		EndDrawing(true);
		//delete dc;
	}

	return unread_data_len;
}
// ----------------------------------------------------------------------------
void SCD_Terminal::adjustLineCharInfo(int _y)
{
	int x = 0;
	if(_y == -1)	_y = cur_y;
	for(x=0;x<col_count-1;x++)
	{
		if( isWord( term_data[_y][x].ch , term_data[_y][x+1].ch ) )
		{

//#if defined(__BSD__)
#if 0

static char table[] = "zs{uqt|r}zs{uqt|r}zs{uqt|r}xw~h";

bool flag = true;
char first = term_data[_y][x].ch;
char last = term_data[_y][x+1].ch;

if( (unsigned char)first >= 0xa0 )
{

//if( (unsigned char)first == 0xa1 && ! (((unsigned char)last >= 0x40 && (unsigned char)last <= 0x5c) || (unsigned char)last >= 0xad ) )	flag = false;	//bsd
//else if( (unsigned char)first == 0xa1 && ( (unsigned char)last == 0x5a || (unsigned char)last == 0xc3 || (unsigned char)last == 0xc5 || (unsigned char)last == 0xfe ) )    flag = false;	//bsd
if( (unsigned char)first == 0xa1 )
{
	unsigned char s = (unsigned char)last;
	if( s == 0x5a )	flag = false;	//5a will crash
	else if( s >= 0x40 && s <= 0x5f );
	else if( s >= 0x60 && s <= 0x6f );
	else if( s >= 0x70 && s <= 0x7e );
	else if( s == 0xc3 )	flag = false;
	else if( s == 0xc5 )	flag = false;
//	else if( s >= 0xa1 && s <= 0xcb );
	else if( s >= 0xa1 && s <= 0xcf );
//	else if( s >= 0xe4 && s <= 0xe5 );
//	else if( s >= 0xe8 && s <= 0xe9 );
//	else if( s >= 0xf0 && s <= 0xfd );

	else if( s >= 0xc2 && s <= 0xc7 );
	else if( s >= 0xd0 && s <= 0xdf );
	else if( s >= 0xe0 && s <= 0xef );
	else if( s >= 0xf0 && s <= 0xfd );	//fe will crash
	else flag = false;
}
//else if( (unsigned char)first == 0xa2 && (unsigned char)last >= 0x40 && (unsigned char)last <= 0x60 )	flag = false;	//bsd
//else if( (unsigned char)first == 0xa2 && (unsigned char)last >= 0xcc )	flag = false;	//bsd
else if( (unsigned char)first == 0xa2 )
{
	if( (unsigned char)last >= 0x41 && (unsigned char)last <= 0x49 );
	else if( (unsigned char)last >= 0x40 && (unsigned char)last <= 0x60 )	flag = false;
	else if( (unsigned char)last >= 0xcc )	flag = false;
}
else if( (unsigned char)first == 0xf9 )	flag = false;	//bsd GSkܤjŸ
else if( (unsigned char)first == 0xa3 && (unsigned char)last >= 0xc0 )	flag = false;	//Ÿ
else if( (unsigned char)first == 0xc8 )	flag = false;	//Od
else if( (unsigned char)first == 0xa0 )
{
	if( (unsigned char)last == 0xe6 )	flag = false;
	else if( (unsigned char)last == 0xe7 )	flag = false;
}

}

			if( ! flag )	//bsd GSkܤjŸ
			{
				if( (unsigned char)first == 0xf9 && (unsigned char)last >= 0xdd && (unsigned char)last <= 0xfe )
				{
					term_data[_y][x].ch = table[ ( (unsigned char)last - 0xdd ) * 2 ];
					term_data[_y][x+1].ch = table[ ( (unsigned char)last - 0xdd ) * 2 + 1 ];
					term_data[_y][x].setCharType( TerminalChar::CH_WORDFIRST );
					term_data[_y][x+1].setCharType( TerminalChar::CH_WORDLAST );
				}
				else
				{
				term_data[_y][x].setCharType( TerminalChar::CH_CHAR );
				term_data[_y][x].setCharType( TerminalChar::CH_CHAR );
				}
			}
			else
#endif
			{
				term_data[_y][x].setCharType( TerminalChar::CH_WORDFIRST );
				term_data[_y][x+1].setCharType( TerminalChar::CH_WORDLAST );
			}
			x++;
		}
		else
			term_data[_y][x].setCharType( TerminalChar::CH_CHAR );
	}
	if(x==col_count-1)
		term_data[_y][x].setCharType( TerminalChar::CH_CHAR );
		
		
	//Mĳs
#if 0	
	int link_start_x;

	for(x=0;x<col_count-3;x++)
	{
		link_start_x = -1;
		if( term_data[_y][x].ch == ':' && term_data[_y][x+1].ch == '/' && term_data[_y][x+2].ch == '/' )
		{
			if( x >= 6 )
			{
				if( term_data[_y][x-6].ch == 't' && term_data[_y][x-5].ch == 'e' &&
					term_data[_y][x-4].ch == 'l' && term_data[_y][x-3].ch == 'n' &&
					term_data[_y][x-2].ch == 'e' && term_data[_y][x-1].ch == 't' )
				{	link_start_x = x - 6;	term_data[_y][x-6].setLinkType( LINK_TELNET );	}
			}
			if( x >= 4 )
			{
				if( term_data[_y][x-4].ch == 'h' && term_data[_y][x-3].ch == 't' &&
					term_data[_y][x-2].ch == 't' && term_data[_y][x-1].ch == 'p' )
				{	link_start_x = x - 4;	term_data[_y][x-4].setLinkType( LINK_HTTP );	}
				else if( term_data[_y][x-4].ch == 's' && term_data[_y][x-3].ch == 'f' &&
					term_data[_y][x-2].ch == 't' && term_data[_y][x-1].ch == 'p' )
				{	link_start_x = x - 4;	term_data[_y][x-4].setLinkType( LINK_SFTP );	}
			}
			if( x >= 3 )
			{
				if( term_data[_y][x-3].ch == 'f' && term_data[_y][x-2].ch == 't' &&
					term_data[_y][x-1].ch == 'p' )
				{	link_start_x = x - 3;	term_data[_y][x-3].setLinkType( LINK_FTP );	}
				else if( term_data[_y][x-3].ch == 'b' && term_data[_y][x-2].ch == 'b' &&
					term_data[_y][x-1].ch == 's' )
				{	link_start_x = x - 3;	term_data[_y][x-3].setLinkType( LINK_TELNET );	}
			}

		}
		else if(term_data[_y][x].ch == '@' && term_data[_y][x].getCharType() == TerminalChar::CH_CHAR )
		{
			int i;
			for(i=x; i>=0 && term_data[_y][i].ch != ' ' && term_data[_y][i].getCharType() == TerminalChar::CH_CHAR ;i--);
			link_start_x = i + 1;
			term_data[_y][link_start_x].setLinkType( LINK_EMAIL );
		}

		if( link_start_x >= 0 )
		{
			int tmp_x = x , link_end_x;
			bool has_dot_char = false;	//WsrꤤO_r '.'
			for(x=link_start_x;x<col_count;x++)
			{
				if( term_data[_y][x].ch == ' ' || term_data[_y][x].ch == '\0' || term_data[_y][x].getCharType() != TerminalChar::CH_CHAR)
					break;
				else
					term_data[_y][x].setLinkType( term_data[_y][link_start_x].getLinkType() );
				if( term_data[_y][x].ch == '.' )	has_dot_char = true;
			}

			//ˬdrO_ŦXWscnAOܫhWsݩ
			link_end_x = x;
			if( (link_end_x - link_start_x < 10) || (! has_dot_char) )
			{
				for(int k=link_start_x;k<link_end_x;k++)
					term_data[_y][k].setLinkType( LINK_NONE );
			}

			if( tmp_x > x )	x = tmp_x;	//[JoOקKiJLj
		}
		else
		{
			term_data[_y][x].setLinkType( LINK_NONE );
		}

	}
#endif
}
// ----------------------------------------------------------------------------
inline bool SCD_Terminal::isCharSelected(int _x, int _y)
{
	if( selectState == 2 || selectState == 3 )
	{
		if (alt_down ) {
			int l = start_x;
			int r = end_x;
			int u = start_y;
			int b = end_y;
		   if (start_x > end_x ) {
				l = end_x; r=start_x;
		   }
		   if (start_y > end_y ) {
				u = end_y; b = start_y;
		   }
		   if ( _x > r || _x < l ) return false;
		   if ( _y > b || _y < u ) return false;
		   return true;
		}else{
 			int s = start_y * col_count + start_x;
			int e = end_y * col_count + end_x;
			if( s > e )	{	int i = s;	s = e;	e = i;	}
			int n = _y * col_count + _x;
			return ( n >= s && n <= e );
		}
	}
	else	return false;
}
// ----------------------------------------------------------------------------
void SCD_Terminal::MouseXY_to_TextXY(int m_x, int m_y, int & t_x, int & t_y)
{	//Nƹyഫ۹ry

	if( scrollwin )    	scrollwin->CalcUnscrolledPosition( m_x, m_y, &m_x, &m_y );

assert(char_width > 0);
assert(char_height > 0);

	t_x = m_x / char_width;		t_y = m_y / char_height;
	if( t_x < 0 ) t_x = 0;
	else if( t_x >= col_count ) t_x = col_count - 1;
	if( t_y < 0 ) t_y = 0;
	else if( t_y >= row_count ) t_y = row_count - 1;
}
// ----------------------------------------------------------------------------

void SCD_Terminal::repaintChar(int _x, int _y)
{
	//return;
	wxDC *dc = getDC();
	if(dc == NULL) return;

	if( ! ( is_X_in_bound(_x) && is_Y_in_bound(_y) ) )	return;

	int _m, _n;	//oӤrWy
	_m = _x * char_width;
	_n = _y * char_height;

	//TerminalChar & now_ch = term_data[_y][_x];

	TerminalChar now_ch ;//= term_data[_y][_x];
	if ( _sbar_pos != _sbar_bottom_pos ) {
		now_ch = disp_term[_y][_x]	;	
		//parentWindow->GetCaret()->Hide();
	}else{
		now_ch = term_data[_y][_x] ;
	}
	char str[10];	//ΨxsneXr

	//pGQ, hnNmϬ
	bool isSelected = isCharSelected( _x, _y );

	if( (! getBlinkCharVisibility()) && now_ch.getBlink() )
	{ //pGܰ{{r
		
		//wxBrush br( now_ch.getBgColor(isSelected) , wxSOLID ) ;
		//if ( br.Ok() ) dc->SetBrush( br );
		//dc->DrawRectangle( _m , _n , char_width , char_height);
		dc->SetTextBackground(now_ch.getBgColorRef(isSelected));
		dc->SetTextForeground( now_ch.getTextColorRef(isSelected) );
		dc->DrawText( " ", _m , _n );
	}
	else if( now_ch.ch == '\0' )
	{
			/*
	    wxBrush br( now_ch.getBgColor(false) , wxSOLID ) ;
		if (br.Ok())  dc->SetBrush( br );
		dc->DrawRectangle( _m , _n , char_width , char_height);
		*/
		dc->SetTextBackground(now_ch.getBgColorRef(isSelected));
		dc->SetTextForeground( now_ch.getTextColorRef(isSelected) );
		dc->DrawText( " ", _m , _n );
	}
	else if( now_ch.ch == ' ' )
	{
		dc->SetTextBackground(now_ch.getBgColorRef(isSelected));
		dc->SetTextForeground( now_ch.getTextColorRef(isSelected) );
		dc->DrawText( " ", _m , _n );
		
		/*
	    wxBrush br( now_ch.getBgColor(isSelected) , wxSOLID ) ;
		if ( br.Ok()) dc->SetBrush( br );
		dc->DrawRectangle( _m , _n , char_width , char_height);
		*/
	}
	else if( now_ch.getCharType() == TerminalChar::CH_CHAR )
	{
		//eI
/*
	    wxBrush br( now_ch.getBgColor(isSelected) , wxSOLID ) ;
		if ( !br.GetResourceHandle()) {
			wxLogMessage("can not get resource handle of brush");
			return;
		}
		*/
		//dc->SetBrush( br );
		//dc->SetBrush( now_ch.getBgBrush(isSelected) );
		//dc->DrawRectangle( _m , _n , char_width , char_height);

		if( now_ch.ch < 0 )	return;	//[WoקK GTK U| crash :)
//fprintf(stderr, "char : %d -> %c\n", (int)now_ch.ch , now_ch.ch );

		//ܦr
		bool blunderline = now_ch.getUnderline();
   		if(blunderline)
   		{
      		wxFont fnt = dc->GetFont();
   	    	fnt.SetUnderlined(true);
       		dc->SetFont(fnt);
		}
		dc->SetTextBackground(now_ch.getBgColorRef(isSelected));
		dc->SetTextForeground( now_ch.getTextColorRef(isSelected) );
		dc->DrawText( wxChar(now_ch.ch), _m , _n );
//		dc->DrawText( str, _m , _n );

   		if(blunderline)
   		{
      		wxFont fnt = dc->GetFont();
   	    	fnt.SetUnderlined(false);
       		dc->SetFont(fnt);
		}
	}
	else if( now_ch.getCharType() == TerminalChar::CH_WORDFIRST )
	{
		//TerminalChar & next_ch = term_data[_y][_x+1];
		TerminalChar next_ch;//= term_data[_y][_x+1];
		if ( _sbar_pos != _sbar_bottom_pos ) {
			next_ch = disp_term[_y][_x+1]	;	
		}else{
			next_ch = term_data[_y][_x+1] ;
		}

		bool isLastWordSelected = isCharSelected( _x + 1 , _y );
		bool isSameFront =
  				( now_ch.getTextColorRef(isSelected) == next_ch.getTextColorRef(isLastWordSelected) )
  				&& ( now_ch.getUnderline() == next_ch.getUnderline() );
		bool isSameBack = ( now_ch.getBgColorRef(isSelected) == next_ch.getBgColorRef(isLastWordSelected) );


		//eI
		if( isSameBack )	//pGΦr byte ⳣۦP, N@en
		{
			dc->SetTextBackground(now_ch.getBgColorRef(isSelected));
			dc->SetTextForeground( now_ch.getTextColorRef(isSelected) );
			dc->DrawText( "  ", _m , _n );
		    //dc->SetBrush( wxBrush( now_ch.getBgColor(isSelected) , wxSOLID ) );
		//	dc->DrawRectangle( _m , _n , char_width + char_width , char_height);
		}
		else
		{
			dc->SetTextBackground(now_ch.getBgColorRef(isSelected));
			dc->SetTextForeground( now_ch.getTextColorRef(isSelected) );
			dc->DrawText( " ", _m , _n );
		    //dc->SetBrush( wxBrush( now_ch.getBgColor(isSelected) , wxSOLID ) );
			//dc->DrawRectangle( _m , _n , char_width , char_height);

			dc->SetTextBackground(next_ch.getBgColorRef(isSelected));
			dc->SetTextForeground( next_ch.getTextColorRef(isSelected) );
			dc->DrawText( " ", _m , _n );
	    	//dc->SetBrush( wxBrush( next_ch.getBgColor(isLastWordSelected) , wxSOLID ) );
			//dc->DrawRectangle( _m + char_width , _n , char_width , char_height);
		}

		//ܦr
		str[0] = now_ch.ch;
		str[1] = next_ch.ch;
		str[2] = '\0';
		str[3] = '\0';
		wxString tmpstr = wxString(str,2);
		if ( tmpstr.IsWord() ) {
			//wxLogMessage("isword %s",tmpstr);
		}
//fprintf(stderr, "word : %x %x %s\n", str[0], str[1], str );

		if( isSameFront )
		{
			bool blunderline = now_ch.getUnderline();
      		if(blunderline)
      		{
	      		wxFont fnt = dc->GetFont();
    	    	fnt.SetUnderlined(true);
        		dc->SetFont(fnt);
			}

			dc->SetTextForeground( now_ch.getTextColor(isSelected) );
/*
			wxFontEncoding enc = wxFontMapper::GetEncodingFromName(wxString("BIG5"));
			wxString facename;
		    wxFont myFont(getCharSize(), wxFONTFAMILY_MODERN, wxNORMAL, wxNORMAL,
			              false, facename, enc);
				
		    dc->SetFont(myFont);
			*/
			/*
		{
			// We have a string in an encoding 'enc' which we want to
			// display in a font called 'facename'.
			//
			// First we must find out whether there is a font available for
			// rendering this encoding
			wxFontEncoding ascii = wxFontMapper::GetEncodingFromName(wxString("wxFONTENCODING_UTF8"));
			wxString facename;	
			wxString text(str,2); // Contains the text in encoding 'enc'
			if (!wxFontMapper::Get()->IsEncodingAvailable(enc, facename))
			{
			   // We don't have an encoding 'enc' available in this font.
			   // What alternative encodings are available?
			
			   wxFontEncoding alternative;
			   if (wxFontMapper::Get()->GetAltForEncoding(enc, &alternative,
			                                              facename, false))
			   {
			       // We do have a font in an 'alternative' encoding,
			       // so we must convert our string into that alternative.
			
			       wxCSConv convFrom(wxFontMapper::GetEncodingName(enc));
			       wxCSConv convTo(wxFontMapper::GetEncodingName(alternative));
			       text = wxString(text.wc_str(convFrom), convTo) ;
			
			       // Create font with the encoding alternative
			
			       wxFont myFont(getCharSize(), wxFONTFAMILY_DEFAULT, wxNORMAL, wxNORMAL,
			               false, facename , alternative);
			       dc->SetFont(myFont);
			   }
			   else
			   {
			      // Unable to convert; attempt a lossy conversion to
			      // ISO 8859-1 (7-bit ASCII)
			
			    }
			}
			else
			{
			    // The font with that encoding exists, no problem.
			
			     //wxFont myFont(getCharSize(), wxFONTFAMILY_DEFAULT, wxNORMAL, wxNORMAL,false, facename, enc);
			       wxCSConv convFrom(wxFontMapper::GetEncodingName(ascii));
			       wxCSConv convTo(wxFontMapper::GetEncodingName(enc));
			       text = wxString(text.wc_str(convFrom), convTo) ;
			
					wxFont myFont(getCharSize(), wxFONTFAMILY_MODERN , wxNORMAL, wxNORMAL,false, facename, enc);
			     	dc->SetFont(myFont);
			}
			
			// Finally, draw the text with the font we've selected.
			
			dc->DrawText(text,_m , _n);
			dc->SetFont(GetCurrentFont());
		}
		*/
			dc->DrawText( wxString(str, 2), _m , _n );

      		if(blunderline)
      		{
	      		wxFont fnt = dc->GetFont();
    	    	fnt.SetUnderlined(false);
        		dc->SetFont(fnt);
			}
		}
		else	//pGΦrk䪺rC⤣@, h⦸e
		{
			bool blunderline = now_ch.getUnderline();

			//ܥb
      		if( blunderline )
      		{
	      		wxFont fnt = dc->GetFont();
    	    	fnt.SetUnderlined(true);
        		dc->SetFont(fnt);
			}
/*
static wxEncodingConverter cv;
cv.Init( wxLocale::GetSystemEncoding() , wxFONTENCODING_UNICODE );
char text[10];
strcpy(text, str);
cv.Convert( text, str );
*/
			dc->SetTextForeground( now_ch.getTextColor(isSelected) );
			dc->SetClippingRegion( _m, _n, char_width, char_height );
			dc->DrawText( wxString(str, 2), _m , _n );
			dc->DestroyClippingRegion();

			//ܥkb
			if( blunderline != next_ch.getUnderline() )
			{
       			blunderline = next_ch.getUnderline();
	      		wxFont fnt = dc->GetFont();
    	    	fnt.SetUnderlined(blunderline);
        		dc->SetFont(fnt);
			}
			
			dc->SetTextForeground( next_ch.getTextColor(isLastWordSelected) );
			dc->SetClippingRegion( _m + char_width, _n, char_width, char_height );
			dc->DrawText( wxString(str, 2), _m , _n );
			dc->DestroyClippingRegion();

      		if( blunderline )
      		{
	      		wxFont fnt = dc->GetFont();
    	    	fnt.SetUnderlined(false);
        		dc->SetFont(fnt);
			}
		}
	}
	else// if( now_ch.getCharType() == TerminalChar::CH_WORDLAST )
	{
		repaintChar(_x-1, _y);
	}
	
	
	if( now_ch.getLinkType() != LINK_NONE )
	{
		dc->SetPen( *wxCYAN_PEN );
		dc->DrawLine( _m , _n + char_height - 1 , _m + char_width , _n + char_height - 1 );
		dc->SetPen(*wxTRANSPARENT_PEN);	//T DrawRectangle() ɥ Pen e
	}
}
// ----------------------------------------------------------------------------
void SCD_Terminal::repaintLine(int _y)
{
	wxDC *dc = getDC();
	if(dc == NULL)	return;
	if( _y == -1 )	_y = cur_y;
	//wxString str;
	//updateCaret();	
	/*
	TerminalChar now_ch ;
	TerminalChar pre_ch ;
	bool preIsSel =0;
	*/
	/*
	int _m, _n;	//oӤrWy
	_n = _y * char_height;
	_m = 0;
	wxString str;
	*/
	TerminalChar **temp_data;
	if ( _sbar_pos != _sbar_bottom_pos ) {
		temp_data = disp_term	;	
	}else{
		temp_data = term_data ;
	}

	for(int _x=0;_x<col_count;_x++)
	{
			/*
		if ( _sbar_pos != _sbar_bottom_pos ) {
			now_ch = disp_term[_y][_x] ;
		}else{
			now_ch = term_data[_y][_x] ;
		}
		bool isSelected = isCharSelected( _x, _y );
			
		if (( _x == 0 ) ||
			(now_ch.getBgColorRef(isSelected) == pre_ch.getBgColorRef(preIsSel)
		  && now_ch.getTextColorRef(isSelected) == pre_ch.getTextColorRef(preIsSel))
		   )
		{
		}else{
			dc->SetTextBackground(pre_ch.getBgColorRef(preIsSel));
			dc->SetTextForeground(pre_ch.getTextColorRef(preIsSel) );
			dc->DrawText( str, _m , _n );
			str = now_ch.ch;
			_m = _x * char_width;
		}
		preIsSel = isSelected;
		pre_ch = now_ch; 
		*/

		//str +=term_data[_y][_x].ch;
		if( temp_data[_y][_x].getCharType() != TerminalChar::CH_WORDLAST ){
			repaintChar(_x, _y);
		}
	}
#if 0
	//wxLogMessage("[%d] %s",_y,str);
	{
			// We have a string in an encoding 'enc' which we want to
			// display in a font called 'facename'.
			//
			// First we must find out whether there is a font available for
			// rendering this encoding
			wxFontEncoding enc = wxFontMapper::GetEncodingFromName(wxString("CP-936"));
			wxFontEncoding ascii = wxFONTENCODING_ISO8859_1;//wxFONTENCODING_UTF7;//wxFONTENCODING_ISO8859_1;
				//wxFONTENCODING_UTF8;//wxFontMapper::GetEncodingFromName(wxString("UTF8"));
			wxString facename("System");	
			//wxString text(str,2); // Contains the text in encoding 'enc'
			if (!wxFontMapper::Get()->IsEncodingAvailable(enc, facename))
			{
			}
			else
			{
			    // The font with that encoding exists, no problem.
			
			     //wxFont myFont(getCharSize(), wxFONTFAMILY_DEFAULT, wxNORMAL, wxNORMAL,false, facename, enc);
				
			       wxCSConv convFrom(wxFontMapper::GetEncodingName(ascii));
			       wxCSConv convTo(wxFontMapper::GetEncodingName(enc));
			       //wxString text(str.c_str(), convTo) ;
			
				   /*
			       // Create font with the encoding alternative
			
			       wxFont myFont(getCharSize(), wxFONTFAMILY_DEFAULT, wxNORMAL, wxNORMAL,
			               false, facename , alternative);
			       dc->SetFont(myFont);
				   */
					wxFont myFont(getCharSize(), wxFONTFAMILY_SWISS , wxNORMAL, wxNORMAL,false, facename, enc);
			     	dc->SetFont(myFont);
					dc->DrawText(str,_m , _n);
			}
			
			// Finally, draw the text with the font we've selected.
			
			
	}
#endif	
	//str.Clear();
}
// ----------------------------------------------------------------------------
void SCD_Terminal::repaint(bool eraseBackground)
{	if( getVisible() )	getParentWindow()->Refresh( eraseBackground );	}
// ----------------------------------------------------------------------------
void SCD_Terminal::OnPaint(wxDC *dc)
{
	//wxLogMessage("OnPaint");
	if( ! getVisible() )	return;
	//wxLogMessage("cur_x cur_y %d %d",cur_x,cur_y);
/*
	wxRegionIterator upd( getParentWindow()->GetUpdateRegion() ); // get the update rect list
	if(!upd)	return;

	int left = 10000, right = 0, top = 10000, bottom = 0;
	while(upd)
	{
		int l = upd.GetX();
		int t = upd.GetY();
		int r = l + upd.GetW();
		int b = t + upd.GetH();

		if( l < left ) left = l;
		if( r > right ) right = r;
		if( t < top ) top = t;
		if( b > bottom ) bottom = b;

		upd++;
 	}
	BeginDrawing(dc);
	repaint( dc , left, top, right - left, bottom - top );
	getParentWindow()->SetFocus();
	EndDrawing();
	*/

	//wxLogMessage("OnPaint");
	BeginDrawing(dc);
	for(int j=0;j<row_count;j++)
	{
		for (int i=0;i<col_count;i++)
				repaintChar(i,j);
	}
	//wxLogMessage("cur_x cur_y %d %d",cur_x,cur_y);
	//getParentWindow()->SetFocus();
	/*
	if ( _sbar_pos != _sbar_bottom_pos ) {
		//parentWindow->GetCaret()->Move(-100,-100);
	}else{
		DrawCaret();
	}
	*/
	DrawCaret();
	EndDrawing(false);
}
// ----------------------------------------------------------------------------
void SCD_Terminal::OnPaint(wxPaintEvent& WXUNUSED(event))
{
	wxPaintDC dc( getParentWindow() );
	OnPaint(&dc);
}
// ----------------------------------------------------------------------------
void SCD_Terminal::repaint(wxDC *dc, int x, int y, int w, int h)
{
	if( ! getVisible() )	return;

	int left, top, right, bottom;

	left = x;  top = y;
	MouseXY_to_TextXY( left, top, left, top );
	right = left+w;		bottom = top+h;

	//wxLogMessage("repaint %d,%d,%d,%d",top,bottom,left,right);
	/*
	for(int j=0;j<row_count;j++)
	{
		for (int i=0;i<col_count;i++)
				repaintChar(i,j);
	}
	*/
	for(int j=top;j<=bottom;j++)
		for(int i=left;i<=right;i++)
			repaintChar(i, j);
}
// ----------------------------------------------------------------------------
void SCD_Terminal::setBlinkCharVisibility(bool _v)
{
	if( _v == blBlinkCharVisibility )	return;
	blBlinkCharVisibility = _v;

	if( ! getHasBlinkChar() )	return;	//pGثeS{{r, hX 

	wxClientDC dc( parentWindow );
	BeginDrawing(&dc);

	for(int y=0;y<row_count;y++)
		for(int x=0;x<col_count;x++)
		{
			if( term_data[y][x].getBlink() )
				repaintChar(x,y);
		}

	EndDrawing(false);
}
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
void SCD_Terminal::OnMouseLeftDown(wxMouseEvent& event)
{
	if ( event.AltDown() ) {
		alt_down = 1;
	//	wxLogMessage("alt + mouse left");
	}else{
		alt_down = 0;
	}
	//wxLogMessage("left down slectState %d start_x %d starty %d endx %d endy %d", selectState,start_x,start_y,end_x,end_y);
	switch( selectState )
	{
		case 0:
		case 2:
		case 3:
			CancelSelection();
		default:
	 		selectState = 1;
			MouseXY_to_TextXY( event.GetX() , event.GetY() , start_x, start_y );
			break;
	}
}
// ----------------------------------------------------------------------------
void SCD_Terminal::OnMouseMotion(wxMouseEvent& event)
{
	int _x, _y;

	MouseXY_to_TextXY( event.GetX() , event.GetY() , _x, _y );

	//pGƹSʨOr, hX, iֹBq
	if( end_y == _y && end_x == _x )	return;
	if( event.LeftIsDown() )
	{
		//wxLogMessage("motion slectState %d start_x %d starty %d endx %d endy %d", selectState,start_x,start_y,end_x,end_y);
		switch( selectState )
		{
			case 1:
   				selectState = 2;
				getParentWindow()->CaptureMouse();
   				end_x = _x;		end_y = _y;
   				break;
			case 2:
				{
					int b, e;
					/*
					if ( start_y > _y ) {	b = _y;	e = start_y;	}
					else				{	b = start_y;	e = _y;	}
					*/
					if ( start_y > end_y ) {
						b = end_y > _y ? _y :end_y;
						e = start_y;
					}else{
						b = start_y;
						e = end_y > _y ? end_y: _y;
					}

					/*
					if( end_y > _y )	{	b = _y;	e = end_y;	}
					else				{	b = end_y;	e = _y;	}
					*/
	
					end_x = _x;		end_y = _y;

					/*
					if ( alt_down ) {
						left_b = start_x;
						right_b = end_x;
						if ( left_b > right_b ) {
							int i= right_b; right_b = left_b ; left_b = right_b;
						}
					}else{
						left_b = 0;
						right_b = col_count;
					}
					*/

					wxClientDC dc( getParentWindow() );
					BeginDrawing(&dc);
					for(int i=b;i<=e;i++)	repaintLine(i);
					DrawCaret();
					EndDrawing(false);
				}


				//pGbӥBЧ֭nWLܰϤWUɽu, h۰ʱʱb
				if( scrollwin )
				{
        			int d = 0;

			     	if( event.GetY() < 0 )	d = -1;
			     	else if( event.GetY() > scrollwin->GetClientSize().GetHeight() )	d = 1;

			     	if( d != 0 )
			      	{
						int vx, vy;
			           	scrollwin->GetViewStart(&vx, &vy);
			           	vy +=d;
			           	if(vy >= 0)	scrollwin->Scroll(-1, vy);
					}
				}

				break;
		}
   	}
   	
   	if( term_data[_y][_x].getLinkType() == LINK_NONE )
   		parentWindow->SetCursor(wxCURSOR_IBEAM);
	else
   		parentWindow->SetCursor( wxCursor(wxCURSOR_HAND) );
}

// ----------------------------------------------------------------------------
void SCD_Terminal::OnMouseLeftUp(wxMouseEvent& event)
{
	wxLogMessage("left up slectState %d start_x %d starty %d endx %d endy %d", selectState,start_x,start_y,end_x,end_y);
	switch( selectState )
	{
		case 1:
			{
				if( ! OnLinkClickedFunc )	break;	//pGSwq OnLinkClickedFunc h} 

				int _x, _y;
				MouseXY_to_TextXY( event.GetX() , event.GetY() , _x, _y );
				
				//pGsrꪺ, hҰʳs
				if( term_data[_y][_x].getLinkType() != LINK_NONE )
				{
					char link[1000];
					int link_start_x;
					int i;

					//Ms}}Y
					for(i=_x;i>=0;i--)
     					if( term_data[_y][i].getLinkType() == LINK_NONE )
     						break;
     				link_start_x = i + 1;


					//ƻss}
					for(i=link_start_x;i<col_count;i++)
					{
     					if( term_data[_y][i].getLinkType() != LINK_NONE )
     						link[i-link_start_x] = term_data[_y][i].ch;
						else	break;
					}
					link[i-link_start_x] = '\0';
				
					//Ұʳs
					if( term_data[_y][_x].getLinkType() != LINK_NONE )
						OnLinkClickedFunc( link , term_data[_y][_x].getLinkType() );
				}
			}
			selectState = 0;
			break;
		case 2:
      		selectState = 3;
			getParentWindow()->ReleaseMouse();
    		break;
	}
	CopySelectionToClipboard(false);
	selectState = 0;
	//alt_down = 0;
}

/*
 * The wordness array is mainly for deciding the disposition of the
 * US-ASCII characters.
 */
int SCD_Terminal::wordtype(int uc)
{
    struct ucsword {
	int start, end, ctype;
    };
    static const struct ucsword ucs_words[] = {
	{
	128, 160, 0}, {
	161, 191, 1}, {
	215, 215, 1}, {
	247, 247, 1}, {
	0x037e, 0x037e, 1},	       /* Greek question mark */
	{
	0x0387, 0x0387, 1},	       /* Greek ano teleia */
	{
	0x055a, 0x055f, 1},	       /* Armenian punctuation */
	{
	0x0589, 0x0589, 1},	       /* Armenian full stop */
	{
	0x0700, 0x070d, 1},	       /* Syriac punctuation */
	{
	0x104a, 0x104f, 1},	       /* Myanmar punctuation */
	{
	0x10fb, 0x10fb, 1},	       /* Georgian punctuation */
	{
	0x1361, 0x1368, 1},	       /* Ethiopic punctuation */
	{
	0x166d, 0x166e, 1},	       /* Canadian Syl. punctuation */
	{
	0x17d4, 0x17dc, 1},	       /* Khmer punctuation */
	{
	0x1800, 0x180a, 1},	       /* Mongolian punctuation */
	{
	0x2000, 0x200a, 0},	       /* Various spaces */
	{
	0x2070, 0x207f, 2},	       /* superscript */
	{
	0x2080, 0x208f, 2},	       /* subscript */
	{
	0x200b, 0x27ff, 1},	       /* punctuation and symbols */
	{
	0x3000, 0x3000, 0},	       /* ideographic space */
	{
	0x3001, 0x3020, 1},	       /* ideographic punctuation */
	{
	0x303f, 0x309f, 3},	       /* Hiragana */
	{
	0x30a0, 0x30ff, 3},	       /* Katakana */
	{
	0x3300, 0x9fff, 3},	       /* CJK Ideographs */
	{
	0xac00, 0xd7a3, 3},	       /* Hangul Syllables */
	{
	0xf900, 0xfaff, 3},	       /* CJK Ideographs */
	{
	0xfe30, 0xfe6b, 1},	       /* punctuation forms */
	{
	0xff00, 0xff0f, 1},	       /* half/fullwidth ASCII */
	{
	0xff1a, 0xff20, 1},	       /* half/fullwidth ASCII */
	{
	0xff3b, 0xff40, 1},	       /* half/fullwidth ASCII */
	{
	0xff5b, 0xff64, 1},	       /* half/fullwidth ASCII */
	{
	0xfff0, 0xffff, 0},	       /* half/fullwidth ASCII */
	{
	0, 0, 0}
    };

    const struct ucsword *wptr;

    if (uc < 0x80) return wordness[uc];

    for (wptr = ucs_words; wptr->start; wptr++) {
	if (uc >= wptr->start && uc <= wptr->end)
	    return wptr->ctype;
    }

    return 2;
}

// ----------------------------------------------------------------------------
void SCD_Terminal::OnMouseLeftDoubleClick(wxMouseEvent& event)
{	//ƹIi۰ʿӭ^r, Τyl

	//wxLogMessage("double slectState %d start_x %d starty %d endx %d endy %d", selectState,start_x,start_y,end_x,end_y);
	int _x, _y;
	int s, e;
	MouseXY_to_TextXY( event.GetX() , event.GetY() , _x, _y );
	TerminalChar **term;
	if ( _sbar_pos != _sbar_bottom_pos ) {
		term=disp_term;
	}else{
		term=term_data;
	}
	TerminalChar::CHAR_TYPE t = term[_y][_x].getCharType();

	if(t == TerminalChar::CH_CHAR)
	{
			/*
		if( term[_y][_x].ch != ' ' )
		{
			for(s=_x; s>=0 
				&& term[_y][s].getCharType() == TerminalChar::CH_CHAR 
				&& term[_y][s].ch != ' ';s--);	s++;
			for(e=_x; e<col_count && term[_y][e].getCharType() == TerminalChar::CH_CHAR && term[_y][e].ch != ' ';e++);	e--;
			if(s>=e)	return;
			for (;;) {
				if ( term[_y][e].ch == 0 ) {
						e--;
				}else if ( term[_y][e].ch  == '*' ){
					   	e--;
						break;
				}else {
					break;
				}
			}
		}
		else return;
		*/
		int wvalue = wordtype(term[_y][_x].ch);
		if( term[_y][_x].ch != ' ' )
		{
			for(s=_x; s>=0 
				&& term[_y][s].getCharType() == TerminalChar::CH_CHAR 
				&& wordtype(term[_y][s].ch) == wvalue 
				;s--);	
			s++;
			for(e=_x; e<col_count 
				&& term[_y][e].getCharType() == TerminalChar::CH_CHAR 
				&& wordtype(term[_y][e].ch) == wvalue
				;e++);	
			e--;
			if(s>=e)	return;
			/*
			for (;;) {
				if ( term[_y][e].ch == 0 ) {
						e--;
				}else if ( term[_y][e].ch  == '*' ){
					   	e--;
						break;
				}else {
					break;
				}
			}
			*/
		}
		else return;
	}
	else
	{
		for(s=_x; s>=0 && term[_y][s].getCharType() != TerminalChar::CH_CHAR ;s--);	s++;
		for(e=_x; e<col_count && term[_y][e].getCharType() != TerminalChar::CH_CHAR ;e++);	e--;
		if(s>=e)	return;
	}
	/*
	TerminalChar::CHAR_TYPE t = term_data[_y][_x].getCharType();

	if(t == TerminalChar::CH_CHAR)
	{
		if( term_data[_y][_x].ch != ' ' )
		{
			for(s=_x; s>=0 
				&& term_data[_y][s].getCharType() == TerminalChar::CH_CHAR 
				&& term_data[_y][s].ch != ' ';s--);	s++;
			for(e=_x; e<col_count && term_data[_y][e].getCharType() == TerminalChar::CH_CHAR && term_data[_y][e].ch != ' ';e++);	e--;
			if(s>=e)	return;
			for (;;) {
				if ( term_data[_y][e].ch == 0 ) {
						e--;
				}else if ( term_data[_y][e].ch  == '*' ){
					   	e--;
						break;
				}else {
					break;
				}
			}
		}
		else return;
	}
	else
	{
		for(s=_x; s>=0 && term_data[_y][s].getCharType() != TerminalChar::CH_CHAR ;s--);	s++;
		for(e=_x; e<col_count && term_data[_y][e].getCharType() != TerminalChar::CH_CHAR ;e++);	e--;
		if(s>=e)	return;
	}
*/
	start_x = s;	start_y = _y;
	end_x = e;	end_y = _y;
	selectState = 3;

	//ø
	wxClientDC dc( getParentWindow() );
	BeginDrawing(&dc);
	repaintLine(_y);
	DrawCaret();
	EndDrawing(false);
}
// ----------------------------------------------------------------------------
void SCD_Terminal::SelectAll()
{
	start_x = 0;	start_y = 0;
	end_x = col_count - 1;	end_y = row_count - 1;
	selectState = 3;

	wxClientDC dc( getParentWindow() );
	repaint();
}
// ----------------------------------------------------------------------------
void SCD_Terminal::CancelSelection()	//
{
	switch( selectState )
	{
		case 0:
		case 1:
		case 2:
		case 3:
		{
			int b, e;
			if (start_y<0 || start_y >= row_count) break;
			if (end_y<0||end_y >=row_count) break;

			if( start_y < end_y )	{	b = start_y;	e = end_y;	}
			else					{	b = end_y;	e = start_y;	}

			selectState = 0;

			wxClientDC dc( getParentWindow() );
			BeginDrawing(&dc);
			for(int i=b;i<=e;i++)	repaintLine(i);
			DrawCaret();
			EndDrawing(false);
			start_x = start_y = end_x = end_y = -1;
			break;
		}
	}
}
// ----------------------------------------------------------------------------
wxString SCD_Terminal::GetAllContent(bool withANSI)			//oҦr
{
    int sx, sy, ex, ey, ss;
    ss = selectState;

    selectState = 3;
    sx = start_x;	sy = start_y;
    ex = end_x;		ey = end_y;
    start_x = 0;	start_y = 0;
    end_x = col_count - 1;		end_y = row_count - 1;

    wxString ret = GetSelectionContent(withANSI);

    selectState = ss;
    start_x = sx;	start_y = sy;
    end_x = ex;		end_y = ey;
    
    return ret;
}    
wxString SCD_Terminal::GetSelectionContent(bool withANSI)	//oҿr
{
	if( selectState != 3 )	return wxEmptyString;
	//selectState = 0;
	
	/*
	if ( start_x == end_x ) {
			CancelSelection();
			return wxEmptyString;
	}
	*/
	//Nrƻswİ
	int s = start_y * col_count + start_x;
	int e = end_y * col_count + end_x;
	if( s > e )
	{
		int i;
		i = start_x;	start_x = end_x;	end_x = i;
		i = start_y;	start_y = end_y;	end_y = i;
	}
	TerminalChar **term;
	if ( _sbar_pos != _sbar_bottom_pos ) {
		term=disp_term;
	}else{
		term=term_data;
	}
	if( term[start_y][start_x].getCharType() == TerminalChar::CH_WORDLAST )
		start_x = start_x - 1;
	if( term[end_y][end_x].getCharType() == TerminalChar::CH_WORDFIRST )
		end_x = end_x + 1;
		
	int _x , _y;
	_y = start_y;
	_x = start_x;
		
	TerminalChar last_char_prop = TerminalChar::getDefaultCharProperty();
	
	wxString buf = wxEmptyString, newlinestr = wxEmptyString;
	if( withANSI )		buf += _T("\x1b[m");

	if ( alt_down ) {
		//wxLogMessage("copy slectState %d start_x %d starty %d endx %d endy %d", selectState,start_x,start_y,end_x,end_y);
		int l = start_x;
		int r = end_x;
		int u = start_y;
		int b = end_y;
		if (start_x > end_x ) {
		 	l = end_x; r=start_x;
		}
		if (start_y > end_y ) {
		 	u = end_y; b = start_y;
		}
		while(1)
		{
			if( _y > end_y || (_y == end_y && _x > end_x) )	break;	//ˬd
	
			if( _x == 0 && _y > start_y )
			{
				buf.Append(_T("\r"));
				//buf.Append(_T("\r\n"));
			}
	
			if( _x == col_count || term[_y][_x].ch == '\0' )	//pGӴF
			{	_x = 0;	_y ++;	continue;	}
	
			if ( _x <= r && _x >= l ) 
				if ( _y <= b && _y >= u ) 
			 		buf.Append( term[_y][_x].ch );
			_x++;
		}
	}else{
		while(1)
		{
	
			if( _y > end_y || (_y == end_y && _x > end_x) )	break;	//ˬd
	
			if( _x == 0 && _y > start_y )
			{
				//buf.Append(_T("\r\n"));
				buf.Append(_T("\r"));
				if( withANSI && _y < row_count)
					buf.Append( term[_y][_x].getANSICode() );
			}
	
			if( _x == col_count || term[_y][_x].ch == '\0' )	//pGӴF
			{	_x = 0;	_y ++;	continue;	}
	
			if( withANSI )
			{
				if( ! last_char_prop.withSameProperty( term[_y][_x] ) )
				{
					buf += term[_y][_x].getDiffANSICode( last_char_prop );
					last_char_prop = term[_y][_x];
				}
			}
					
			buf.Append( term[_y][_x].ch );
			_x++;
	
		}
	}
	/*
	//rꪺ}YMYOur䤤@b, h]ƻst~@b
	if( term_data[start_y][start_x].getCharType() == TerminalChar::CH_WORDLAST )
		start_x = start_x - 1;
	if( term_data[end_y][end_x].getCharType() == TerminalChar::CH_WORDFIRST )
		end_x = end_x + 1;
		
	int _x , _y;
	_y = start_y;
	_x = start_x;
		
	TerminalChar last_char_prop = TerminalChar::getDefaultCharProperty();
	
	wxString buf = wxEmptyString, newlinestr = wxEmptyString;
	if( withANSI )		buf += _T("\x1b[m");
	while(1)
	{

		if( _y > end_y || (_y == end_y && _x > end_x) )	break;	//ˬd

		if( _x == 0 && _y > start_y )
		{
			buf.Append(_T("\r\n"));
			if( withANSI && _y < row_count)
				buf.Append( term_data[_y][_x].getANSICode() );
		}

		if( _x == col_count || term_data[_y][_x].ch == '\0' )	//pGӴF
		{	_x = 0;	_y ++;	continue;	}

		if( withANSI )
		{
			if( ! last_char_prop.withSameProperty( term_data[_y][_x] ) )
			{
				buf += term_data[_y][_x].getDiffANSICode( last_char_prop );
				last_char_prop = term_data[_y][_x];
			}
		}
				
		buf.Append( term_data[_y][_x].ch );
		_x++;

	}
	*/
	if( withANSI )		buf += _T("\x1b[m");
#ifdef __WXDEBUG__
	//wxLogMessage("select text %s",buf);
#endif
	//wxLogMessage("GetSelect %s",buf);
	return buf;
}    

#ifdef __WXGTK__
#include <iconv.h>
char* Big5ToUnicode(char *big5)
{
    static iconv_t cv;
    static bool bl_cv_inited = false;
    static char *inptr;
    static char text[1000], *outptr;
    size_t insize, outsize;
    if(!bl_cv_inited)
    {   
        cv = iconv_open("BIG5" , "Unicode");
        bl_cv_inited = true;
    }
    inptr = (char*)big5;
wxMessageBox(inptr);
    insize = 1000;
    outptr = text;
    outsize = 1000;
#ifdef __LINUX__
    iconv( cv, &inptr, &insize, &outptr, &outsize );
#else
    iconv( cv, (const char**)&inptr, &insize, &outptr, &outsize );
#endif
wxMessageBox(text);
	return strdup(text);
}
#endif

#include <wx/encconv.h>
//#include "scd_gtk_textctrl.h"
#include <wx/textctrl.h>
void SCD_Terminal::CopySelectionToClipboard(bool withANSI)	//NrƻsŶKï
{
	if( selectState != 3 )	return;
	if ( GetSelectionContent(withANSI) == wxEmptyString ) return;	
	CopyToClipboard( GetSelectionContent(withANSI) );
}
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
void SCD_Terminal::OpenSelectionAsHyperlink()
{
	if( selectState != 3 )	return;
	int sx, sy, ex, ey;
	getSelectionInfo( &sx, &sy, &ex, &ey );
	int s = sy * col_count + sx;
	int e = ey * col_count + ex;
	char *link = new char[e-s+1];
	int i = 0;
	for(int y=sy;y<=ey;y++)
	{
		int line_len = getLineLength(y);
		bool b = false;
		for(int x=0;x<line_len;x++)
		{
			if( y==sy && x<sx )	continue;
			if( y==ey && x>ex )	continue;
			char ch = term_data[y][x].ch;
			if(!b)
			{
				if(ch == ' ')	continue;	//C@}YҦťզr
				else b = true;
			}
			link[i++] = ch;
		}
	}
	link[i] = '\0';
	//OpenHyperlink(link);
	delete link;
}
// ----------------------------------------------------------------------------
inline bool isEnglishChar(char c)
{	return ( c >= 'A' && c <= 'Z' ) || ( c >= 'a' && c <= 'z' );	}
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
void SCD_Terminal::SetLineWrapedLength(int len)	//]w۰_檺
{
	if( len < 3 || len > 80 )	return;
	line_wraped_length = len;
}
// ----------------------------------------------------------------------------
int SCD_Terminal::GetLineWrapedLength()
{	return line_wraped_length;	}
// ----------------------------------------------------------------------------
wxString SCD_Terminal::GetLineWrapedString(char *txt)	//N txt ۰_, ϨC@檺rƤ|WLw
{
	if( line_wraped_length <= 0 )	return txt;

	wxString output = wxEmptyString;
	char *r, *line_start;
	int now_line_len;
	line_start = r = txt;

	getXY( & now_line_len , NULL );

	bool commit = false;	//O_n
	while( *r != '\0' )
	{

		if( *r == '\x1b' && r[1] == '[' )	//LX
		{
//wxMessageBox("cotrol code");
			r++;
			while(1)
			{
				r++;
				if( isalpha(*r) )	{	r++;	break;	}
				else if( *r == '\0' )	break;
			}
		}
		else
		{
			if( *r == '\r' )
			{	r++;	continue;	}
			else if( *r == '\n' )	//
			{	commit = true;	}
			else
			{
				if( isWord( r[0], r[1] ) && r[1] != '\0' )	//pGOr
				{
   					if( now_line_len >= line_wraped_length - 1 )	//pGӤrnb
					{	commit = true;	}
					else
					{	r+=2;	now_line_len += 2;	}
				}
				else
				{
					if( now_line_len >= line_wraped_length )	//pGӴF
					{	commit = true;	}
					else
					{	r++;	now_line_len ++;	}
				}
			}

			//commit , line_start bĤ@Ӧr, r b̫@Ӧr
			if( commit )	//pGثe׶WL, h
			{
				bool newline = false;
				if(*r=='\n')	{	r++;	newline = true;	}
				else
				{
					if( now_line_len > 0 && isEnglishChar(*(r-1)) && isEnglishChar(*r) )	//pG^rQ_r
					{
						int c = now_line_len;
						char *p = r;
						for( ; c > 0 && isEnglishChar(*p) ; c-- , p-- );
						if( c > 0 )	{	now_line_len = c;	r = p;	}

						for( ; c > 0 && *p == ' ' ; c-- , p-- );
						now_line_len = c + 1;	r = p + 1;
					}
				}

				output += wxString( line_start , r - line_start );
				if( ! newline )	output += wxString( _T("\r\n") , 2 );
				commit = false;

//    			for( ; *r == ' ' ; r ++ );	//LU@檺}Yť
				line_start = r;
				now_line_len = 0;
			}
		}
	}

	if( now_line_len > 0 )	output += wxString( line_start );
	return output;
}
/*
TermArrayOfColumn * SCD_Terminal::NewLine()
{
	TermArrayOfColumn *col=new TermArrayOfColumn();
	col->Alloc(col_count);
	for ( int j=0;j<col_count;j++){
		col->Add(new TerminalChar());
		TerminalChar *ch = col->Item(j);
	}
	return col;
}
*/
void SCD_Terminal::setLines(int _c, int _r)
{
		/*
	for ( int i =0 ; i< row_count; i++) {
		//(n_lines->Item(i))->Alloc(col_count);
		_lines->Add(NewLine());
	}
	*/
		/*
	link_list_t *old_head=NULL;
	if ( head ) {
			old_head = head;
	}
	*/
	TerminalChar dch = TerminalChar::getDefaultCharProperty();
	head=new link_list_t();
	head->_line=new (TerminalChar[_c]);
	for(int x=0;x<_c;x++)	head->_line[x] = dch;
	head->_len = _c;
	head->_n = NULL;
	//head->_line=
	link_list_t *p=head;
	for (int i=0; i<_max_line;i++) {
		p->_n=new link_list_t();
		p->_n->_p = p;
		p=p->_n;
		p->_line=new (TerminalChar[_c]);
		for(int x=0;x<_c;x++)	
			p->_line[x] = dch;
		p->_len = _c;
		p->_n=NULL;
   	}
	//loop link list
	p->_n = head;
	head->_p = p;
	/*
	if ( old_head ) {
	}
	*/
}

void SCD_Terminal::setTermMaxLine(int _l)
{
	/*
	if ( _max_line == _l ) return;
	TermArrayOfLine *n_lines = new TermArrayOfLine();
	n_lines->Alloc(_l);
	if ( _lines ) {
		if ( _max_line > _l ) {
		}
		for ( int i = 0 ; i < _lines->GetCount(); i++){
			n_lines->Add(_lines->Item(i));
			//n_lines[i] = _lines[i];
		}
		_lines->Clear();
	}else{
		for ( int i =0 ; i< _l; i++) {
			//(n_lines->Item(i))->Alloc(col_count);
			n_lines->Add(NewLine());
		}
	}
	_lines = n_lines;
	_max_line = _l;
	wxLogMessage("new _lines %d",_lines->GetCount());
	*/
}
void SCD_Terminal::ResizeBufferSize(int new_buffer_size)
{
	if ( new_buffer_size == _max_line ) return;
	if ( new_buffer_size < global_max_lines ) return;
	int steps = new_buffer_size - _max_line;
	link_list_t *bottom = cur_head;
	int i=0;
	for ( i=0;i<row_count;i++){
		bottom=bottom->_n;
	}
	int x =0;
	//link_list_t *prev = bottom->_p;
	if ( steps > 0 ) {
		link_list_t *p=bottom;
		link_list_t *n=bottom->_n;
		TerminalChar dch = TerminalChar::getDefaultCharProperty();
		for (x=0;x<steps;x++){
			p->_n=new link_list_t();
			p->_n->_p = p;
			p=p->_n;
			p->_line=new (TerminalChar[col_count]);
			for(int x=0;x<col_count;x++)	
				p->_line[x] = dch;
			p->_len = col_count;
			p->_n=NULL;
		}
		p->_n = n;
		n->_p = p;
	}else{//<0
		link_list_t *p = bottom->_n;
		for ( x=0;x<steps*-1;x++){
			p=p->_n;
			delete p->_p->_line;
			delete p->_p;
		}
		p->_p = bottom;
		bottom->_n = p;
	}
	_max_line = new_buffer_size;
	AdjustScrollBar();
}

// ============================================================================
#endif
