/******************************************************************************
 * Name:        scd_socket.cpp
 * Purpose:     SSH / Telnet socket switcher
 * Author:      Xie, Chun-Da (jakky1)
 * E-mail:      jakky1@gmail.com
 * Created:     2004.7
 * Copyright:   (C) 2004 Xie, Chun-Da
 * Licence:     GPL : http://www.gnu.org/licenses/gpl.html
 * Modified by:
 ******************************************************************************/


#ifndef SCD_SOCKET_H
#define SCD_SOCKET_H
#include "common.h"
#include <wx/socket.h>

#ifndef BBMAN_NO_SSH
	#include "scd_wxssh.h"
#endif
#include "scd_wxexec.h"
#include "scd_wxtelnet.h"

// ============================================================================

class SCD_Socket
{
private:
	//wxSocketClient *telnet_sock;
	wxSocketClient *t_sock;
	//SCD_WXTelnet *telnet_sock;
#ifndef BBMAN_NO_SSH
	SCD_wxSSH *ssh_sock;
#endif
	SCD_wxEXEC *exec_sock;
	SCD_wxTEL *telnet_sock;
	int m_type;	//telnet ? ssh ? unknown ?

	wxEvtHandler *evt_handler;
	int evt_id;
	void *m_clientdata;

	unsigned int local_buf_len;	//oOFѨM wxSocketClient::Unread() Dӳ]

public:
	SCD_Socket();
	~SCD_Socket();

	int GetType();
	void SetType(int _t);
	void SetCMDParent(void *evt) {exec_sock->SetCMDParent(evt);};
#ifndef BBMAN_NO_SSH
	SCD_wxSSH* GetSSH();
#endif
	SCD_wxEXEC* GetEXEC(){if ( m_type == SOCK_EXECMD ) return exec_sock;
							else return NULL;} ;
	SCD_wxTEL* GetTelnet(){if ( m_type == SOCK_TELNET ) return telnet_sock;
							else return NULL;} ;
	bool Connect(wxIPV4address& address, bool wait = true, wxString _username = wxEmptyString);
	bool Connect(SiteInfo &si);
	
#ifndef BBMAN_NO_SSH
	bool Login(wxString _username, wxString _password);	//for scd_wxssh
	bool isLogined();	//for scd_wxssh
#endif
	void Close();
	bool Destroy();

	bool IsDisconnected();
	bool IsConnected();

	int Read(void * buffer, wxUint32 nbytes);
	void Write(const void * buffer, wxUint32 nbytes);
	void Unread(const void * buffer, wxUint32 nbytes);
	wxUint32 LastCount();

	void SetEventHandler(wxEvtHandler& handler, int id = -1);

	void SetClientData(void *data);
	void* GetClientData();
//	inline wxSocketClient *getSock() {return telnet_sock;};
	void SetScrollBarPos(int ydelta);
	void WriteSpecialKey(int key);
	void SendTextToConsole(char *text);
};

// ============================================================================
#endif

