/******************************************************************************
 * Name:        scd_wxssh.cpp
 * Purpose:     a wrapper of SSH in libssh library
 * Author:      Xie, Chun-Da (jakky1)
 * E-mail:      jakky1@gmail.com
 * Created:     2004.7
 * Copyright:   (C) 2004 Xie, Chun-Da
 * Licence:     GPL : http://www.gnu.org/licenses/gpl.html
 * Modified by:
 ******************************************************************************/


#ifndef SCD_COM_SOCK_H
#define SCD_COM_SOCK_H
#include "common.h"
#include "ds.h"
#include <wx/socket.h>
//#include "scd_wxsftp.h"

//#include "ssh/libssh.h"
//#include <wx/thread.h>
#define WXSSH_AUTH_SUCCESS 666	//SSH ߰ݨϥΪ̱KXƥ
#define WXSSH_AUTH_FAIL 667		//SSH ߰ݨϥΪ̱KXƥ
#define SCD_wxSSH_UNREAD_BUF_SIZE 1000

extern "C" {
#include "putty.h"
}


class SCD_wxCOMSOCK
{
public:

public:
	wxString ip;
public:
	int port;
	wxString username, password;

	//ФŦsoܼ
	bool not_read_after_notify;
	wxEvtHandler *evt_handler;
	int evt_id;
	void SendEvent(wxSocketNotify v);

public:
private:

//	char unread_buf[ SCD_wxSSH_UNREAD_BUF_SIZE ];
//	unsigned int unread_len;

	void *m_clientdata;

	unsigned char connect_state;	//0(close) 1(connecting) 2(connected)
	bool blLogined;
	int intLastCount;

 	bool init_ssh_channel();
	void free_ssh_session();

	

public:
	SCD_wxCOMSOCK(wxSocketFlags /*flags*/);
	~SCD_wxCOMSOCK();

	//because the ssh must be closed after all of its sftp are closed,
	//but it may be a trouble for users if you cancel all the sftp immediately
	//when closing ssh, so if you want to delete ssh, try to call Destroy() instead.
	//*** DON'T delete SCD_wxSSH DIRECTLY ***
private:
	//bool m_destroyed;
public:
	bool Destroy();

	//
	bool Connect(wxIPV4address& address, wxString _username);
	bool Login(wxString _username, wxString _password);
	bool isLogined();
	void Close();

	bool IsDisconnected();
	bool IsConnected();

	void Read(void * buffer, wxUint32 nbytes);
	void Write(const void * buffer, wxUint32 nbytes);
	void Unread(const void * buffer, wxUint32 nbytes);
	wxUint32 LastCount();

	void SetEventHandler(wxEvtHandler& handler, int id = -1);

	void SetClientData(void *data);
	void* GetClientData();
	void SetInputBuffer(char *buf,int len);
	void ReSize(int width,int height);
	int from_backend(int is_stderr,const char *data, int len);
	void close_session();
	bool Connect(SiteInfo &si);
	

	//-------------------------------------------------
public:
	int sftp_count;
//	SCD_wxSFTP* CreateSFTP();
	void DeleteSFTP(void *_ftp);

	Backend *back;
	Config cfg;			       
	void *backhandle;
	//char *window_name, *icon_name;
	//Terminal *term;
	//void *ldisc;
	int session_closed;
	//void *logctx;
	//struct unicode_data ucsdata;
	//wxTimer m_timer;
	bool inited;
	Socket	sc;
	SOCKET	socket;
	WSAEVENT netevent;
	//wxString outbuf;
	//SCD_Terminal *disp;
	char unread[30000];
	char input_buf[30000];
	int input_len;
	int unread_len;
	
};

// ============================================================================
#endif

