/* Copyright (C) 2000-2001 Cyrano SA
 
   This file is part of OpenSTA
 
   OpenSTA is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option) any later
   version.
 
   OpenSTA is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.
 
   You should have received a copy of the GNU General Public License along
   with OpenSTA; see the file COPYING.  If not, write to the Free Software
   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 
   For more information about the GNU Public license see:
   http://www.gnu.org/copyleft/gpl.html
 
   OpenSTA is at:
   http://www.opensta.org/
   http://opensta.sourceforge.net/
*/
// CustomTabCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "CustomTabCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCustomTabCtrl

CCustomTabCtrl::CCustomTabCtrl()
{
	m_pCurrentTab = NULL;
}

CCustomTabCtrl::~CCustomTabCtrl()
{
}


BEGIN_MESSAGE_MAP(CCustomTabCtrl, CTabCtrl)
	//{{AFX_MSG_MAP(CCustomTabCtrl)
	ON_WM_ERASEBKGND()
	ON_NOTIFY_REFLECT(TCN_SELCHANGE, OnSelchange)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCustomTabCtrl message handlers

BOOL CCustomTabCtrl::OnEraseBkgnd(CDC* pDC) 
{
	if(m_arWndTabs.GetSize())
	{
		CRect rcClient;
		GetClientRect(&rcClient);
		AdjustRect(FALSE,rcClient);
		pDC->ExcludeClipRect(rcClient);
	}
	return CTabCtrl::OnEraseBkgnd(pDC);
}

void CCustomTabCtrl::OnSelchange(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int nCurSel = GetCurSel();
	if(nCurSel == -1)
		return;

	SetCurrentWindow(nCurSel);
	
	*pResult = 0;
}

void CCustomTabCtrl::OnSize(UINT nType, int cx, int cy) 
{
	CTabCtrl::OnSize(nType, cx, cy);
	
	CRect rcClient(0,0,cx,cy);
	AdjustRect(FALSE,rcClient);

	if(m_pCurrentTab)
		m_pCurrentTab->MoveWindow(rcClient);
}

BOOL CCustomTabCtrl::InsertItem(int nItem,LPCTSTR lpszItem,int nImage,CWnd *pWnd)
{
	m_arWndTabs.InsertAt(nItem,pWnd);
	return CTabCtrl::InsertItem(nItem,lpszItem,nImage);
}

int CCustomTabCtrl::InsertItem(int nItem,LPCTSTR lpszItem,CWnd *pWnd)
{
	m_arWndTabs.InsertAt(nItem,pWnd);
	return CTabCtrl::InsertItem(nItem,lpszItem);
}

int CCustomTabCtrl::SetCurSel(int nItem)
{
	SetCurrentWindow(nItem);
	return CTabCtrl::SetCurSel(nItem);
}

void CCustomTabCtrl::SetCurrentWindow(int nNdx)
{
	if(m_pCurrentTab)
		m_pCurrentTab->ShowWindow(SW_HIDE);
	
	if(m_arWndTabs.GetSize()<= nNdx)
		return;

	m_pCurrentTab = m_arWndTabs[nNdx];
	
	CRect rcClient;
	GetClientRect(&rcClient);
	AdjustRect(FALSE,rcClient);

	m_pCurrentTab->MoveWindow(rcClient);
	m_pCurrentTab->ShowWindow(SW_SHOW);
}

BOOL CCustomTabCtrl::DeleteItem(int nItem)
{
	if(m_arWndTabs[nItem] == m_pCurrentTab)
	{
		if(m_arWndTabs.GetSize() > nItem+1)
			SetCurSel(nItem+1);
		else
		if(m_arWndTabs.GetSize() > 1)
			SetCurSel(nItem-1);
	}

	m_arWndTabs.RemoveAt(nItem);
	return CTabCtrl::DeleteItem(nItem);
}