;*
;* IBMPC1 8x8 Character Set Macros V1.2
;*
;* Library Macros:
;*
;* chr_IBMPC1 -
;*   Insert IBMPC fonts into code.
;*
;*  This macro allows you to insert parts or the whole
;* character set into your code. Parameters: 1=$00-$1f,
;* 2=$20-$3f, 3=$40-$5f, 4=$60-7f, 5=$80-9f, 6=$a0-bf,
;* 7=$c0-df, and 8=$e0-ff. Examples:
;*
;*     chr_IBMPC1 1,8      - Insert chars $00 - $ff.
;*     chr_IBMPC1 2,2      - Insert chars $20 - $3f.
;*

; If all of these are already defined, don't do it again.

        IF      !DEF(IBMPC1_INC)
IBMPC1_INC  SET  1

rev_Check_ibmpc1_inc: MACRO
;NOTE: REVISION NUMBER CHANGES MUST BE ADDED
;TO SECOND PARAMETER IN FOLLOWING LINE.
        IF      \1 > 1.2      ; <--- PUT REVISION NUMBER HERE
        WARN    "Version \1 or later of 'ibmpc1.inc' is required."
        ENDC
        ENDM

chr_IBMPC1: MACRO

        IF      (\1 == 0) || (\2 == 0) || (\1 > \2) || (\2 > 8)
        FAIL    "Font range values are invalid"
        ENDC

        PUSHO
; Define . and X to be 0 and 1
        OPT     b.X

; Characters $00 - $1f

        IF      (\1 == 1)

        DB      %.XXXXXX.  ;Use to be a space ?????
        DB      %.X....X.
        DB      %.X....X.
        DB      %.X....X.
        DB      %.X....X.
        DB      %.X....X.
        DB      %.X....X.
        DB      %.XXXXXX.

        DB      %.XXXXXX.
        DB      %X......X
        DB      %X.X..X.X
        DB      %X......X
        DB      %X.XXXX.X
        DB      %X..XX..X
        DB      %X......X
        DB      %.XXXXXX.

        DB      %.XXXXXX.
        DB      %XXXXXXXX
        DB      %XX.XX.XX
        DB      %XXXXXXXX
        DB      %XX....XX
        DB      %XXX..XXX
        DB      %XXXXXXXX
        DB      %.XXXXXX.

        DB      %.XX.XX..
        DB      %XXXXXXX.
        DB      %XXXXXXX.
        DB      %XXXXXXX.
        DB      %.XXXXX..
        DB      %..XXX...
        DB      %...X....
        DB      %........

        DB      %...X....
        DB      %..XXX...
        DB      %.XXXXX..
        DB      %XXXXXXX.
        DB      %.XXXXX..
        DB      %..XXX...
        DB      %...X....
        DB      %........

        DB      %..XXX...
        DB      %.XXXXX..
        DB      %..XXX...
        DB      %XXXXXXX.
        DB      %XXXXXXX.
        DB      %.XXXXX..
        DB      %..XXX...
        DB      %.XXXXX..

        DB      %...X....
        DB      %...X....
        DB      %..XXX...
        DB      %.XXXXX..
        DB      %XXXXXXX.
        DB      %.XXXXX..
        DB      %..XXX...
        DB      %.XXXXX..

        DB      %........
        DB      %........
        DB      %...XX...
        DB      %..XXXX..
        DB      %..XXXX..
        DB      %...XX...
        DB      %........
        DB      %........

        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXX..XXX
        DB      %XX....XX
        DB      %XX....XX
        DB      %XXX..XXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX

        DB      %........
        DB      %..XXXX..
        DB      %.XX..XX.
        DB      %.X....X.
        DB      %.X....X.
        DB      %.XX..XX.
        DB      %..XXXX..
        DB      %........

        DB      %XXXXXXXX
        DB      %XX....XX
        DB      %X..XX..X
        DB      %X.XXXX.X
        DB      %X.XXXX.X
        DB      %X..XX..X
        DB      %XX....XX
        DB      %XXXXXXXX

        DB      %....XXXX
        DB      %.....XXX
        DB      %....XXXX
        DB      %.XXXXX.X
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...

        DB      %..XXXX..
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %..XXXX..
        DB      %...XX...
        DB      %.XXXXXX.
        DB      %...XX...

        DB      %..XXXXXX
        DB      %..XX..XX
        DB      %..XXXXXX
        DB      %..XX....
        DB      %..XX....
        DB      %.XXX....
        DB      %XXXX....
        DB      %XXX.....

        DB      %.XXXXXXX
        DB      %.XX...XX
        DB      %.XXXXXXX
        DB      %.XX...XX
        DB      %.XX...XX
        DB      %.XX..XXX
        DB      %XXX..XX.
        DB      %XX......

        DB      %X..XX..X
        DB      %.X.XX.X.
        DB      %..XXXX..
        DB      %XXX..XXX
        DB      %XXX..XXX
        DB      %..XXXX..
        DB      %.X.XX.X.
        DB      %X..XX..X

        DB      %X.......
        DB      %XXX.....
        DB      %XXXXX...
        DB      %XXXXXXX.
        DB      %XXXXX...
        DB      %XXX.....
        DB      %X.......
        DB      %........

        DB      %......X.
        DB      %....XXX.
        DB      %..XXXXX.
        DB      %XXXXXXX.
        DB      %..XXXXX.
        DB      %....XXX.
        DB      %......X.
        DB      %........

        DB      %...XX...
        DB      %..XXXX..
        DB      %.XXXXXX.
        DB      %...XX...
        DB      %...XX...
        DB      %.XXXXXX.
        DB      %..XXXX..
        DB      %...XX...

        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %........
        DB      %.XX..XX.
        DB      %........

        DB      %.XXXXXXX
        DB      %XX.XX.XX
        DB      %XX.XX.XX
        DB      %.XXXX.XX
        DB      %...XX.XX
        DB      %...XX.XX
        DB      %...XX.XX
        DB      %........

        DB      %..XXXXX.
        DB      %.XX...XX
        DB      %..XXX...
        DB      %.XX.XX..
        DB      %.XX.XX..
        DB      %..XXX...
        DB      %XX..XX..
        DB      %.XXXX...

        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %.XXXXXX.
        DB      %.XXXXXX.
        DB      %.XXXXXX.
        DB      %........

        DB      %...XX...
        DB      %..XXXX..
        DB      %.XXXXXX.
        DB      %...XX...
        DB      %.XXXXXX.
        DB      %..XXXX..
        DB      %...XX...
        DB      %XXXXXXXX

        DB      %...XX...
        DB      %..XXXX..
        DB      %.XXXXXX.
        DB      %...XX...
        DB      %...XX...
        DB      %...XX...
        DB      %...XX...
        DB      %........

        DB      %...XX...
        DB      %...XX...
        DB      %...XX...
        DB      %...XX...
        DB      %.XXXXXX.
        DB      %..XXXX..
        DB      %...XX...
        DB      %........

        DB      %........
        DB      %...XX...
        DB      %....XX..
        DB      %XXXXXXX.
        DB      %....XX..
        DB      %...XX...
        DB      %........
        DB      %........

        DB      %........
        DB      %..XX....
        DB      %.XX.....
        DB      %XXXXXXX.
        DB      %.XX.....
        DB      %..XX....
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %XX......
        DB      %XX......
        DB      %XX......
        DB      %XXXXXXX.
        DB      %........
        DB      %........

        DB      %........
        DB      %..X..X..
        DB      %.XX..XX.
        DB      %XXXXXXXX
        DB      %.XX..XX.
        DB      %..X..X..
        DB      %........
        DB      %........

        DB      %........
        DB      %...XX...
        DB      %..XXXX..
        DB      %.XXXXXX.
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %........
        DB      %........

        DB      %........
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %.XXXXXX.
        DB      %..XXXX..
        DB      %...XX...
        DB      %........
        DB      %........

        ENDC

; Characters $20 - $3f

        IF      (\1 < 3) && (\2 > 1)

        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %........
        DB      %..XX....
        DB      %........

        DB      %.XX.XX..
        DB      %.XX.XX..
        DB      %.XX.XX..
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %.XX.XX..
        DB      %.XX.XX..
        DB      %XXXXXXX.
        DB      %.XX.XX..
        DB      %XXXXXXX.
        DB      %.XX.XX..
        DB      %.XX.XX..
        DB      %........

        DB      %..XX....
        DB      %.XXXXX..
        DB      %XX......
        DB      %.XXXX...
        DB      %....XX..
        DB      %XXXXX...
        DB      %..XX....
        DB      %........

        DB      %........
        DB      %XX...XX.
        DB      %XX..XX..
        DB      %...XX...
        DB      %..XX....
        DB      %.XX..XX.
        DB      %XX...XX.
        DB      %........

        DB      %..XXX...
        DB      %.XX.XX..
        DB      %..XXX...
        DB      %.XXX.XX.
        DB      %XX.XXX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %.XX.....
        DB      %.XX.....
        DB      %XX......
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %...XX...
        DB      %..XX....
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XX.....
        DB      %..XX....
        DB      %...XX...
        DB      %........

        DB      %.XX.....
        DB      %..XX....
        DB      %...XX...
        DB      %...XX...
        DB      %...XX...
        DB      %..XX....
        DB      %.XX.....
        DB      %........

        DB      %........
        DB      %.XX..XX.
        DB      %..XXXX..
        DB      %XXXXXXXX
        DB      %..XXXX..
        DB      %.XX..XX.
        DB      %........
        DB      %........

        DB      %........
        DB      %..XX....
        DB      %..XX....
        DB      %XXXXXX..
        DB      %..XX....
        DB      %..XX....
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %..XX....
        DB      %..XX....
        DB      %.XX.....

        DB      %........
        DB      %........
        DB      %........
        DB      %XXXXXX..
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %..XX....
        DB      %..XX....
        DB      %........

        DB      %.....XX.
        DB      %....XX..
        DB      %...XX...
        DB      %..XX....
        DB      %.XX.....
        DB      %XX......
        DB      %X.......
        DB      %........

        DB      %.XXXXX..
        DB      %XX...XX.
        DB      %XX..XXX.
        DB      %XX.XXXX.
        DB      %XXXX.XX.
        DB      %XXX..XX.
        DB      %.XXXXX..
        DB      %........

        DB      %..XX....
        DB      %.XXX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %XXXXXX..
        DB      %........

        DB      %.XXXX...
        DB      %XX..XX..
        DB      %....XX..
        DB      %..XXX...
        DB      %.XX.....
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %........

        DB      %.XXXX...
        DB      %XX..XX..
        DB      %....XX..
        DB      %..XXX...
        DB      %....XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %...XXX..
        DB      %..XXXX..
        DB      %.XX.XX..
        DB      %XX..XX..
        DB      %XXXXXXX.
        DB      %....XX..
        DB      %...XXXX.
        DB      %........

        DB      %XXXXXX..
        DB      %XX......
        DB      %XXXXX...
        DB      %....XX..
        DB      %....XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %..XXX...
        DB      %.XX.....
        DB      %XX......
        DB      %XXXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %XXXXXX..
        DB      %XX..XX..
        DB      %....XX..
        DB      %...XX...
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %........

        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXXX..
        DB      %....XX..
        DB      %...XX...
        DB      %.XXX....
        DB      %........

        DB      %........
        DB      %..XX....
        DB      %..XX....
        DB      %........
        DB      %........
        DB      %..XX....
        DB      %..XX....
        DB      %........

        DB      %........
        DB      %..XX....
        DB      %..XX....
        DB      %........
        DB      %........
        DB      %..XX....
        DB      %..XX....
        DB      %.XX.....

        DB      %...XX...
        DB      %..XX....
        DB      %.XX.....
        DB      %XX......
        DB      %.XX.....
        DB      %..XX....
        DB      %...XX...
        DB      %........

        DB      %........
        DB      %........
        DB      %XXXXXX..
        DB      %........
        DB      %........
        DB      %XXXXXX..
        DB      %........
        DB      %........

        DB      %.XX.....
        DB      %..XX....
        DB      %...XX...
        DB      %....XX..
        DB      %...XX...
        DB      %..XX....
        DB      %.XX.....
        DB      %........

        DB      %.XXXX...
        DB      %XX..XX..
        DB      %....XX..
        DB      %...XX...
        DB      %..XX....
        DB      %........
        DB      %..XX....
        DB      %........

        ENDC

; Characters $40 - $5f

        IF      (\1 < 4) && (\2 > 2)

        DB      %.XXXXX..
        DB      %XX...XX.
        DB      %XX.XXXX.
        DB      %XX.XXXX.
        DB      %XX.XXXX.
        DB      %XX......
        DB      %.XXXX...
        DB      %........

        DB      %..XX....
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %........

        DB      %XXXXXX..
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XXXXX..
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %XXXXXX..
        DB      %........

        DB      %..XXXX..
        DB      %.XX..XX.
        DB      %XX......
        DB      %XX......
        DB      %XX......
        DB      %.XX..XX.
        DB      %..XXXX..
        DB      %........

        DB      %XXXXX...
        DB      %.XX.XX..
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XX.XX..
        DB      %XXXXX...
        DB      %........

        DB      %.XXXXXX.
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XXXX...
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XXXXXX.
        DB      %........

        DB      %.XXXXXX.
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XXXX...
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XX.....
        DB      %........

        DB      %..XXXX..
        DB      %.XX..XX.
        DB      %XX......
        DB      %XX......
        DB      %XX..XXX.
        DB      %.XX..XX.
        DB      %..XXXXX.
        DB      %........

        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %........

        DB      %.XXXX...
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %.XXXX...
        DB      %........

        DB      %...XXXX.
        DB      %....XX..
        DB      %....XX..
        DB      %....XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %XXX..XX.
        DB      %.XX..XX.
        DB      %.XX.XX..
        DB      %.XXXX...
        DB      %.XX.XX..
        DB      %.XX..XX.
        DB      %XXX..XX.
        DB      %........

        DB      %.XX.....
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XXXXXX.
        DB      %........

        DB      %XX...XX.
        DB      %XXX.XXX.
        DB      %XXXXXXX.
        DB      %XXXXXXX.
        DB      %XX.X.XX.
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %........

        DB      %XX...XX.
        DB      %XXX..XX.
        DB      %XXXX.XX.
        DB      %XX.XXXX.
        DB      %XX..XXX.
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %........

        DB      %..XXX...
        DB      %.XX.XX..
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %.XX.XX..
        DB      %..XXX...
        DB      %........

        DB      %XXXXXX..
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XXXXX..
        DB      %.XX.....
        DB      %.XX.....
        DB      %XXXX....
        DB      %........

        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX.XXX..
        DB      %.XXXX...
        DB      %...XXX..
        DB      %........

        DB      %XXXXXX..
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XXXXX..
        DB      %.XX.XX..
        DB      %.XX..XX.
        DB      %XXX..XX.
        DB      %........

        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XXX.....
        DB      %.XXXX...
        DB      %...XXX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %XXXXXX..
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %........

        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %........

        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %..XX....
        DB      %........

        DB      %XX...XX.
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %XX.X.XX.
        DB      %XXXXXXX.
        DB      %XXX.XXX.
        DB      %XX...XX.
        DB      %........

        DB      %XX...XX.
        DB      %XX...XX.
        DB      %.XX.XX..
        DB      %..XXX...
        DB      %..XXX...
        DB      %.XX.XX..
        DB      %XX...XX.
        DB      %........

        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %..XX....
        DB      %..XX....
        DB      %.XXXX...
        DB      %........

        DB      %XXXXXXX.
        DB      %.....XX.
        DB      %....XX..
        DB      %...XX...
        DB      %..XX....
        DB      %.XX.....
        DB      %XXXXXXX.
        DB      %........

        DB      %.XXXX...
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XXXX...
        DB      %........

        DB      %XX......
        DB      %.XX.....
        DB      %..XX....
        DB      %...XX...
        DB      %....XX..
        DB      %.....XX.
        DB      %......X.
        DB      %........

        DB      %.XXXX...
        DB      %...XX...
        DB      %...XX...
        DB      %...XX...
        DB      %...XX...
        DB      %...XX...
        DB      %.XXXX...
        DB      %........

        DB      %...X....
        DB      %..XXX...
        DB      %.XX.XX..
        DB      %XX...XX.
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %XXXXXXXX

        ENDC

; Characters $60 - $7f

        IF      (\1 < 5) && (\2 > 3)

        DB      %..XX....
        DB      %..XX....
        DB      %...XX...
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %.XXXX...
        DB      %....XX..
        DB      %.XXXXX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %XXX.....
        DB      %.XX.....
        DB      %.XX.....
        DB      %.XXXXX..
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %XX.XXX..
        DB      %........

        DB      %........
        DB      %........
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX......
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %...XXX..
        DB      %....XX..
        DB      %....XX..
        DB      %.XXXXX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %........
        DB      %........
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %XX......
        DB      %.XXXX...
        DB      %........

        DB      %..XXX...
        DB      %.XX.XX..
        DB      %.XX.....
        DB      %XXXX....
        DB      %.XX.....
        DB      %.XX.....
        DB      %XXXX....
        DB      %........

        DB      %........
        DB      %........
        DB      %.XXX.XX.
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXXX..
        DB      %....XX..
        DB      %XXXXX...

        DB      %XXX.....
        DB      %.XX.....
        DB      %.XX.XX..
        DB      %.XXX.XX.
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %XXX..XX.
        DB      %........

        DB      %..XX....
        DB      %........
        DB      %.XXX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %.XXXX...
        DB      %........

        DB      %....XX..
        DB      %........
        DB      %....XX..
        DB      %....XX..
        DB      %....XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...

        DB      %XXX.....
        DB      %.XX.....
        DB      %.XX..XX.
        DB      %.XX.XX..
        DB      %.XXXX...
        DB      %.XX.XX..
        DB      %XXX..XX.
        DB      %........

        DB      %.XXX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %.XXXX...
        DB      %........

        DB      %........
        DB      %........
        DB      %XX..XX..
        DB      %XXXXXXX.
        DB      %XXXXXXX.
        DB      %XX.X.XX.
        DB      %XX...XX.
        DB      %........

        DB      %........
        DB      %........
        DB      %XXXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %........

        DB      %........
        DB      %........
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %........
        DB      %........
        DB      %XX.XXX..
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XXXXX..
        DB      %.XX.....
        DB      %XXXX....

        DB      %........
        DB      %........
        DB      %.XXX.XX.
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXXX..
        DB      %....XX..
        DB      %...XXXX.

        DB      %........
        DB      %........
        DB      %XX.XXX..
        DB      %.XXX.XX.
        DB      %.XX..XX.
        DB      %.XX.....
        DB      %XXXX....
        DB      %........

        DB      %........
        DB      %........
        DB      %.XXXXX..
        DB      %XX......
        DB      %.XXXX...
        DB      %....XX..
        DB      %XXXXX...
        DB      %........

        DB      %...X....
        DB      %..XX....
        DB      %.XXXXX..
        DB      %..XX....
        DB      %..XX....
        DB      %..XX.X..
        DB      %...XX...
        DB      %........

        DB      %........
        DB      %........
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %........
        DB      %........
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %..XX....
        DB      %........

        DB      %........
        DB      %........
        DB      %XX...XX.
        DB      %XX.X.XX.
        DB      %XXXXXXX.
        DB      %XXXXXXX.
        DB      %.XX.XX..
        DB      %........

        DB      %........
        DB      %........
        DB      %XX...XX.
        DB      %.XX.XX..
        DB      %..XXX...
        DB      %.XX.XX..
        DB      %XX...XX.
        DB      %........

        DB      %........
        DB      %........
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXXX..
        DB      %....XX..
        DB      %XXXXX...

        DB      %........
        DB      %........
        DB      %XXXXXX..
        DB      %X..XX...
        DB      %..XX....
        DB      %.XX..X..
        DB      %XXXXXX..
        DB      %........

        DB      %...XXX..
        DB      %..XX....
        DB      %..XX....
        DB      %XXX.....
        DB      %..XX....
        DB      %..XX....
        DB      %...XXX..
        DB      %........

        DB      %...XX...
        DB      %...XX...
        DB      %...XX...
        DB      %........
        DB      %...XX...
        DB      %...XX...
        DB      %...XX...
        DB      %........

        DB      %XXX.....
        DB      %..XX....
        DB      %..XX....
        DB      %...XXX..
        DB      %..XX....
        DB      %..XX....
        DB      %XXX.....
        DB      %........

        DB      %.XXX.XX.
        DB      %XX.XXX..
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %...X....
        DB      %..XXX...
        DB      %.XX.XX..
        DB      %XX...XX.
        DB      %XXXXXXX.
        DB      %........
        DB      %........

        ENDC

; Characters $80 - $9f

        IF      (\1 < 6) && (\2 > 4)

        DB      %..XXXX..
        DB      %.XX..XX.
        DB      %XX......
        DB      %XX......
        DB      %.XX..XX.
        DB      %..XXXX..
        DB      %....X...
        DB      %...XX...

        DB      %..X.X...
        DB      %........
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %....X...
        DB      %...X....
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %XX......
        DB      %.XXXX...
        DB      %........

        DB      %...X....
        DB      %..X.X...
        DB      %.XXXX...
        DB      %....XX..
        DB      %.XXXXX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %..X.X...
        DB      %........
        DB      %.XXXX...
        DB      %....XX..
        DB      %.XXXXX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %..X.....
        DB      %...X....
        DB      %.XXXX...
        DB      %....XX..
        DB      %.XXXXX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %...XX...
        DB      %...XX...
        DB      %.XXXX...
        DB      %....XX..
        DB      %.XXXXX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %........
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX......
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %...X....
        DB      %..XX....

        DB      %...X....
        DB      %..X.X...
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %XX......
        DB      %.XXXX...
        DB      %........

        DB      %..X.X...
        DB      %........
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %XX......
        DB      %.XXXX...
        DB      %........

        DB      %..X.....
        DB      %...X....
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %XX......
        DB      %.XXXX...
        DB      %........

        DB      %..X.X...
        DB      %........
        DB      %.XXX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %.XXXX...
        DB      %........

        DB      %...X....
        DB      %..X.X...
        DB      %.XXX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %.XXXX...
        DB      %........

        DB      %...X....
        DB      %....X...
        DB      %.XXX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %.XXXX...
        DB      %........

        DB      %..X.X...
        DB      %..XX....
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %........

        DB      %..XX....
        DB      %.X..X...
        DB      %..XX....
        DB      %XX..XX..
        DB      %XXXXXX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %........

        DB      %....X...
        DB      %...X....
        DB      %.XXXXXX.
        DB      %.XX.....
        DB      %.XXXX...
        DB      %.XX.....
        DB      %.XXXXXX.
        DB      %........

        DB      %........
        DB      %........
        DB      %.XX.XX..
        DB      %...X..X.
        DB      %.XXXXXX.
        DB      %X..X....
        DB      %.XXXXXX.
        DB      %........

        DB      %..XXXXX.
        DB      %.X.X....
        DB      %X..X....
        DB      %X..XXX..
        DB      %XXXX....
        DB      %X..X....
        DB      %X..XXXX.
        DB      %........

        DB      %...X....
        DB      %..X.X...
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %..X.X...
        DB      %........
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %..X.....
        DB      %...X....
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %...X....
        DB      %..X.X...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %..X.....
        DB      %...X....
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %..X.X...
        DB      %........
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXXX..
        DB      %....XX..
        DB      %XXXXX...

        DB      %..X.X...
        DB      %.XXXXX..
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %.XXXXX..
        DB      %........

        DB      %..X.X...
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %XX...XX.
        DB      %.XXXXX..
        DB      %........

        DB      %........
        DB      %...X....
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX......
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %...X....

        DB      %..XXX...
        DB      %.X...X..
        DB      %.X......
        DB      %XXXX....
        DB      %.X......
        DB      %.X......
        DB      %XXXXXXX.
        DB      %........

        DB      %XX....XX
        DB      %.XX..XX.
        DB      %..XXXX..
        DB      %.XXXXXX.
        DB      %...XX...
        DB      %.XXXXXX.
        DB      %...XX...
        DB      %........

        DB      %XXXXXX..
        DB      %.XX..XX.
        DB      %.XX..XX.
        DB      %.XXXXX..
        DB      %.XX.....
        DB      %.XX.....
        DB      %XXXX....
        DB      %........

        DB      %...XXX..
        DB      %..XX....
        DB      %XXXXXX..
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %XXX.....

        ENDC

; Characters $a0 - $bf

        IF      (\1 < 7) && (\2 > 5)

        DB      %....X...
        DB      %...X....
        DB      %.XXXX...
        DB      %....XX..
        DB      %.XXXXX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %...X....
        DB      %..X.....
        DB      %.XXX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %.XXXX...
        DB      %........

        DB      %...X....
        DB      %..X.....
        DB      %.XXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXXX...
        DB      %........

        DB      %...X....
        DB      %..X.....
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %.XXX.XX.
        DB      %........

        DB      %..XX..X.
        DB      %.X..XX..
        DB      %XXXXX...
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %XX..XX..
        DB      %........

        DB      %..XX..X.
        DB      %.X..XX..
        DB      %XX...XX.
        DB      %XXX..XX.
        DB      %XX.X.XX.
        DB      %XX..XXX.
        DB      %XX...XX.
        DB      %........

        DB      %........
        DB      %..XXX...
        DB      %....XX..
        DB      %..XXXX..
        DB      %.XX.XX..
        DB      %..XX.XX.
        DB      %........
        DB      %........

        DB      %........
        DB      %..XXX...
        DB      %.X...X..
        DB      %.X...X..
        DB      %..XXX...
        DB      %........
        DB      %........
        DB      %........

        DB      %...XX...
        DB      %........
        DB      %...XX...
        DB      %..XX....
        DB      %.XX.....
        DB      %.XX..XX.
        DB      %..XXXX..
        DB      %........

        DB      %........
        DB      %........
        DB      %XXXXXXX.
        DB      %X.......
        DB      %X.......
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %XXXXXXX.
        DB      %......X.
        DB      %......X.
        DB      %........
        DB      %........
        DB      %........

        DB      %.X....X.
        DB      %.X...X..
        DB      %.X..X...
        DB      %.X.X.XX.
        DB      %..X.X..X
        DB      %.X...XX.
        DB      %X...X...
        DB      %...XXXXX

        DB      %.X....X.
        DB      %.X...X..
        DB      %.X..X...
        DB      %.X.X.XX.
        DB      %..X.X.X.
        DB      %.X.XXXXX
        DB      %X.....X.
        DB      %.....XXX

        DB      %..XX....
        DB      %........
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %..XX....
        DB      %........

        DB      %........
        DB      %..X..X..
        DB      %.X..X...
        DB      %X..X....
        DB      %.X..X...
        DB      %..X..X..
        DB      %........
        DB      %........

        DB      %........
        DB      %.X..X...
        DB      %..X..X..
        DB      %...X..X.
        DB      %..X..X..
        DB      %.X..X...
        DB      %........
        DB      %........

        DB      %X...X...
        DB      %..X...X.
        DB      %X...X...
        DB      %..X...X.
        DB      %X...X...
        DB      %........
        DB      %X...X...
        DB      %..X...X.

        DB      %X.X.X.X.
        DB      %.X.X.X.X
        DB      %X.X.X.X.
        DB      %.X.X.X.X
        DB      %X.X.X.X.
        DB      %........
        DB      %X.X.X.X.
        DB      %.X.X.X.X

        DB      %.XXX.XXX
        DB      %XX.XXX.X
        DB      %.XXX.XXX
        DB      %XX.XXX.X
        DB      %.XXX.XXX
        DB      %XXXXXXXX
        DB      %.XXX.XXX
        DB      %XX.XXX.X

        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %XXXX....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %...X....
        DB      %...X....
        DB      %XXXX....
        DB      %...X....
        DB      %XXXX....
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %XXX.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %........
        DB      %........
        DB      %........
        DB      %XXXXX...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %........
        DB      %........
        DB      %XXXX....
        DB      %...X....
        DB      %XXXX....
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %..X.X...
        DB      %..X.X...
        DB      %XXX.X...
        DB      %....X...
        DB      %XXX.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %........
        DB      %........
        DB      %XXXXX...
        DB      %....X...
        DB      %XXX.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %..X.X... ;bc
        DB      %..X.X...
        DB      %XXX.X...
        DB      %....X...
        DB      %XXXXX...
        DB      %........
        DB      %........
        DB      %........

        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %XXXXX...
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %...X.... ;be
        DB      %...X....
        DB      %XXXX....
        DB      %...X....
        DB      %XXXX....
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %........
        DB      %XXXX....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....

        ENDC

; Characters $c0 - $df

        IF      (\1 < 8) && (\2 > 6)

        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...XXXXX
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %XXXXXXXX
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %........ ;c2
        DB      %........
        DB      %........
        DB      %XXXXXXXX
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...XXXXX
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %........ ;c4
        DB      %........
        DB      %........
        DB      %XXXXXXXX
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %XXXXXXXX
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %...X.... ;c6
        DB      %...X....
        DB      %...XXXXX
        DB      %...X....
        DB      %...XXXXX
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.XXXX
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %..X.X... ;c8
        DB      %..X.X...
        DB      %..X.XXXX
        DB      %..X.....
        DB      %..XXXXXX
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %..XXXXXX
        DB      %..X.....
        DB      %..X.XXXX
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %..X.X... ;ca
        DB      %..X.X...
        DB      %XXX.XXXX
        DB      %........
        DB      %XXXXXXXX
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %XXXXXXXX
        DB      %........
        DB      %XXX.XXXX
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %..X.X... ;cc
        DB      %..X.X...
        DB      %..X.XXXX
        DB      %..X.....
        DB      %..X.XXXX
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %........
        DB      %........
        DB      %XXXXXXXX
        DB      %........
        DB      %XXXXXXXX
        DB      %........
        DB      %........
        DB      %........

        DB      %..X.X...
        DB      %..X.X...
        DB      %XXX.XXXX
        DB      %........
        DB      %XXX.XXXX
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %...X....
        DB      %...X....
        DB      %XXXXXXXX
        DB      %........
        DB      %XXXXXXXX
        DB      %........
        DB      %........
        DB      %........

        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %XXXXXXXX
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %XXXXXXXX
        DB      %........
        DB      %XXXXXXXX
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %........
        DB      %........
        DB      %........
        DB      %XXXXXXXX
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..XXXXXX
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %...X....
        DB      %...X....
        DB      %...XXXXX
        DB      %...X....
        DB      %...XXXXX
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %...XXXXX
        DB      %...X....
        DB      %...XXXXX
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %........
        DB      %........
        DB      %........
        DB      %..XXXXXX
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %XXXXXXXX
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...
        DB      %..X.X...

        DB      %...X....
        DB      %...X....
        DB      %XXXXXXXX
        DB      %...X....
        DB      %XXXXXXXX
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %XXXX....
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %........
        DB      %...XXXXX
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX

        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX

        DB      %XXXX....
        DB      %XXXX....
        DB      %XXXX....
        DB      %XXXX....
        DB      %XXXX....
        DB      %XXXX....
        DB      %XXXX....
        DB      %XXXX....

        DB      %....XXXX
        DB      %....XXXX
        DB      %....XXXX
        DB      %....XXXX
        DB      %....XXXX
        DB      %....XXXX
        DB      %....XXXX
        DB      %....XXXX

        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        ENDC

; Characters $e0 - $ff

        IF      (\1 < 9) && (\2 > 7)

        DB      %........
        DB      %........
        DB      %........
        DB      %.XXX..X.
        DB      %X...XX..
        DB      %X...X...
        DB      %.XXX.X.
        DB      %........

        DB      %..XX....
        DB      %.X..X...
        DB      %.X..X...
        DB      %.XXXXX..
        DB      %.X....X.
        DB      %.X....X.
        DB      %XX.XXX..
        DB      %........

        DB      %........
        DB      %........
        DB      %XXXXXXX.
        DB      %.X....X.
        DB      %.X......
        DB      %.X......
        DB      %XXX.....
        DB      %........

        DB      %........
        DB      %........
        DB      %XXXXXXX.
        DB      %.X...X..
        DB      %.X...X..
        DB      %.X...X..
        DB      %XXX.XXX.
        DB      %........

        DB      %XXXXXXX.
        DB      %.X....X.
        DB      %..X.....
        DB      %...X....
        DB      %..X.....
        DB      %.X....X.
        DB      %XXXXXXX.
        DB      %........

        DB      %........
        DB      %........
        DB      %........
        DB      %..XXXXX.
        DB      %.X...X..
        DB      %.X...X..
        DB      %..XXX...
        DB      %........

        DB      %........
        DB      %........
        DB      %XX..XX..
        DB      %.X...X..
        DB      %.X...X..
        DB      %.X...X..
        DB      %.XXXX.X.
        DB      %.X......

        DB      %........
        DB      %........
        DB      %.XXXXX..
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...XXX..
        DB      %........

        DB      %........
        DB      %...X....
        DB      %.XXXXX..
        DB      %X..X..X.
        DB      %X..X..X.
        DB      %.XXXXX..
        DB      %...X....
        DB      %........

        DB      %........
        DB      %........
        DB      %.XXXXX..
        DB      %X.....X.
        DB      %X.XXX.X.
        DB      %X.....X.
        DB      %.XXXXX..
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %.XXXXX..
        DB      %X.....X.
        DB      %X.....X.
        DB      %.XX.XX..
        DB      %..X.X...
        DB      %XXX.XXX.
        DB      %........

        DB      %........
        DB      %.XXXXX..
        DB      %..X.....
        DB      %..XXX...
        DB      %.X...X..
        DB      %.X...X..
        DB      %..XXX...
        DB      %........

        DB      %........
        DB      %........
        DB      %.XX.XX..
        DB      %X..X..X.
        DB      %X..X..X.
        DB      %.XX.XX..
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %.X..XX..
        DB      %X..X..X.
        DB      %X..X..X.
        DB      %.XXXXX..
        DB      %...X....
        DB      %........

        DB      %........
        DB      %........
        DB      %..XXXX..
        DB      %.X......
        DB      %..XX....
        DB      %.X......
        DB      %..XXXX..
        DB      %........

        DB      %........
        DB      %........
        DB      %..XXXX..
        DB      %.X....X.
        DB      %.X....X.
        DB      %.X....X.
        DB      %.X....X.
        DB      %........

        DB      %........
        DB      %XXXXXXX.
        DB      %........
        DB      %XXXXXXX.
        DB      %........
        DB      %XXXXXXX.
        DB      %........
        DB      %........

        DB      %...X....
        DB      %...X....
        DB      %XXXXXXX.
        DB      %...X....
        DB      %...X....
        DB      %XXXXXXX.
        DB      %........
        DB      %........

        DB      %.X......
        DB      %...X....
        DB      %.....X..
        DB      %...X....
        DB      %.X......
        DB      %XXXXXXX.
        DB      %........
        DB      %........

        DB      %.....X..
        DB      %...X....
        DB      %.X......
        DB      %...X....
        DB      %.....X..
        DB      %XXXXXXX.
        DB      %........
        DB      %........

        DB      %....XX..
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....

        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %...X....
        DB      %.XX.....

        DB      %........
        DB      %........
        DB      %...X....
        DB      %........
        DB      %XXXXXXX.
        DB      %........
        DB      %...X....
        DB      %........

        DB      %........
        DB      %.XX...X.
        DB      %X..XXX..
        DB      %........
        DB      %.XX...X.
        DB      %X..XXX..
        DB      %........
        DB      %........

        DB      %..XX....
        DB      %.X..X...
        DB      %.X..X...
        DB      %..XX....
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %........
        DB      %..XX....
        DB      %..XX....
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %....X...
        DB      %........
        DB      %........
        DB      %........

        DB      %.......X
        DB      %......X.
        DB      %XXX...X.
        DB      %..X..X..
        DB      %...X.X..
        DB      %...XX...
        DB      %....X...
        DB      %........

        DB      %........
        DB      %........
        DB      %.X.XX...
        DB      %..X..X..
        DB      %..X..X..
        DB      %........
        DB      %........
        DB      %........

        DB      %..XX....
        DB      %.X..X...
        DB      %...X....
        DB      %..X.....
        DB      %.XXXX...
        DB      %........
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %XXXXXXXX
        DB      %........
        DB      %........

        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........
        DB      %........

        ENDC

        POPO

        ENDM

        ENDC    ;IBMPC_INC

