/*
 * JViewportBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JViewport class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JViewport properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JViewportBeanInfo extends SwingBeanInfo 
{
    private static final Class classJViewport = com.sun.java.swing.JViewport.class;

    /**
     * @return a JViewport BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJViewport, new Object[] {
				PREFERRED, Boolean.TRUE,
				
			        SHORTDESCRIPTION, "JViewport"
	    }			    
        );            	       		    
    }


    /**
     * Create a JViewport PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JViewport.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JViewport PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJViewport, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JViewport.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JViewport
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("viewPosition", new Object[] {
                 SHORTDESCRIPTION, "viewPosition",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("view", new Object[] {
                 SHORTDESCRIPTION, "view",
               }
             ),
             
             createPropertyDescriptor("insets", new Object[] {
                 SHORTDESCRIPTION, "insets",
               }
             ),
             
             createPropertyDescriptor("viewRect", new Object[] {
                 SHORTDESCRIPTION, "viewRect",
               }
             ),
             
             createPropertyDescriptor("optimizedDrawingEnabled", new Object[] {
                 SHORTDESCRIPTION, "optimizedDrawingEnabled",
               }
             ),
             
             createPropertyDescriptor("viewSize", new Object[] {
                 SHORTDESCRIPTION, "viewSize",
               }
             ),
             
             createPropertyDescriptor("backingStoreEnabled", new Object[] {
                 SHORTDESCRIPTION, "backingStoreEnabled",
               }
             ),
             
             createPropertyDescriptor("extentSize", new Object[] {
                 SHORTDESCRIPTION, "extentSize",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JViewport
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JViewportColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JViewportColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JViewportMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JViewportMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


