/*
 * JTreeBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JTree class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JTree properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JTreeBeanInfo extends SwingBeanInfo 
{
    private static final Class classJTree = com.sun.java.swing.JTree.class;

    /**
     * @return a JTree BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJTree, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.FALSE,
     
			        SHORTDESCRIPTION, "<A description of this component>."
	    }			    
        );            	       		    
    }


    /**
     * Create a JTree PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JTree.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JTree PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJTree, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JTree.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JTree
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("selectionCount", new Object[] {
                 SHORTDESCRIPTION, "selectionCount",
               }
             ),
             
             createPropertyDescriptor("visibleRowCount", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The number of rows that are to be visible.",
               }
             ),
             
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("editing", new Object[] {
                 SHORTDESCRIPTION, "editing",
               }
             ),
             
             createPropertyDescriptor("selectionEmpty", new Object[] {
                 SHORTDESCRIPTION, "selectionEmpty",
               }
             ),
             
             createPropertyDescriptor("editingPath", new Object[] {
                 SHORTDESCRIPTION, "editingPath",
               }
             ),
             
             createPropertyDescriptor("selectionPaths", new Object[] {
                 SHORTDESCRIPTION, "selectionPaths",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("invokesStopCellEditing", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Determines what happens when editing is interrupted, selecting another node in the tree, a change in the tree's data, or some other means.",
               }
             ),
             
             createPropertyDescriptor("preferredScrollableViewportSize", new Object[] {
                 SHORTDESCRIPTION, "preferredScrollableViewportSize",
               }
             ),
             
             createPropertyDescriptor("opaque", new Object[] {
                 SHORTDESCRIPTION, "opaque",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                 SHORTDESCRIPTION, "UI",
               }
             ),
             
             createPropertyDescriptor("rowHeight", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The height of each cell.",
               }
             ),
             
             createPropertyDescriptor("selectionModel", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The tree's selection model.",
               }
             ),
             
             createPropertyDescriptor("leadSelectionRow", new Object[] {
                 SHORTDESCRIPTION, "leadSelectionRow",
               }
             ),
             
             createPropertyDescriptor("largeModel", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Whether the UI should use a large model.",
               }
             ),
             
             createPropertyDescriptor("rootVisible", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Whether or not the root node from the TreeModel is visible.",
               }
             ),
             
             createPropertyDescriptor("leadSelectionPath", new Object[] {
                 SHORTDESCRIPTION, "leadSelectionPath",
               }
             ),
             
             createPropertyDescriptor("scrollableTracksViewportWidth", new Object[] {
                 SHORTDESCRIPTION, "scrollableTracksViewportWidth",
               }
             ),
             
             createPropertyDescriptor("fixedRowHeight", new Object[] {
                 SHORTDESCRIPTION, "fixedRowHeight",
               }
             ),
             
             createPropertyDescriptor("cellEditor", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The cell editor. A null value implies the tree cannot be edited.",
               }
             ),
             
             createPropertyDescriptor("scrollableTracksViewportHeight", new Object[] {
                 SHORTDESCRIPTION, "scrollableTracksViewportHeight",
               }
             ),
             
             createPropertyDescriptor("model", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The TreeModel that will provide the data.",
               }
             ),
             
             createPropertyDescriptor("showsRootHandles", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Whether the node handles are to be displayed.",
               }
             ),
             
             createPropertyDescriptor("selectionRows", new Object[] {
                 SHORTDESCRIPTION, "selectionRows",
               }
             ),
             
             createPropertyDescriptor("rowCount", new Object[] {
                 SHORTDESCRIPTION, "rowCount",
               }
             ),
             
             createPropertyDescriptor("editable", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Whether the tree is editable.",
               }
             ),
             
             createPropertyDescriptor("minSelectionRow", new Object[] {
                 SHORTDESCRIPTION, "minSelectionRow",
               }
             ),
             
             createPropertyDescriptor("selectionPath", new Object[] {
                 SHORTDESCRIPTION, "selectionPath",
               }
             ),
             
             createPropertyDescriptor("lastSelectedPathComponent", new Object[] {
                 SHORTDESCRIPTION, "lastSelectedPathComponent",
               }
             ),
             
             createPropertyDescriptor("cellRenderer", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The TreeCellRenderer that will be used to draw each cell.",
               }
             ),
             
             createPropertyDescriptor("maxSelectionRow", new Object[] {
                 SHORTDESCRIPTION, "maxSelectionRow",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JTree
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JTreeColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JTreeColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JTreeMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JTreeMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


