/*
 * JTextFieldBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JTextField class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JTextField properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JTextFieldBeanInfo extends SwingBeanInfo 
{
    private static final Class classJTextField = com.sun.java.swing.JTextField.class;

    /**
     * @return a JTextField BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJTextField, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.FALSE,
     
			        SHORTDESCRIPTION, "<A description of this component>."
	    }			    
        );            	       		    
    }


    /**
     * Create a JTextField PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JTextField.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JTextField PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJTextField, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JTextField.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JTextField
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
		Object[] horizontalAlignmentEnumeration = new Object[] { 
			"LEFT" ,   new Integer(JTextField.LEFT) , "JTextField.LEFT",
			"CENTER" ,   new Integer(JTextField.CENTER) , "JTextField.CENTER",
			"RIGHT" ,   new Integer(JTextField.RIGHT) , "JTextField.RIGHT"  
		};

	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("horizontalVisibility", new Object[] {
                 SHORTDESCRIPTION, "horizontalVisibility",
               }
             ),
             
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("scrollOffset", new Object[] {
                 SHORTDESCRIPTION, "scrollOffset",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("preferredSize", new Object[] {
                 SHORTDESCRIPTION, "preferredSize",
               }
             ),
             
             createPropertyDescriptor("columns", new Object[] {
                 SHORTDESCRIPTION, "the number of columns preferred for display",
               }
             ),
             
             createPropertyDescriptor("validateRoot", new Object[] {
                 SHORTDESCRIPTION, "validateRoot",
               }
             ),
             
             createPropertyDescriptor("minimumSize", new Object[] {
                 SHORTDESCRIPTION, "minimumSize",
               }
             ),
             
             createPropertyDescriptor("actions", new Object[] {
                 SHORTDESCRIPTION, "actions",
               }
             ),
             
             createPropertyDescriptor("horizontalAlignment", new Object[] {
                            BOUND, Boolean.TRUE,
                      "enumerationValues", horizontalAlignmentEnumeration ,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "Set the field alignment to LEFT (the default), CENTER, RIGHT ",
               }
             ),
             
	};
    }


    /**
     * @return an icon of the specified kind for JTextField
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JTextFieldColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JTextFieldColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JTextFieldMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JTextFieldMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


