/*
 * JTextAreaBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JTextArea class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JTextArea properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JTextAreaBeanInfo extends SwingBeanInfo 
{
    private static final Class classJTextArea = com.sun.java.swing.JTextArea.class;

    /**
     * @return a JTextArea BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJTextArea, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.FALSE,
     
			        SHORTDESCRIPTION, "<A description of this component>."
	    }			    
        );            	       		    
    }


    /**
     * Create a JTextArea PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JTextArea.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JTextArea PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJTextArea, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JTextArea.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JTextArea
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("lineWrap", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "should lines be wrapped",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("preferredSize", new Object[] {
                 SHORTDESCRIPTION, "preferredSize",
               }
             ),
             
             createPropertyDescriptor("preferredScrollableViewportSize", new Object[] {
                 SHORTDESCRIPTION, "preferredScrollableViewportSize",
               }
             ),
             
             createPropertyDescriptor("columns", new Object[] {
                 SHORTDESCRIPTION, "the number of columns preferred for display",
               }
             ),
             
             createPropertyDescriptor("wrapStyleWord", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "should wrapping occur at word boundries",
               }
             ),
             
             createPropertyDescriptor("scrollableTracksViewportWidth", new Object[] {
                 SHORTDESCRIPTION, "scrollableTracksViewportWidth",
               }
             ),
             
             createPropertyDescriptor("minimumSize", new Object[] {
                 SHORTDESCRIPTION, "minimumSize",
               }
             ),
             
             createPropertyDescriptor("lineCount", new Object[] {
                 SHORTDESCRIPTION, "lineCount",
               }
             ),
             
             createPropertyDescriptor("managingFocus", new Object[] {
                 SHORTDESCRIPTION, "managingFocus",
               }
             ),
             
             createPropertyDescriptor("rows", new Object[] {
                 SHORTDESCRIPTION, "the number of rows preferred for display",
               }
             ),
             
             createPropertyDescriptor("tabSize", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "the number of characters to expand tabs to",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JTextArea
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JTextAreaColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JTextAreaColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JTextAreaMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JTextAreaMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


