/*
 * JTableBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JTable class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JTable properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JTableBeanInfo extends SwingBeanInfo 
{
    private static final Class classJTable = com.sun.java.swing.JTable.class;

    /**
     * @return a JTable BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJTable, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.FALSE,
     
			        SHORTDESCRIPTION, "<A description of this component>."
	    }			    
        );            	       		    
    }


    /**
     * Create a JTable PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JTable.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JTable PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJTable, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JTable.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JTable
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
		Object[] autoResizeModeEnumeration = new Object[] { 
			"AUTO_RESIZE_OFF" ,   new Integer(JTable.AUTO_RESIZE_OFF) , "JTable.AUTO_RESIZE_OFF",
			"AUTO_RESIZE_LAST_COLUMN" ,   new Integer(JTable.AUTO_RESIZE_LAST_COLUMN) , "JTable.AUTO_RESIZE_LAST_COLUMN",
			"AUTO_RESIZE_ALL_COLUMNS" ,   new Integer(JTable.AUTO_RESIZE_ALL_COLUMNS) , "JTable.AUTO_RESIZE_ALL_COLUMNS"  
		};

	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("editing", new Object[] {
                 SHORTDESCRIPTION, "editing",
               }
             ),
             
             createPropertyDescriptor("editingRow", new Object[] {
                 SHORTDESCRIPTION, "editingRow",
               }
             ),
             
             createPropertyDescriptor("selectionBackground", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "A default background color for selected cells.",
               }
             ),
             
             createPropertyDescriptor("selectedColumnCount", new Object[] {
                 SHORTDESCRIPTION, "selectedColumnCount",
               }
             ),
             
             createPropertyDescriptor("selectedRowCount", new Object[] {
                 SHORTDESCRIPTION, "selectedRowCount",
               }
             ),
             
             createPropertyDescriptor("gridColor", new Object[] {
                 SHORTDESCRIPTION, "gridColor",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("showVerticalLines", new Object[] {
                 SHORTDESCRIPTION, "Whether vertical lines should be drawn in between the cells.",
               }
             ),
             
             createPropertyDescriptor("opaque", new Object[] {
                 SHORTDESCRIPTION, "opaque",
               }
             ),
             
             createPropertyDescriptor("preferredScrollableViewportSize", new Object[] {
                 SHORTDESCRIPTION, "The preferred size of the viewport.",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                 SHORTDESCRIPTION, "UI",
               }
             ),
             
             createPropertyDescriptor("autoCreateColumnsFromModel", new Object[] {
                 SHORTDESCRIPTION, "Automatically populate the columnModel when a new TableModel is submitted.",
               }
             ),
             
             createPropertyDescriptor("rowHeight", new Object[] {
                 SHORTDESCRIPTION, "The height of the cells including the inter-cell spacing.",
               }
             ),
             
             createPropertyDescriptor("selectionModel", new Object[] {
                 SHORTDESCRIPTION, "The selection model for rows.",
               }
             ),
             
             createPropertyDescriptor("selectedRow", new Object[] {
                 SHORTDESCRIPTION, "selectedRow",
               }
             ),
             
             createPropertyDescriptor("selectedColumn", new Object[] {
                 SHORTDESCRIPTION, "selectedColumn",
               }
             ),
             
             createPropertyDescriptor("editorComponent", new Object[] {
                 SHORTDESCRIPTION, "editorComponent",
               }
             ),
             
             createPropertyDescriptor("tableHeader", new Object[] {
                 SHORTDESCRIPTION, "The JTableHeader instance which renders the column headers.",
               }
             ),
             
             createPropertyDescriptor("cellEditor", new Object[] {
                 SHORTDESCRIPTION, "cellEditor",
               }
             ),
             
             createPropertyDescriptor("scrollableTracksViewportWidth", new Object[] {
                 SHORTDESCRIPTION, "scrollableTracksViewportWidth",
               }
             ),
             
             createPropertyDescriptor("selectedColumns", new Object[] {
                 SHORTDESCRIPTION, "selectedColumns",
               }
             ),
             
             createPropertyDescriptor("rowSelectionAllowed", new Object[] {
                 SHORTDESCRIPTION, "If true, an entire row is selected for each selected cell.",
               }
             ),
             
             createPropertyDescriptor("scrollableTracksViewportHeight", new Object[] {
                 SHORTDESCRIPTION, "scrollableTracksViewportHeight",
               }
             ),
             
             createPropertyDescriptor("intercellSpacing", new Object[] {
                 SHORTDESCRIPTION, "The spacing between the cells, drawn in the background color of the JTable.",
               }
             ),
             
             createPropertyDescriptor("model", new Object[] {
                 SHORTDESCRIPTION, "The model that is the source of the data for this view.",
               }
             ),
             
             createPropertyDescriptor("columnSelectionAllowed", new Object[] {
                 SHORTDESCRIPTION, "If true, an entire column is selected for each selected cell.",
               }
             ),
             
             createPropertyDescriptor("autoResizeMode", new Object[] {
                      "enumerationValues", autoResizeModeEnumeration ,
                 SHORTDESCRIPTION, "Whether the columns should adjust themselves automatically to accomodate changes. ",
               }
             ),
             
             createPropertyDescriptor("selectionForeground", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "A default foreground color for selected cells.",
               }
             ),
             
             createPropertyDescriptor("cellSelectionEnabled", new Object[] {
                 SHORTDESCRIPTION, "Select a rectangular region of cells rather than rows or columns.",
               }
             ),
             
             createPropertyDescriptor("rowCount", new Object[] {
                 SHORTDESCRIPTION, "rowCount",
               }
             ),
             
             createPropertyDescriptor("selectedRows", new Object[] {
                 SHORTDESCRIPTION, "selectedRows",
               }
             ),
             
             createPropertyDescriptor("columnModel", new Object[] {
                 SHORTDESCRIPTION, "The object governing the way columns appear in the view.",
               }
             ),
             
             createPropertyDescriptor("editingColumn", new Object[] {
                 SHORTDESCRIPTION, "editingColumn",
               }
             ),
             
             createPropertyDescriptor("showHorizontalLines", new Object[] {
                 SHORTDESCRIPTION, "Whether horizontal lines should be drawn in between the cells.",
               }
             ),
             
             createPropertyDescriptor("columnCount", new Object[] {
                 SHORTDESCRIPTION, "columnCount",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JTable
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JTableColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JTableColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JTableMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JTableMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


