/*
 * JTabbedPaneBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JTabbedPane class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JTabbedPane properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JTabbedPaneBeanInfo extends SwingBeanInfo 
{
    private static final Class classJTabbedPane = com.sun.java.swing.JTabbedPane.class;

    /**
     * @return a JTabbedPane BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJTabbedPane, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.TRUE,
     
			        SHORTDESCRIPTION, "A component which provides a tab folder metaphor for displaying one component from a set of components."
	    }			    
        );            	       		    
    }


    /**
     * Create a JTabbedPane PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JTabbedPane.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JTabbedPane PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJTabbedPane, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JTabbedPane.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JTabbedPane
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
		Object[] tabPlacementEnumeration = new Object[] { 
			"TOP" ,   new Integer(JTabbedPane.TOP) , "JTabbedPane.TOP",
			"LEFT" ,   new Integer(JTabbedPane.LEFT) , "JTabbedPane.LEFT",
			"BOTTOM" ,   new Integer(JTabbedPane.BOTTOM) , "JTabbedPane.BOTTOM",
			"RIGHT" ,   new Integer(JTabbedPane.RIGHT) , "JTabbedPane.RIGHT"  
		};

	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                            BOUND, Boolean.TRUE,
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "The UI object that implements the tabbedpane's LookAndFeel",
               }
             ),
             
             createPropertyDescriptor("tabCount", new Object[] {
                 SHORTDESCRIPTION, "tabCount",
               }
             ),
             
             createPropertyDescriptor("tabRunCount", new Object[] {
                 SHORTDESCRIPTION, "tabRunCount",
               }
             ),
             
             createPropertyDescriptor("model", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The tabbedpane's SingleSelectionModel.",
               }
             ),
             
             createPropertyDescriptor("tabPlacement", new Object[] {
                            BOUND, Boolean.TRUE,
                      "enumerationValues", tabPlacementEnumeration ,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The tabbedpane's tab placement. ",
               }
             ),
             
             createPropertyDescriptor("selectedIndex", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The tabbedpane's selected tab index.",
               }
             ),
             
             createPropertyDescriptor("selectedComponent", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The tabbedpane's selected component.",
               }
             ),
             
	};
    }


    /**
     * @return an icon of the specified kind for JTabbedPane
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JTabbedPaneColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JTabbedPaneColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JTabbedPaneMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JTabbedPaneMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


