/*
 * JSplitPaneBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JSplitPane class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JSplitPane properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JSplitPaneBeanInfo extends SwingBeanInfo 
{
    private static final Class classJSplitPane = com.sun.java.swing.JSplitPane.class;

    /**
     * @return a JSplitPane BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJSplitPane, new Object[] {
				PREFERRED, Boolean.TRUE,
				
			        SHORTDESCRIPTION, "JSplitPane"
	    }			    
        );            	       		    
    }


    /**
     * Create a JSplitPane PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JSplitPane.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JSplitPane PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJSplitPane, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JSplitPane.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JSplitPane
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("rightComponent", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The component to the right (or below) the divider.",
               }
             ),
             
             createPropertyDescriptor("UIClassID", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "A string that specifies the name of the L&F class.",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "The AccessibleContext associated with this Label.",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "The L&F object that renders this component.",
               }
             ),
             
             createPropertyDescriptor("leftComponent", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The component to the left (or above) the divider.",
               }
             ),
             
             createPropertyDescriptor("maximumDividerLocation", new Object[] {
                 SHORTDESCRIPTION, "maximumDividerLocation",
               }
             ),
             
             createPropertyDescriptor("orientation", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The orientation, or how the splitter is divided.",
               }
             ),
             
             createPropertyDescriptor("bottomComponent", new Object[] {
                 SHORTDESCRIPTION, "The component below, or to the right of the divider.",
               }
             ),
             
             createPropertyDescriptor("dividerLocation", new Object[] {
                 SHORTDESCRIPTION, "The location of the divider.",
               }
             ),
             
             createPropertyDescriptor("continuousLayout", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Whether or not the child components are continuously redisplayed and layed out during user intervention.",
               }
             ),
             
             createPropertyDescriptor("oneTouchExpandable", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "UI widget on the divider to quickly expand/collapse the divider.",
               }
             ),
             
             createPropertyDescriptor("dividerSize", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The size of the divider.",
               }
             ),
             
             createPropertyDescriptor("lastDividerLocation", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The last location the divider was at.",
               }
             ),
             
             createPropertyDescriptor("minimumDividerLocation", new Object[] {
                 SHORTDESCRIPTION, "The minimum location of the divider from the L&F.",
               }
             ),
             
             createPropertyDescriptor("topComponent", new Object[] {
                 SHORTDESCRIPTION, "The component above, or to the left of the divider.",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JSplitPane
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JSplitPaneColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JSplitPaneColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JSplitPaneMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JSplitPaneMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


