/*
 * JSliderBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JSlider class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JSlider properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JSliderBeanInfo extends SwingBeanInfo 
{
    private static final Class classJSlider = com.sun.java.swing.JSlider.class;

    /**
     * @return a JSlider BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJSlider, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.FALSE,
     
			        SHORTDESCRIPTION, "A component that supports selecting a integer value from a range."
	    }			    
        );            	       		    
    }


    /**
     * Create a JSlider PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JSlider.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JSlider PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJSlider, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JSlider.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JSlider
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
		Object[] orientationEnumeration = new Object[] { 
			"VERTICAL" ,   new Integer(JSlider.VERTICAL) , "JSlider.VERTICAL",
			"HORIZONTAL" ,   new Integer(JSlider.HORIZONTAL) , "JSlider.HORIZONTAL"  
		};

	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                            BOUND, Boolean.TRUE,
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "The UI object that implements the slider's LookAndFeel.",
               }
             ),
             
             createPropertyDescriptor("value", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The sliders current value.",
               }
             ),
             
             createPropertyDescriptor("valueIsAdjusting", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "True if the slider knob is being dragged.",
               }
             ),
             
             createPropertyDescriptor("orientation", new Object[] {
                            BOUND, Boolean.TRUE,
                      "enumerationValues", orientationEnumeration ,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "Set the scrollbars orientation to either VERTICAL or HORIZONTAL. ",
               }
             ),
             
             createPropertyDescriptor("inverted", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "If true reverses the slider values from their normal order",
               }
             ),
             
             createPropertyDescriptor("extent", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "Size of the range covered by the knob.",
               }
             ),
             
             createPropertyDescriptor("maximum", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The sliders maximum value.",
               }
             ),
             
             createPropertyDescriptor("snapToTicks", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "If true snap the knob to the nearest tick mark.",
               }
             ),
             
             createPropertyDescriptor("minimum", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The sliders minimum value.",
               }
             ),
             
             createPropertyDescriptor("majorTickSpacing", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Sets the number of pixels between major tick marks.",
               }
             ),
             
             createPropertyDescriptor("model", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The sliders BoundedRangeModel.",
               }
             ),
             
             createPropertyDescriptor("labelTable", new Object[] {
                            BOUND, Boolean.TRUE,
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "Specifies what labels will be drawn for any given value.",
               }
             ),
             
             createPropertyDescriptor("paintTicks", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "If true tick marks are painted on the slider.",
               }
             ),
             
             createPropertyDescriptor("minorTickSpacing", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Sets the number of pixels between minor tick marks.",
               }
             ),
             
             createPropertyDescriptor("paintLabels", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "If true labels are painted on the slider.",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JSlider
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JSliderColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JSliderColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JSliderMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JSliderMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


