/*
 * JScrollPaneBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JScrollPane class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JScrollPane properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JScrollPaneBeanInfo extends SwingBeanInfo 
{
    private static final Class classJScrollPane = com.sun.java.swing.JScrollPane.class;

    /**
     * @return a JScrollPane BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJScrollPane, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.TRUE,
     
			        SHORTDESCRIPTION, "A specialized container that manages a viewport, optional scrollbars and headings"
	    }			    
        );            	       		    
    }


    /**
     * Create a JScrollPane PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JScrollPane.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JScrollPane PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJScrollPane, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JScrollPane.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JScrollPane
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("opaque", new Object[] {
                 SHORTDESCRIPTION, "opaque",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                 SHORTDESCRIPTION, "UI",
               }
             ),
             
             createPropertyDescriptor("horizontalScrollBar", new Object[] {
                 SHORTDESCRIPTION, "horizontalScrollBar",
               }
             ),
             
             createPropertyDescriptor("verticalScrollBar", new Object[] {
                 SHORTDESCRIPTION, "verticalScrollBar",
               }
             ),
             
             createPropertyDescriptor("rowHeader", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The header viewport.",
               }
             ),
             
             createPropertyDescriptor("verticalScrollBarPolicy", new Object[] {
                 SHORTDESCRIPTION, "verticalScrollBarPolicy",
               }
             ),
             
             createPropertyDescriptor("validateRoot", new Object[] {
                 SHORTDESCRIPTION, "validateRoot",
               }
             ),
             
             createPropertyDescriptor("horizontalScrollBarPolicy", new Object[] {
                 SHORTDESCRIPTION, "horizontalScrollBarPolicy",
               }
             ),
             
             createPropertyDescriptor("viewportBorder", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The border around the viewport.",
               }
             ),
             
             createPropertyDescriptor("columnHeader", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The column viewport.",
               }
             ),
             
             createPropertyDescriptor("viewport", new Object[] {
                 SHORTDESCRIPTION, "viewport",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JScrollPane
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JScrollPaneColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JScrollPaneColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JScrollPaneMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JScrollPaneMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


