/*
 * JScrollBarBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JScrollBar class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JScrollBar properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JScrollBarBeanInfo extends SwingBeanInfo 
{
    private static final Class classJScrollBar = com.sun.java.swing.JScrollBar.class;

    /**
     * @return a JScrollBar BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJScrollBar, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.FALSE,
     
			        SHORTDESCRIPTION, "A component that helps determine the visible content range of an area."
	    }			    
        );            	       		    
    }


    /**
     * Create a JScrollBar PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JScrollBar.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JScrollBar PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJScrollBar, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JScrollBar.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JScrollBar
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
		Object[] orientationEnumeration = new Object[] { 
			"VERTICAL" ,   new Integer(JScrollBar.VERTICAL) , "JScrollBar.VERTICAL",
			"HORIZONTAL" ,   new Integer(JScrollBar.HORIZONTAL) , "JScrollBar.HORIZONTAL"  
		};

	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("visibleAmount", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The amount of the view that is currently visible.",
               }
             ),
             
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("maximumSize", new Object[] {
                 SHORTDESCRIPTION, "maximumSize",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                 SHORTDESCRIPTION, "UI",
               }
             ),
             
             createPropertyDescriptor("value", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The scrollbar's current value.",
               }
             ),
             
             createPropertyDescriptor("valueIsAdjusting", new Object[] {
                            BOUND, Boolean.TRUE,
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "True if the scrollbar thumb is being dragged.",
               }
             ),
             
             createPropertyDescriptor("unitIncrement", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The scrollbar's unit increment.",
               }
             ),
             
             createPropertyDescriptor("orientation", new Object[] {
                            BOUND, Boolean.TRUE,
                      "enumerationValues", orientationEnumeration ,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The scrollbar's orientation. ",
               }
             ),
             
             createPropertyDescriptor("maximum", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The scrollbar's maximum value.",
               }
             ),
             
             createPropertyDescriptor("minimum", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The scrollbar's minimum value.",
               }
             ),
             
             createPropertyDescriptor("minimumSize", new Object[] {
                 SHORTDESCRIPTION, "minimumSize",
               }
             ),
             
             createPropertyDescriptor("model", new Object[] {
                            BOUND, Boolean.TRUE,
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "The scrollbar's BoundedRangeModel.",
               }
             ),
             
             createPropertyDescriptor("blockIncrement", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The scrollbar's block increment.",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JScrollBar
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JScrollBarColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JScrollBarColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JScrollBarMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JScrollBarMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


