/*
 * JOptionPaneBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JOptionPane class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JOptionPane properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JOptionPaneBeanInfo extends SwingBeanInfo 
{
    private static final Class classJOptionPane = com.sun.java.swing.JOptionPane.class;

    /**
     * @return a JOptionPane BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJOptionPane, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.TRUE,
     
			        SHORTDESCRIPTION, "A component which implements standard dialog box controls."
	    }			    
        );            	       		    
    }


    /**
     * Create a JOptionPane PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JOptionPane.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JOptionPane PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJOptionPane, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JOptionPane.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JOptionPane
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("icon", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The option pane's type icon.",
               }
             ),
             
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("selectionValues", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The option pane's selection values.",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                            BOUND, Boolean.TRUE,
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "The UI object that implements the optionpane's LookAndFeel",
               }
             ),
             
             createPropertyDescriptor("wantsInput", new Object[] {
                 SHORTDESCRIPTION, "wantsInput",
               }
             ),
             
             createPropertyDescriptor("value", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The option pane's value object.",
               }
             ),
             
             createPropertyDescriptor("inputValue", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The option pane's input value object.",
               }
             ),
             
             createPropertyDescriptor("messageType", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The option pane's message type.",
               }
             ),
             
             createPropertyDescriptor("maxCharactersPerLineCount", new Object[] {
                 SHORTDESCRIPTION, "maxCharactersPerLineCount",
               }
             ),
             
             createPropertyDescriptor("message", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The optionpane's message object.",
               }
             ),
             
             createPropertyDescriptor("options", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The option pane's options objects.",
               }
             ),
             
             createPropertyDescriptor("initialValue", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The option pane's initial value object.",
               }
             ),
             
             createPropertyDescriptor("optionType", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The option pane's option type.",
               }
             ),
             
             createPropertyDescriptor("initialSelectionValue", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The option pane's initial selection value object.",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JOptionPane
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JOptionPaneColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JOptionPaneColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JOptionPaneMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JOptionPaneMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


