/*
 * JListBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JList class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JList properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JListBeanInfo extends SwingBeanInfo 
{
    private static final Class classJList = com.sun.java.swing.JList.class;

    /**
     * @return a JList BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJList, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.FALSE,
     
			        SHORTDESCRIPTION, "<A description of this component>."
	    }			    
        );            	       		    
    }


    /**
     * Create a JList PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JList.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JList PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJList, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JList.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JList
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
		Object[] selectionModeEnumeration = new Object[] { 
			"SINGLE_SELECTION" ,   new Integer(ListSelectionModel.SINGLE_SELECTION) , "ListSelectionModel.SINGLE_SELECTION",
			"SINGLE_INTERVAL_SELECTION" ,   new Integer(ListSelectionModel.SINGLE_INTERVAL_SELECTION) , "ListSelectionModel.SINGLE_INTERVAL_SELECTION",
			"MULTIPLE_INTERVAL_SELECTION" ,   new Integer(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION) , "ListSelectionModel.MULTIPLE_INTERVAL_SELECTION"  
		};

	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("visibleRowCount", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The preferred number of cells that can be displayed without a scrollbar.",
               }
             ),
             
             createPropertyDescriptor("fixedCellHeight", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Defines a fixed cell height when greater than zero.",
               }
             ),
             
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("selectionEmpty", new Object[] {
                 SHORTDESCRIPTION, "selectionEmpty",
               }
             ),
             
             createPropertyDescriptor("selectionBackground", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The background color of selected cells.",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("preferredScrollableViewportSize", new Object[] {
                 SHORTDESCRIPTION, "preferredScrollableViewportSize",
               }
             ),
             
             createPropertyDescriptor("opaque", new Object[] {
                 SHORTDESCRIPTION, "opaque",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                 SHORTDESCRIPTION, "UI",
               }
             ),
             
             createPropertyDescriptor("firstVisibleIndex", new Object[] {
                 SHORTDESCRIPTION, "firstVisibleIndex",
               }
             ),
             
             createPropertyDescriptor("selectionModel", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The selection model, recording which cells are selected.",
               }
             ),
             
             createPropertyDescriptor("valueIsAdjusting", new Object[] {
                 SHORTDESCRIPTION, "valueIsAdjusting",
               }
             ),
             
             createPropertyDescriptor("prototypeCellValue", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The cell prototype value, used to compute cell width and height.",
               }
             ),
             
             createPropertyDescriptor("minSelectionIndex", new Object[] {
                 SHORTDESCRIPTION, "minSelectionIndex",
               }
             ),
             
             createPropertyDescriptor("anchorSelectionIndex", new Object[] {
                 SHORTDESCRIPTION, "anchorSelectionIndex",
               }
             ),
             
             createPropertyDescriptor("maxSelectionIndex", new Object[] {
                 SHORTDESCRIPTION, "maxSelectionIndex",
               }
             ),
             
             createPropertyDescriptor("selectedValue", new Object[] {
                 SHORTDESCRIPTION, "selectedValue",
               }
             ),
             
             createPropertyDescriptor("scrollableTracksViewportWidth", new Object[] {
                 SHORTDESCRIPTION, "scrollableTracksViewportWidth",
               }
             ),
             
             createPropertyDescriptor("selectionMode", new Object[] {
                      "enumerationValues", selectionModeEnumeration ,
                 SHORTDESCRIPTION, "The selection mode. ",
               }
             ),
             
             createPropertyDescriptor("scrollableTracksViewportHeight", new Object[] {
                 SHORTDESCRIPTION, "scrollableTracksViewportHeight",
               }
             ),
             
             createPropertyDescriptor("selectedValues", new Object[] {
                 SHORTDESCRIPTION, "selectedValues",
               }
             ),
             
             createPropertyDescriptor("leadSelectionIndex", new Object[] {
                 SHORTDESCRIPTION, "The lead selection index.",
               }
             ),
             
             createPropertyDescriptor("model", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The object that contains the data to be drawn by this JList.",
               }
             ),
             
             createPropertyDescriptor("fixedCellWidth", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Defines a fixed cell width when greater than zero.",
               }
             ),
             
             createPropertyDescriptor("selectedIndices", new Object[] {
                 SHORTDESCRIPTION, "selectedIndices",
               }
             ),
             
             createPropertyDescriptor("lastVisibleIndex", new Object[] {
                 SHORTDESCRIPTION, "lastVisibleIndex",
               }
             ),
             
             createPropertyDescriptor("selectionForeground", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The foreground color of selected cells.",
               }
             ),
             
             createPropertyDescriptor("selectedIndex", new Object[] {
                 SHORTDESCRIPTION, "The index of the selected cell.",
               }
             ),
             
             createPropertyDescriptor("cellRenderer", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The component used to draw the cells.",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JList
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JListColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JListColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JListMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JListMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


