/*
 * JInternalFrameBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JInternalFrame class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JInternalFrame properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JInternalFrameBeanInfo extends SwingBeanInfo 
{
    private static final Class classJInternalFrame = com.sun.java.swing.JInternalFrame.class;

    /**
     * @return a JInternalFrame BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJInternalFrame, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.TRUE,
                   "containerDelegate","getContentPane",
     
			        SHORTDESCRIPTION, "A frame container which is contained within another window."
	    }			    
        );            	       		    
    }


    /**
     * Create a JInternalFrame PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JInternalFrame.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JInternalFrame PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJInternalFrame, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JInternalFrame.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JInternalFrame
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("layer", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "Specifies what desktop layer is used.",
               }
             ),
             
             createPropertyDescriptor("closed", new Object[] {
                      CONSTRAINED, Boolean.TRUE,
                 SHORTDESCRIPTION, "Indicates that the frame has been closed.",
               }
             ),
             
             createPropertyDescriptor("menuBar", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The menubar for accessing pulldown menus from this frame.",
               }
             ),
             
             createPropertyDescriptor("icon", new Object[] {
                      CONSTRAINED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The image displayed when this frame is minimized.",
               }
             ),
             
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("closable", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "Indicates whether this frame can be closed.",
               }
             ),
             
             createPropertyDescriptor("resizable", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "Determines whether the frame can be resized by the user.",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "The InternalFrameUI implementation that defines the labels look and feel.",
               }
             ),
             
             createPropertyDescriptor("selected", new Object[] {
                      CONSTRAINED, Boolean.TRUE,
                 SHORTDESCRIPTION, "Indicates whether this frame is currently the active frame.",
               }
             ),
             
             createPropertyDescriptor("background", new Object[] {
                 SHORTDESCRIPTION, "background",
               }
             ),
             
             createPropertyDescriptor("maximum", new Object[] {
                      CONSTRAINED, Boolean.TRUE,
                 SHORTDESCRIPTION, "Indicates whether the frame is maximized.",
               }
             ),
             
             createPropertyDescriptor("rootPane", new Object[] {
                 SHORTDESCRIPTION, "rootPane",
               }
             ),
             
             createPropertyDescriptor("layeredPane", new Object[] {
                            BOUND, Boolean.TRUE,
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "The pane which holds the various desktop layers.",
               }
             ),
             
             createPropertyDescriptor("frameIcon", new Object[] {
                 SHORTDESCRIPTION, "The icon shown in the top-left corner of the frame.",
               }
             ),
             
             createPropertyDescriptor("desktopPane", new Object[] {
                 SHORTDESCRIPTION, "desktopPane",
               }
             ),
             
             createPropertyDescriptor("foreground", new Object[] {
                 SHORTDESCRIPTION, "foreground",
               }
             ),
             
             createPropertyDescriptor("glassPane", new Object[] {
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "A transparent pane used for menu rendering.",
               }
             ),
             
             createPropertyDescriptor("defaultCloseOperation", new Object[] {
                 SHORTDESCRIPTION, "defaultCloseOperation",
               }
             ),
             
             createPropertyDescriptor("warningString", new Object[] {
                 SHORTDESCRIPTION, "warningString",
               }
             ),
             
             createPropertyDescriptor("title", new Object[] {
                 SHORTDESCRIPTION, "title",
               }
             ),
             
             createPropertyDescriptor("desktopIcon", new Object[] {
                 SHORTDESCRIPTION, "The icon shown when this frame is minimized.",
               }
             ),
             
             createPropertyDescriptor("maximizable", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "Determines whether this frame can be maximized.",
               }
             ),
             
             createPropertyDescriptor("iconifiable", new Object[] {
                 SHORTDESCRIPTION, "iconifiable",
               }
             ),
             
             createPropertyDescriptor("contentPane", new Object[] {
                            BOUND, Boolean.TRUE,
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "The client area of the frame where child components are normally inserted.",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JInternalFrame
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JInternalFrameColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JInternalFrameColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JInternalFrameMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JInternalFrameMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


