/*
 * JFrameBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JFrame class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JFrame properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JFrameBeanInfo extends SwingBeanInfo 
{
    private static final Class classJFrame = com.sun.java.swing.JFrame.class;

    /**
     * @return a JFrame BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJFrame, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.TRUE,
                   "containerDelegate","getContentPane",
     
			        SHORTDESCRIPTION, "A toplevel window which can be minimized to an icon."
	    }			    
        );            	       		    
    }


    /**
     * Create a JFrame PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JFrame.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JFrame PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJFrame, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JFrame.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JFrame
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
		Object[] defaultCloseOperationEnumeration = new Object[] { 
			"DO_NOTHING_ON_CLOSE" ,   new Integer(WindowConstants.DO_NOTHING_ON_CLOSE) , "WindowConstants.DO_NOTHING_ON_CLOSE",
			"HIDE_ON_CLOSE" ,   new Integer(WindowConstants.HIDE_ON_CLOSE) , "WindowConstants.HIDE_ON_CLOSE",
			"DISPOSE_ON_CLOSE" ,   new Integer(WindowConstants.DISPOSE_ON_CLOSE) , "WindowConstants.DISPOSE_ON_CLOSE"  
		};

	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("layeredPane", new Object[] {
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "The pane which holds the various frame layers.",
               }
             ),
             
             createPropertyDescriptor("rootPane", new Object[] {
                 SHORTDESCRIPTION, "rootPane",
               }
             ),
             
             createPropertyDescriptor("JMenuBar", new Object[] {
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "The menubar for accessing pulldown menus from this frame.",
               }
             ),
             
             createPropertyDescriptor("glassPane", new Object[] {
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "A transparent pane used for menu rendering.",
               }
             ),
             
             createPropertyDescriptor("defaultCloseOperation", new Object[] {
                      "enumerationValues", defaultCloseOperationEnumeration ,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The frame's default close operation.",
               }
             ),
             
             createPropertyDescriptor("contentPane", new Object[] {
                           HIDDEN, Boolean.TRUE,
                 SHORTDESCRIPTION, "The client area of the frame where child components are normally inserted.",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JFrame
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JFrameColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JFrameColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JFrameMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JFrameMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


