/*
 * JComponentBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JComponent class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JComponent properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JComponentBeanInfo extends SwingBeanInfo 
{
    private static final Class classJComponent = com.sun.java.swing.JComponent.class;

    /**
     * @return a JComponent BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJComponent, new Object[] {
				PREFERRED, Boolean.TRUE,
				
			        SHORTDESCRIPTION, "JComponent"
	    }			    
        );            	       		    
    }


    /**
     * Create a JComponent PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JComponent.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JComponent PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJComponent, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JComponent.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JComponent
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("focusCycleRoot", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "focusCycleRoot",
               }
             ),
             
             createPropertyDescriptor("UIClassID", new Object[] {
                            BOUND, Boolean.TRUE,
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("toolTipText", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The text to display in a tool tip.",
               }
             ),
             
             createPropertyDescriptor("doubleBuffered", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "doubleBuffered",
               }
             ),
             
             createPropertyDescriptor("width", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "width",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("preferredSize", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The preferred size of the component.",
               }
             ),
             
             createPropertyDescriptor("opaque", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "opaque",
               }
             ),
             
             createPropertyDescriptor("maximumSize", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The maximum size of the component.",
               }
             ),
             
             createPropertyDescriptor("autoscrolls", new Object[] {
                            BOUND, Boolean.TRUE,
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "Whether this component automatically scrolls its contents when dragged.",
               }
             ),
             
             createPropertyDescriptor("alignmentY", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The preferred vertical alignment of the component",
               }
             ),
             
             createPropertyDescriptor("alignmentX", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The preferred horizontal alignment of the component",
               }
             ),
             
             createPropertyDescriptor("border", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The component's border.",
               }
             ),
             
             createPropertyDescriptor("rootPane", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "rootPane",
               }
             ),
             
             createPropertyDescriptor("graphics", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "graphics",
               }
             ),
             
             createPropertyDescriptor("insets", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "insets",
               }
             ),
             
             createPropertyDescriptor("debugGraphicsOptions", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "Diagnostic options for graphics operations.",
               }
             ),
             
             createPropertyDescriptor("optimizedDrawingEnabled", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "optimizedDrawingEnabled",
               }
             ),
             
             createPropertyDescriptor("nextFocusableComponent", new Object[] {
                            BOUND, Boolean.TRUE,
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "The next component to get focus after this one.",
               }
             ),
             
             createPropertyDescriptor("validateRoot", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "validateRoot",
               }
             ),
             
             createPropertyDescriptor("focusTraversable", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "focusTraversable",
               }
             ),
             
             createPropertyDescriptor("height", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "height",
               }
             ),
             
             createPropertyDescriptor("minimumSize", new Object[] {
                            BOUND, Boolean.TRUE,
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The minimum size of the component.",
               }
             ),
             
             createPropertyDescriptor("managingFocus", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "managingFocus",
               }
             ),
             
             createPropertyDescriptor("registeredKeyStrokes", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "registeredKeyStrokes",
               }
             ),
             
             createPropertyDescriptor("visibleRect", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "visibleRect",
               }
             ),
             
             createPropertyDescriptor("y", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "y",
               }
             ),
             
             createPropertyDescriptor("x", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "x",
               }
             ),
             
             createPropertyDescriptor("requestFocusEnabled", new Object[] {
                            BOUND, Boolean.TRUE,
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "Whether the component can obtain the focus by calling requestFocus.",
               }
             ),
             
             createPropertyDescriptor("topLevelAncestor", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "topLevelAncestor",
               }
             ),
             
             createPropertyDescriptor("paintingTile", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "paintingTile",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JComponent
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JComponentColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JComponentColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JComponentMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JComponentMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


