/*
 * JComboBoxBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the JComboBox class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * JComboBox properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class JComboBoxBeanInfo extends SwingBeanInfo 
{
    private static final Class classJComboBox = com.sun.java.swing.JComboBox.class;

    /**
     * @return a JComboBox BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classJComboBox, new Object[] {
				PREFERRED, Boolean.TRUE,
				              "isContainer",Boolean.FALSE,
     
			        SHORTDESCRIPTION, "<A description of this component>."
	    }			    
        );            	       		    
    }


    /**
     * Create a JComboBox PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the JComboBox.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a JComboBox PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classJComboBox, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in JComboBox.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for JComboBox
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("itemCount", new Object[] {
                 SHORTDESCRIPTION, "itemCount",
               }
             ),
             
             createPropertyDescriptor("UIClassID", new Object[] {
                 SHORTDESCRIPTION, "UIClassID",
               }
             ),
             
             createPropertyDescriptor("accessibleContext", new Object[] {
                 SHORTDESCRIPTION, "accessibleContext",
               }
             ),
             
             createPropertyDescriptor("opaque", new Object[] {
                 SHORTDESCRIPTION, "opaque",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "The ComboBoxUI implementation that defines the combo box look and feel.",
               }
             ),
             
             createPropertyDescriptor("keySelectionManager", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "The objects that changes the selection when a key is pressed.",
               }
             ),
             
             createPropertyDescriptor("editor", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "The editor that combo box uses to edit the current value",
               }
             ),
             
             createPropertyDescriptor("maximumRowCount", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The maximum number of rows the popup should have",
               }
             ),
             
             createPropertyDescriptor("selectedObjects", new Object[] {
                 SHORTDESCRIPTION, "selectedObjects",
               }
             ),
             
             createPropertyDescriptor("selectedItem", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "Sets the selected item in the JComboBox.",
               }
             ),
             
             createPropertyDescriptor("focusTraversable", new Object[] {
                 SHORTDESCRIPTION, "focusTraversable",
               }
             ),
             
             createPropertyDescriptor("renderer", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "The renderer that paints the item selected in the list.",
               }
             ),
             
             createPropertyDescriptor("model", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Model that the combo box uses to get data to display.",
               }
             ),
             
             createPropertyDescriptor("actionCommand", new Object[] {
                 SHORTDESCRIPTION, "actionCommand",
               }
             ),
             
             createPropertyDescriptor("editable", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "If true, the user can type a new value in the combo box.",
               }
             ),
             
             createPropertyDescriptor("selectedIndex", new Object[] {
                        PREFERRED, Boolean.TRUE,
                 SHORTDESCRIPTION, "The item at index is selected.",
               }
             ),
             
             createPropertyDescriptor("lightWeightPopupEnabled", new Object[] {
                           EXPERT, Boolean.TRUE,
                 SHORTDESCRIPTION, "When set, disables using light weight popups.",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for JComboBox
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/JComboBoxColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/JComboBoxColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/JComboBoxMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/JComboBoxMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


