/*
 * AbstractButtonBeanInfoSwingBeanInfo.template	1.4 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import com.sun.java.swing.beaninfo.SwingBeanInfo;

import java.beans.BeanDescriptor;
import java.beans.PropertyDescriptor;
import java.awt.Image;


/**
 * Descriptive information about the AbstractButton class for Java 
 * Beans application builders.  This BeanInfo class provides descriptions
 * of each property, of the bean itself, it indicates which
 * AbstractButton properties are bound, and it provides other
 * information and icons useful to builders.
 * 
 * @version 1.4 04/13/98
 * @author <your name here>
 */

public class AbstractButtonBeanInfo extends SwingBeanInfo 
{
    private static final Class classAbstractButton = com.sun.java.swing.AbstractButton.class;

    /**
     * @return a AbstractButton BeanDescriptor
     */
    public BeanDescriptor getBeanDescriptor() {
	return createBeanDescriptor(classAbstractButton, new Object[] {
				PREFERRED, Boolean.TRUE,
				
			        SHORTDESCRIPTION, "AbstractButton"
	    }			    
        );            	       		    
    }


    /**
     * Create a AbstractButton PropertyDescriptor.  This is just an internal
     * convenience method that allows one to leave the AbstractButton.class
     * argument out of the createPropertyDescriptor() class in the 
     * getPropertyDescriptors() method below.
     * 
     * @param name the name of the property
     * @param args an array java.beans.PropertyDescriptor property names and values
     * @return a AbstractButton PropertyDescriptor.
     * @see SwingBeanInfo#createPropertyDescriptor
     */
    private PropertyDescriptor createPropertyDescriptor(String name, Object[] args) {
	return super.createPropertyDescriptor(classAbstractButton, name, args);
    }


    /**
     * This method returns a list of bean PropertyDescriptors, one for each public
     * property in AbstractButton.  The first property is the "default" property.
     *
     * @return a complete list of bean PropertyDescriptors for AbstractButton
     * @see SwingBeanInfo
     * @see java.beans.BeanInfo#getDefaultPropertyIndex
     */
    public PropertyDescriptor[] getPropertyDescriptors() 
    {
         
	return new PropertyDescriptor[] {
            
             createPropertyDescriptor("icon", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The button's default icon",
               }
             ),
             
             createPropertyDescriptor("horizontalTextPosition", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The horizontal position of the text relative to the icon.",
               }
             ),
             
             createPropertyDescriptor("margin", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The space between the button's border and the label.",
               }
             ),
             
             createPropertyDescriptor("rolloverSelectedIcon", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The rollover selected icon for the button.",
               }
             ),
             
             createPropertyDescriptor("selectedIcon", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The selected icon for the button.",
               }
             ),
             
             createPropertyDescriptor("UI", new Object[] {
                 SHORTDESCRIPTION, "UI",
               }
             ),
             
             createPropertyDescriptor("selected", new Object[] {
                 SHORTDESCRIPTION, "selected",
               }
             ),
             
             createPropertyDescriptor("rolloverIcon", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The rollover icon for the button.",
               }
             ),
             
             createPropertyDescriptor("selectedObjects", new Object[] {
                 SHORTDESCRIPTION, "selectedObjects",
               }
             ),
             
             createPropertyDescriptor("borderPainted", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Whether the border should be painted.",
               }
             ),
             
             createPropertyDescriptor("disabledIcon", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The disabled icon for the button.",
               }
             ),
             
             createPropertyDescriptor("verticalTextPosition", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The vertical position of the text relative to the icon.",
               }
             ),
             
             createPropertyDescriptor("pressedIcon", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The pressed icon for the button.",
               }
             ),
             
             createPropertyDescriptor("rolloverEnabled", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Whether rollover effects should be enabled.",
               }
             ),
             
             createPropertyDescriptor("text", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The button's text.",
               }
             ),
             
             createPropertyDescriptor("focusPainted", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Whether focus should be painted",
               }
             ),
             
             createPropertyDescriptor("model", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Model that the Button uses.",
               }
             ),
             
             createPropertyDescriptor("actionCommand", new Object[] {
                 SHORTDESCRIPTION, "actionCommand",
               }
             ),
             
             createPropertyDescriptor("disabledSelectedIcon", new Object[] {
                 SHORTDESCRIPTION, "disabledSelectedIcon",
               }
             ),
             
             createPropertyDescriptor("label", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "Replace by setText(text)",
               }
             ),
             
             createPropertyDescriptor("horizontalAlignment", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The horizontal alignment of the icon and text.",
               }
             ),
             
             createPropertyDescriptor("verticalAlignment", new Object[] {
                            BOUND, Boolean.TRUE,
                 SHORTDESCRIPTION, "The vertical alignment of the icon and text.",
               }
             )
             
	};
    }


    /**
     * @return an icon of the specified kind for AbstractButton
     */
    public Image getIcon(int kind) {
	Image i;
	switch (kind){
	  case ICON_COLOR_32x32:
	          i = loadImage("beaninfo/images/AbstractButtonColor32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor32.gif") : i);
	  case ICON_COLOR_16x16:
		  i = loadImage("beaninfo/images/AbstractButtonColor16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentColor16.gif") : i);
	  case ICON_MONO_32x32:
		  i = loadImage("beaninfo/images/AbstractButtonMono32.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono32.gif") : i);		  
	  case ICON_MONO_16x16:
		  i = loadImage("beaninfo/images/AbstractButtonMono16.gif");
		  return ((i == null) ? loadImage("beaninfo/images/JComponentMono16.gif") : i);		  
	  default:
	    return super.getIcon(kind);
	}
    }
}


