/*
 * @(#)UndoableEditSupport.java	1.9 97/08/15
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.undo;

import com.sun.java.swing.event.*;
import java.util.*;

/**
 */
public class UndoableEditSupport {
    protected int updateLevel;
    protected CompoundEdit compoundEdit;
    protected Vector listeners;
    protected Object realSource;

    public UndoableEditSupport() {
	this(null);
    }

    public UndoableEditSupport(Object r) {
	realSource = r == null ? this : r;
	updateLevel = 0;
	compoundEdit = null;
	listeners = new Vector();
    }

    public synchronized void addUndoableEditListener(UndoableEditListener l) {
	listeners.addElement(l);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener l)
    {
	listeners.removeElement(l);
    }

    /**
     * Called only from postEdit and endUpdate. Calls
     * undoableEditHappened in all listeners. No synchronization
     * is performed here, since the two calling methods are
     * synchonized.
     */
    protected void _postEdit(UndoableEdit e) {
	UndoableEditEvent ev = new UndoableEditEvent(realSource, e);
	Enumeration cursor = listeners.elements();
	while (cursor.hasMoreElements()) {
	    ((UndoableEditListener)cursor.nextElement()).
		undoableEditHappened(ev);	    
	}
    }
    
    /**
     * DEADLOCK WARNING: Calling this method may call undoableEditHappened
     * in all listeners.  It is unwise to call this method from one
     * of its listeners.
     */
    public synchronized void postEdit(UndoableEdit e) {
	if (updateLevel == 0) {
	    _postEdit(e);
	} else {
	    // PENDING(rjrjr) Throw an exception if this fails? 
	    compoundEdit.addEdit(e);
	}
    }

    public int getUpdateLevel() {
	return updateLevel;
    }

    public synchronized void beginUpdate() {
	if (updateLevel == 0) {
	    compoundEdit = createCompoundEdit();
	}
	updateLevel++;
    }

    /**
     * Called only from beginUpdate. Exposed here for subclasses' use
     */
    protected CompoundEdit createCompoundEdit() {
	return new CompoundEdit();
    }

    /**
     * DEADLOCK WARNING: Calling this method may call undoableEditHappened
     * in all listeners.  It is unwise to call this method from one
     * of its listeners.
     */
    public synchronized void endUpdate() {
	updateLevel--;
	if (updateLevel == 0) {
	    compoundEdit.end();
	    _postEdit(compoundEdit);
	    compoundEdit = null;
	}
    }
    
    public String toString() {
	return super.toString() +
	    " updateLevel: " + updateLevel +
	    " listeners: " + listeners +
	    " compoundEdit: " + compoundEdit;
    }
}


