/*
 * @(#)StyleReader.java	1.19 98/03/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.text.html;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.InputStream;
import java.io.*;

import com.sun.java.swing.text.*;

/**
 * A reader to load a Cascading Style Sheet file into a StyleContext
 *
 * @author  Jill Nakata
 * @author  Makarand Gokhale
 * @author  Sara Swanson
 * @version 1.19 03/13/98
 * 
 */
class StyleReader extends HTMLStyleCallbackDefault {

    public static final String DEFAULT_STYLE_HIERARCHY = "default-hierarchy";
    public static final String CHILD_STYLE = "child-style";

    private style32 styleParser;
    private StyleContext styleContext;
    private Style _newStyle, _parentStyle;
    private String _name;
    private Vector tags;
    protected static StyleSheet ss = new StyleSheet();

    public StyleReader(StyleContext sc) {
	this.styleContext = sc;

	// Create the default style hierarchy
        Style shStyle = styleContext.addStyle(DEFAULT_STYLE_HIERARCHY, null);
	// The default style hierarchy should reference the default style
        shStyle.addAttribute(CHILD_STYLE,
	    styleContext.getStyle(StyleContext.DEFAULT_STYLE));

	ss = new StyleSheet(styleContext.getStyle(DEFAULT_STYLE_HIERARCHY));

	tags = new Vector();
	_parentStyle = styleContext.getStyle(DEFAULT_STYLE_HIERARCHY);
    }

    /**
     * Load the given input stream (which is expected to 
     * contain valid style sheet data) into the given StyleContext.
     */
    public int read(StyleContext sc, int offset, InputStream is) {

	// Create the Style Parser and set Actions.
        styleParser = new style32(new InputStreamReader(is));
        styleParser.setCallback(this);

        try {
	    // Parse it.
            styleParser.extstylesheet();
        } catch (ParseException e) {
            System.out.println("Style Parse Error");
            System.out.println(e);
        }

	//dumpStyles(styleContext.getStyle(DEFAULT_STYLE_HIERARCHY),"");

	return 0;
    }

    /**
     * Returns the style sheet.
     */
    public static StyleSheet getStyleSheet() {
	return ss;
    }

    private String makePName(String styleName) {

        String pName = null;

	if (styleName.equals("p"))
	  pName = Constants.IMPLIEDP;
	else {
	  pName = styleName.substring(0,styleName.length()-1) 
		+ Constants.IMPLIEDP;
	}

	return pName;
    }

    private void dumpStyles(Style s, String indent) {
        for (Enumeration e = s.getAttributeNames();
            e.hasMoreElements() ;) {
            Object key = e.nextElement();
            Object value = s.getAttribute(key);
	    if (!key.equals(StyleConstants.ResolveAttribute))
                System.out.println(indent + key.toString() + " = " + value.toString());
 
            if((value instanceof Style)
		&& (! key.equals(StyleConstants.ResolveAttribute))) {


                dumpStyles((Style)value, indent + "  ");
            }
        }
    }
 
    /************ Callbacks from Style Parser *************/

    /**
     * Callback from Style Parser when a tag has been consumed.
     */ 
    public void tagAction(String tag) {

	//
	// Set the parent style
	// If body, then use default style.
	//
	if (tag.equals(Constants.BODY)) {
	    _parentStyle = styleContext.getStyle(DEFAULT_STYLE_HIERARCHY);
	}

	// 
	// Build up the list of tags.
	//
	tags.addElement(tag);

	// Make the style name string "li li p"
	String styleName = makeStyleName();

  	//
	// Add this style and set the tags as an attribute.
        // on the style.
	Style childStyle = null;
	if (!tag.equals(Constants.BODY)) {
	    // Don't duplicate any styles so try to look it up first
	    _newStyle = styleContext.getStyle("SH" + styleName);
	    if (_newStyle == null) {
		// Add a new node in the style hierarchy
	        _newStyle =  styleContext.addStyle("SH" + styleName, null);

		// Get the childstyle from the parent so that the correct
		// resolve parent can be set when childStyle is created
	        Style parentChildStyle 
		   = (Style)_parentStyle.getAttribute(CHILD_STYLE);

		// Create the childStyle that matches the _newStyle node
		// in the hierarchy.
	        childStyle 
		   = styleContext.addStyle(styleName, parentChildStyle);

		// Add a pointer from the style hierarchy node to the
		// childStyle and the parent style hierarchy node.
	        _newStyle.addAttribute(CHILD_STYLE, childStyle);
	        _newStyle.addAttribute(StyleConstants.ResolveAttribute, _parentStyle);

		// Make the parent node point to the new child node
	        _parentStyle.addAttribute("SH" + tag, _newStyle);
	    }

/*
     	    // Clone the P Style into an impliedp style.
	    // Only clone tags ending with "p"
	    if (styleName.equals("p") || styleName.endsWith(" p")) {
	        String pName = makePName("SH" + styleName);

	        // Don't duplicate any styles so try to look it up first
	        Style impliedStyle = styleContext.getStyle(pName);
	        if (impliedStyle == null) {
		    // Add a new node in the hierarchy for the implied style
	            impliedStyle = styleContext.addStyle(pName, null);

		    // Add a pointer from the style hierarchy node to the
		    // childStyle and the parent style hierarchy node.
	            impliedStyle.addAttribute(CHILD_STYLE, childStyle);
	            impliedStyle.addAttribute(StyleConstants.ResolveAttribute, _parentStyle);

		    // Make the parent node point to the new child node
	            _parentStyle.addAttribute(Constants.IMPLIEDP, impliedStyle);
	        }
	    }
*/
	}
	else {
	    _newStyle = _parentStyle;
	}

        //
        // Set new _parentStyle for any dep tags.
	//
	_parentStyle = _newStyle;
    }

    /**
     * Callback from Style Parser when a dependent tag has been consumed.
     */ 
    public void depTagAction() {
        ;
    }

    /**
     * Callback from Style Parser when a class has been consumed.
     */ 
    public void classAction(String regclass) {
	 ;
    }

    /**
     * Callback from Style Parser when a pseudo class has been consumed.
     */ 
    public void pseudoclassAction(String pseudoclass) {
	 ;
    }

    /**
     * Callback from Style Parser when a property has been consumed.
     */ 
    public void propertyAction(String property) {
	_name = property;
    }

    /**
     * Callback from Style Parser when a value for a property 
     * has been consumed.
     * This needs to be fixed to handle multiple values:
     *	  color: red, green, blue
     */ 
    public void valueAction(String value) {
	Style childStyle 
	    = (Style)_newStyle.getAttribute(CHILD_STYLE);

        StyleXlater.translateProperty(ss, childStyle, _name, value);

	//
	// Reset tags list and reset parent style to default style.
	// Doing this for every property value for now.
	//
	tags.removeAllElements();
	_parentStyle = styleContext.getStyle(DEFAULT_STYLE_HIERARCHY);
    }

    /**
     * Build a style name of current tags: "li li li p"
     */ 
    private String makeStyleName() {

	int length = tags.size();
	String styleName = new String();

	String tag = (String)tags.elementAt(0);
	styleName = styleName + tag;

	for (int i = 1; i < length; i++) {
	  tag = (String)tags.elementAt(i);
	  styleName = styleName + " " + tag;
        }
	return styleName;

    }

  
}
