/*
 * @(#)SpecialCharTable.java	1.3 98/03/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.text.html;

import java.util.Vector;
import java.io.*;

/**
 * Translate Special Character codes into their ascii equivalent.
 * 
 * @author  Sara Swanson
 * @version 1.3 03/13/98
 */
    class SpecialChar {
	char symbol;
	String name;

	public SpecialChar(char sym, String nm) {
	    symbol = sym;
	    name = nm;
	}

	char getSymbol() {
	    return symbol;
	}

	String getName() {
	    return name;
	}

    }

    class SpecialCharTable {
	SpecialChar[] specialCharTable = new SpecialChar[100];
	int ts = 0;

	public SpecialCharTable() {
	    specialCharTable[ts] = new SpecialChar((char)34, "quot"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)38, "amp"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)60, "lt"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)62, "gt"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)160, "nbsp"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)161, "iexcl"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)162, "cent"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)163, "pound"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)164, "curren"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)165, "yen"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)166, "brvbar"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)167, "sect"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)168, "uml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)169, "copy"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)170, "ordf"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)171, "laquo"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)172, "not"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)173, "shy"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)174, "reg"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)175, "macr"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)176, "deg"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)177, "plusmn"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)178, "sup2"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)179, "sup3"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)180, "acute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)181, "micro"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)182, "para"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)183, "middot"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)184, "cedil"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)185, "sup1"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)186, "ordm"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)187, "raquo"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)188, "frac14"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)189, "frac12"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)190, "frac34"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)191, "iquest"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)192, "Agrave"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)193, "Aacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)194, "Acirc"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)195, "Atilde"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)196, "Auml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)197, "Aring"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)198, "AElig"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)199, "Ccedil"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)200, "Egrave"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)201, "Eacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)202, "Ecirc"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)203, "Euml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)204, "Igrave"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)205, "Iacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)206, "Icirc"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)207, "Iuml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)208, "ETH"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)209, "Ntilde"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)210, "Ograve"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)211, "Oacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)212, "Ocirc"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)213, "Otilde"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)214, "Ouml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)215, "times"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)216, "Oslash"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)217, "Ugrave"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)218, "Uacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)219, "Ucirc"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)220, "Uuml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)221, "Yacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)222, "THORN"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)223, "szlig"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)224, "agrave"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)225, "aacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)226, "acirc"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)227, "atilde"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)228, "auml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)229, "aring"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)230, "aelig"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)231, "ccedil"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)232, "egrave"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)233, "eacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)234, "ecirc"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)235, "euml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)236, "igrave"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)237, "iacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)238, "iicrc"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)239, "iuml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)240, "eth"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)241, "ntilde"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)242, "ograve"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)243, "oacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)244, "ocirc"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)245, "otilde"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)246, "ouml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)247, "divide"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)248, "oslash"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)249, "ugrave"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)250, "uacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)251, "ucirc"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)252, "uuml"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)253, "yacute"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)254, "thorn"); ts++;
	    specialCharTable[ts] = new SpecialChar((char)255, "yuml"); ts++;
	}

	char getSymbol(String name) {
	    for (int i=0; i<ts; i++) {
		if(name.equalsIgnoreCase(specialCharTable[i].getName())) {
		    return(specialCharTable[i].getSymbol());
		}
	    }
	    return 0;
	}

	String getName(char sym) {
	    for (int i=0; i<ts; i++) {
		if(sym == specialCharTable[i].getSymbol()) {
		    return(specialCharTable[i].getName());
		}
	    }
	    return null;
	}

    }

