/*
 * @(#)LineView.java	1.3 97/09/29
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.text.html;

import java.util.Enumeration;
import java.awt.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.text.*;

/**
 * A view implementation to display an unwrapped 
 * preformatted line.
 *
 * @author  Timothy Prinzing
 * @version 1.3 09/29/97
 */
class LineView extends BoxView  {

    /**
     * Creates a LineView object.
     *
     * @param elem the element to wrap in a view
     */
    public LineView(Element elem) {
	super(elem, View.X_AXIS);
    }

    /**
     * Gets the resize weight for the specified axis.
     *
     * @param axis may be either X_AXIS or Y_AXIS
     * @return the weight
     */
    public int getResizeWeight(int axis) {
	switch (axis) {
	case View.X_AXIS:
	    return 1;
	case View.Y_AXIS:
	    return 0;
	default:
	    throw new IllegalArgumentException("Invalid axis: " + axis);
	}
    }

    /**
     * Gets the alignment for an axis.
     *
     * @param axis may be either X_AXIS or Y_AXIS
     * @return the alignment
     */
    public float getAlignment(int axis) {
	if (axis == View.X_AXIS) {
	    return 0;
	}
	return super.getAlignment(axis);
    }

}
