/*
 * @(#)BodyView.java	1.6   98/03/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.text.html;

import java.util.Enumeration;
import java.awt.*;
import java.net.*;
import java.awt.image.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.*;
import java.awt.event.*;

/**
 *
 * @author  Makarand Gokhale
 * @version 1.6 03/13/98
 */
class BodyView extends BoxView  {

    transient Image bgimage;
    transient Color bgcolor;
    transient String colorStr = null;
    transient String imageStr = null;
    HTMLRootImageObserver imageObserver=null;

    boolean bImageLoaded=false;
    boolean bImageLoadFailed=false;


    int imgWidth = -1;
    int imgHeight = -1;
    int drawWidth = -1;
    int drawHeight = -1;


    public BodyView(Element elem, int axis) {
	super(elem, axis);
// Disable until Time gets this working
//	loadBackground(elem.getAttributes());
    }

    public void loadBackground ( AttributeSet as) {
	imageStr = (String) as.getAttribute("background");
        colorStr = (String ) as.getAttribute("bgcolor");
	bImageLoaded = false;
	bImageLoadFailed = false;
	imgWidth = imgHeight = drawWidth = drawHeight = -1;
        bgimage = null;
       if ( colorStr == null )
	   bgcolor = Color.lightGray;
       else {
	   bgcolor = Utilities.stringToColor(colorStr);
       }
       if(imageStr != null) {
	   imageObserver = new HTMLRootImageObserver();
	   bgimage = loadImage(imageStr);
	   bImageLoaded = false;
	}
	      
    }

    private Image loadImage(String imageStr) {
        if( imageStr==null ) return null;
        URL url = null;
        URL reference = (URL) getElement().getDocument().getProperty(Document.StreamDescriptionProperty);
	if(reference != null ) {
	    try {
		url = new URL(reference,imageStr);
	    } catch (MalformedURLException e) {
		System.out.println("Malformed URL:"+reference);
	    }
	}
	if(url != null )
	    return Toolkit.getDefaultToolkit().getImage(url);
	else
	    return Toolkit.getDefaultToolkit().getImage(imageStr);
 
    }
   

    public void paint(Graphics g, Shape allocation) {
//  Disable painting until Time gets it  to paint via HTMLEditorKit
//	paintBackground( g, allocation);
	super.paint(g,allocation);
    }
    public void paintBackground(Graphics g, Shape allocation ) {
	Element elem = getElement();
	AttributeSet as = elem.getAttributes();
	String cStr = (String) as.getAttribute("bgcolor");
	String iStr = (String) as.getAttribute("background");
	if( cStr != null) {
	    if(!cStr.equals(colorStr))
	    	loadBackground(as);
	}
	else if (colorStr != null)
	    loadBackground(as);
	if( iStr != null) {
	     if(!iStr.equals(imageStr))
	    	loadBackground(as);
	}
	else if (imageStr != null )
	    loadBackground(as);

	Rectangle alloc = allocation.getBounds();
	setSize(alloc.width, alloc.height);
        if(bgimage != null){
	     if (bImageLoaded) {
		 for(int xpos=0;xpos < alloc.width; xpos+=imgWidth)  {
		    for(int ypos=0;ypos < alloc.height; ypos+=imgHeight)  {
			g.drawImage(bgimage,xpos,ypos, null);
		    }
		 }
	    }
	    else {
	    	 paintBGColor(g, allocation);
		 if(!bImageLoadFailed)
		     g.drawImage(bgimage,0,0, imageObserver);
	    }
	    if(!bImageLoadFailed) {
		if(imgWidth <= 0 )
		    imgWidth = bgimage.getWidth(imageObserver);
		if(imgHeight <= 0 )
		    imgHeight = bgimage.getHeight(imageObserver);
	    }
	}
        else {
	    paintBGColor(g, allocation);
        }
    }

    private void paintBGColor(Graphics g, Shape allocation ) {
	Rectangle alloc = allocation.getBounds();
        g.setColor(bgcolor);
        g.fillRect(0,0, alloc.width, alloc.height);
    }




    class  HTMLRootImageObserver  implements ImageObserver {

	public HTMLRootImageObserver() {
		super();
	}

 	public boolean imageUpdate(Image img,
                                     int infoflags,
                                     int x,
                                     int y,
                                     int width,
                                     int height) {
		if((infoflags & ERROR) > 0 || (infoflags & ABORT) > 0 )
		    bImageLoadFailed = true;
		if((infoflags & WIDTH) > 0 ) {
 		    imgWidth = width;
		}
		if((infoflags & HEIGHT) > 0 ) {
 		    imgHeight = height;
		}
		if((infoflags & SOMEBITS) > 0 || (infoflags & ALLBITS) > 0  ) {
		     drawWidth = width>drawWidth?width:drawWidth;
		     drawHeight = height>drawHeight?height:drawHeight;
		}
		if(imgWidth > 0 && imgHeight > 0 ) {
		    if(imgWidth == drawWidth && imgHeight == drawHeight) {
			bImageLoaded = true;
		        getContainer().repaint();
		    }
		}
		return !bImageLoaded;
	}
    }


}
