/*
 * @(#)PasswordView.java	1.3 98/04/09
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.text;

import java.awt.*;
import com.sun.java.swing.JPasswordField;

/**
 * Implements a View suitable for use in JPasswordField 
 * UI implementations.  This is basically a field ui that
 * renders its contents as the echo character specified
 * in the associated component (if it can narrow the 
 * component to a JPasswordField).
 *
 * @author  Timothy Prinzing
 * @version 1.3 04/09/98
 * @see     View
 */
public class PasswordView extends FieldView {

    /**
     * Constructs a new view wrapped on an element.
     *
     * @param elem the element
     */
    public PasswordView(Element elem) {
	super(elem);
    }

    /**
     * Renders the given range in the model as normal unselected
     * text.  This sets the foreground color and echos the characters
     * using the value returned by getEchoChar().
     *
     * @param g the graphics context
     * @param x the starting X coordinate >= 0
     * @param y the starting Y coordinate >= 0
     * @param p0 the starting offset in the model >= 0
     * @param p1 the ending offset in the model >= p0
     * @returns the X location of the end of the range >= 0
     * @exception BadLocationException if p0 or p1 are out of range
     */
    protected int drawUnselectedText(Graphics g, int x, int y, 
				     int p0, int p1) throws BadLocationException {
					 
	Container c = getContainer();
	if (c instanceof JPasswordField) {
	    JPasswordField f = (JPasswordField) c;
	    g.setColor(f.getForeground());
	    char echoChar = f.getEchoChar();
	    int n = p1 - p0;
	    for (int i = 0; i < n; i++) {
		x = drawEchoCharacter(g, x, y, echoChar);
	    }
	}
	return x;
    }

    /**
     * Renders the given range in the model as selected text.  This
     * is implemented to render the text in the color specified in
     * the hosting component.  It assumes the highlighter will render
     * the selected background.  Uses the result of getEchoChar() to
     * display the characters.
     *
     * @param g the graphics context
     * @param x the starting X coordinate >= 0
     * @param y the starting Y coordinate >= 0
     * @param p0 the starting offset in the model >= 0
     * @param p1 the ending offset in the model >= p0
     * @returns the X location of the end of the range >= 0.
     * @exception BadLocationException if p0 or p1 are out of range
     */
    protected int drawSelectedText(Graphics g, int x, 
				   int y, int p0, int p1) throws BadLocationException {
	g.setColor(selected);
	Container c = getContainer();
	if (c instanceof JPasswordField) {
	    JPasswordField f = (JPasswordField) c;
	    g.setColor(f.getSelectedTextColor());
	    char echoChar = f.getEchoChar();
	    int n = p1 - p0;
	    for (int i = 0; i < n; i++) {
		x = drawEchoCharacter(g, x, y, echoChar);
	    }
	}
	return x;
    }

    /**
     * Renders the echo character, or whatever graphic should be used 
     * to display the password characters.  The color in the Graphics
     * object is set to the appropriate foreground color for selected
     * or unselected text.
     *
     * @param g the graphics context
     * @param x the starting X coordinate >= 0
     * @param y the starting Y coordinate >= 0
     * @param c the echo character
     * @return the updated X position >= 0
     */
    protected int drawEchoCharacter(Graphics g, int x, int y, char c) {
	ONE[0] = c;
	g.drawChars(ONE, 0, 1, x, y);
	return x + g.getFontMetrics().charWidth(c);
    }

    static char[] ONE = new char[1];
}
