/*
 * @(#)FileView.java	1.3 98/04/14
 * 
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.preview.filechooser;

import java.io.File;
import com.sun.java.swing.*;
import com.sun.java.swing.preview.*;

/**
 * FileView defines an abstract class that can be implemented to
 * provide the filechooser with ui information for a File.
 *
 * Each L&F JFileChooserUI object implements this class to pass
 * back the correct icons and type descriptions specific to
 * that L&F. For example, the Windows L&F returns the generic Windows
 * icons for directories and generic files.
 *
 * Additionally, you may want to provide your own FileView to
 * JFileChooser to return different icons or additional information. 
 *
 * @see JFileChooser#setFileView
 * @see JFileChooser#setFileView
 *
 * JFileChooser first looks to see if there is a user defined FileView,
 * if there is, it gets type information from there first. If FileView
 * returns null for any method, JFileChooser then uses the L&F specific
 * view to get the information.
 *
 * So, for example, if you provide a FileView class that returns an
 * <code>Icon<code> for JPG files, and returns <code>null<code>
 * icons for all other files, the UI's FileView will provide default
 * icons for all other files.
 *
 * @see JFileChooser
 * @see ExtensionBasedFileView (NOTE: ExtensionBasedFileFilter is currently
 *      located in the FileChooserDemo directory. The next Swing release
 *      (Swing 1.0.3) will move this into the filechooser pakcage).
 *
 * @version 1.3 04/14/98
 * @author Jeff Dinkins
 *
 */
public abstract class FileView {
    /**
     * The name of the file. Normally this would be simply f.getName()
     */
    public abstract String getName(File f);

    /**
     * A human readable description of the file. For example,
     * a file named jag.jpg might have a description that read:
     * "A JPEG image file of James Gosling's face"
     */
    public abstract String getDescription(File f);

    /**
     * A human readable description of the type of the file. For
     * example, a jpg file might have a type description of:
     * "A JPEG Compressed Image File"
     */
    public abstract String getTypeDescription(File f);

    /**
     * The icon that represents this file in the JFileChooser.
     */
    public abstract Icon getIcon(File f);

    /**
     * Whether the directory is traversable or not. This might be
     * useful, for example, if you want a directory to represent
     * a compound document and don't want the user to descend into it.
     */
    public abstract Boolean isTraversable(File f);

}
