/*
 * @(#)WindowsToggleButtonUI.java	1.7 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.*;

import java.awt.*;



/**
 * A Windows toggle button.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.7 04/13/98
 * @author unknown
 */
public class WindowsToggleButtonUI extends BasicToggleButtonUI
{

  private final static  WindowsToggleButtonUI windowsToggleButtonUI = new WindowsToggleButtonUI();

  private static final int defaultTextIconGap = 4;  
  protected final static Insets defaultMargin = new Insets(2,14,2,14);

  public static ComponentUI createUI(JComponent b) 
    {
      return windowsToggleButtonUI;
    }

  protected void paintFocus(Graphics g, AbstractButton b,
			      Rectangle viewRect, Rectangle textRect, Rectangle iconRect){
    g.setColor(toggleButtonFocus);
    BasicGraphicsUtils.drawDashedRect(g,5,4, b.getWidth()-10, b.getHeight() - 8);
  }


  public Insets getDefaultMargin(AbstractButton b)
    {
      return defaultMargin;
    }


}

