/*
 * @(#)WindowsLookAndFeel.java	1.30 98/04/14
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.windows;

import java.awt.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.DefaultEditorKit;

import java.awt.Font;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.InputEvent;

import java.net.URL;
import java.io.Serializable;


/**
 * Implements the Windows95 Look and Feel.
 * UI classes not implemented specifically for Windows will
 * default to those implemented in Basic.  
 * <p>
 * For the keyboard keys defined for each component in this Look and
 * Feel (L&F), see 
 * <a href="../../doc-files/Key-Win32.html">Component Keystroke Actions for the Windows L&F</a>.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.30 04/14/98
 * @author unknown
 */
public class WindowsLookAndFeel extends BasicLookAndFeel
{
    public String getName() {
        return "Windows";
    }


    public String getDescription() {
        return "The Microsoft Windows Look and Feel";
    }


    public String getID() {
        return "Windows";
    }
    
    public boolean isNativeLookAndFeel() {
        String osName = System.getProperty("os.name");
        return (osName != null) && (osName.indexOf("Windows") != -1);
    }


    public boolean isSupportedLookAndFeel() {
	return isNativeLookAndFeel();
    }

    
    /** 
     * Initialize the uiClassID to BasicComponentUI mapping.
     * The JComponent classes define their own uiClassID constants
     * (see AbstractComponent.getUIClassID).  This table must
     * map those constants to a BasicComponentUI class of the
     * appropriate type.
     * 
     * @see BasicLookAndFeel#getDefaults
     */
    protected void initClassDefaults(UIDefaults table)
    {
        String basicPackageName = "com.sun.java.swing.plaf.basic.";
        String windowsPackageName = "com.sun.java.swing.plaf.windows.";
        Object[] uiDefaults = {
                   "ButtonUI", windowsPackageName + "WindowsButtonUI",
                 "CheckBoxUI", windowsPackageName + "WindowsCheckBoxUI",
             "ColorChooserUI", basicPackageName + "BasicColorChooserUI",
                  "MenuBarUI", basicPackageName + "BasicMenuBarUI",
                     "MenuUI", basicPackageName + "BasicMenuUI",
                 "MenuItemUI", basicPackageName + "BasicMenuItemUI",
         "CheckBoxMenuItemUI", basicPackageName + "BasicCheckBoxMenuItemUI",
      "RadioButtonMenuItemUI", basicPackageName + "BasicRadioButtonMenuItemUI",
              "RadioButtonUI", windowsPackageName + "WindowsRadioButtonUI",
             "ToggleButtonUI", windowsPackageName + "WindowsToggleButtonUI",
                "PopupMenuUI", basicPackageName + "BasicPopupMenuUI",
              "ProgressBarUI", windowsPackageName + "WindowsProgressBarUI",
                "ScrollBarUI", basicPackageName + "BasicScrollBarUI",
               "ScrollPaneUI", basicPackageName + "BasicScrollPaneUI",
                "SplitPaneUI", windowsPackageName + "WindowsSplitPaneUI",
                   "SliderUI", basicPackageName + "BasicSliderUI",
                  "SpinnerUI", basicPackageName + "BasicSpinnerUI",
                "SeparatorUI", basicPackageName + "BasicSeparatorUI",
               "TabbedPaneUI", basicPackageName + "BasicTabbedPaneUI",
                 "TextAreaUI", windowsPackageName + "WindowsTextAreaUI",
                "TextFieldUI", windowsPackageName + "WindowsTextFieldUI",
            "PasswordFieldUI", windowsPackageName + "WindowsPasswordFieldUI",
                 "TextPaneUI", windowsPackageName + "WindowsTextPaneUI",
               "EditorPaneUI", windowsPackageName + "WindowsEditorPaneUI",
                     "TreeUI", windowsPackageName + "WindowsTreeUI",
                    "LabelUI", basicPackageName + "BasicLabelUI",
                     "ListUI", basicPackageName + "BasicListUI",
                  "ToolBarUI", basicPackageName + "BasicToolBarUI",
                  "ToolTipUI", basicPackageName + "BasicToolTipUI",
                 "ComboBoxUI", windowsPackageName + "WindowsComboBoxUI",
                    "TableUI", basicPackageName + "BasicTableUI",
              "TableHeaderUI", basicPackageName + "BasicTableHeaderUI",
            "InternalFrameUI", windowsPackageName + "WindowsInternalFrameUI",
           "StandardDialogUI", basicPackageName + "BasicStandardDialogUI",
              "DesktopPaneUI", windowsPackageName + "WindowsDesktopPaneUI",
              "DesktopIconUI", basicPackageName + "BasicDesktopIconUI",
              "FileChooserUI", windowsPackageName + "WindowsFileChooserUI",
               "OptionPaneUI", basicPackageName + "BasicOptionPaneUI"
        };

        table.putDefaults(uiDefaults);
    }

    /**
     * Load the SystemColors into the defaults table.  The keys
     * for SystemColor defaults are the same as the names of
     * the public fields in SystemColor.  If the table is being
     * created on a native Windows platform we use the SystemColor
     * values, otherwise we create color objects whose values match
     * the defaults Windows95 colors.
     */
    protected void initSystemColorDefaults(UIDefaults table)
    {
        String[] systemColors = {
                "desktop", "#005C5C", /* Color of the desktop background */
          "activeCaption", "#000080", /* Color for captions (title bars) when they are active. */
      "activeCaptionText", "#FFFFFF", /* Text color for text in captions (title bars). */
    "activeCaptionBorder", "#C0C0C0", /* Border color for caption (title bar) window borders. */
        "inactiveCaption", "#808080", /* Color for captions (title bars) when not active. */
    "inactiveCaptionText", "#C0C0C0", /* Text color for text in inactive captions (title bars). */
  "inactiveCaptionBorder", "#C0C0C0", /* Border color for inactive caption (title bar) window borders. */
                 "window", "#FFFFFF", /* Default color for the interior of windows */
           "windowBorder", "#000000", /* ??? */
             "windowText", "#000000", /* ??? */
                   "menu", "#C0C0C0", /* Background color for menus */
       "menuPressedItemB", "#000080", /* LightShadow of menubutton highlight */ 
       "menuPressedItemF", "#FFFFFF", /* Default color for foreground "text" in menu item */
               "menuText", "#000000", /* Text color for menus  */
                   "text", "#C0C0C0", /* Text background color */
               "textText", "#000000", /* Text foreground color */
          "textHighlight", "#000080", /* Text background color when selected */
      "textHighlightText", "#FFFFFF", /* Text color when selected */
       "textInactiveText", "#808080", /* Text color when disabled */
                "control", "#C0C0C0", /* Default color for controls (buttons, sliders, etc) */
            "controlText", "#000000", /* Default color for text in controls */
       "controlHighlight", "#FFFFFF", /* Specular highlight (opposite of the shadow) */
     "controlLtHighlight", "#E0E0E0", /* Highlight color for controls */
          "controlShadow", "#808080", /* Shadow color for controls */
        "controlDkShadow", "#000000", /* Dark shadow color for controls */
              "scrollbar", "#E0E0E0", /* Scrollbar background (usually the "track") */
                   "info", "#FFFFE1", /* ??? */
               "infoText", "#000000"  /* ??? */
        };

        loadSystemColors(table, systemColors);
    }

    protected void initComponentDefaults(UIDefaults table) 
    {
        super.initComponentDefaults( table );

        // *** Fonts
        FontUIResource dialogPlain12 = new FontUIResource("Dialog", Font.PLAIN, 12);
        FontUIResource serifPlain12 = new FontUIResource("Serif", Font.PLAIN, 12);
        FontUIResource sansSerifPlain12 = new FontUIResource("SansSerif", Font.PLAIN, 12);
        FontUIResource monospacedPlain12 = new FontUIResource("Monospaced", Font.PLAIN, 12);

        // *** Colors
        ColorUIResource red = new ColorUIResource(Color.red);
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource white = new ColorUIResource(Color.white);
        ColorUIResource yellow = new ColorUIResource(Color.yellow);
        ColorUIResource gray = new ColorUIResource(Color.gray);
        ColorUIResource lightGray = new ColorUIResource(Color.lightGray);
        ColorUIResource darkGray = new ColorUIResource(Color.darkGray);
        ColorUIResource scrollBarTrack = new ColorUIResource(224, 224, 224);

	// ** Menu
        ColorUIResource menuItemPressedBackground = new ColorUIResource(0,0,128);
        ColorUIResource menuItemPressedForeground = new ColorUIResource(255,255,255);

        // *** Tree 
        ColorUIResource treeSelection = new ColorUIResource(0, 0, 128);

        Object treeExpandedIcon = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return WindowsTreeUI.ExpandedIcon.createExpandedIcon();
            }
        };

        Object treeCollapsedIcon = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return WindowsTreeUI.CollapsedIcon.createCollapsedIcon();
            }
        };

	// *** Text

	JTextComponent.KeyBinding[] fieldBindings = {
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_C, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.copyAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_V, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.pasteAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_X, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.cutAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionBackwardAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionForwardAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.previousWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.nextWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.CTRL_MASK | 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionPreviousWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.CTRL_MASK |
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionNextWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_A, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.selectAllAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 0),
					  DefaultEditorKit.beginLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 0),
					  DefaultEditorKit.endLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionBeginLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionEndLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
					  JTextField.notifyAction)
	};

	JTextComponent.KeyBinding[] multilineBindings = {
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_C, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.copyAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_V, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.pasteAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_X, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.cutAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionBackwardAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionForwardAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.previousWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.nextWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.CTRL_MASK | 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionPreviousWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.CTRL_MASK |
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionNextWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_A, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.selectAllAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 0),
					  DefaultEditorKit.beginLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 0),
					  DefaultEditorKit.endLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionBeginLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionEndLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_UP, 0),
					  DefaultEditorKit.upAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN, 0),
					  DefaultEditorKit.downAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, 0),
					  DefaultEditorKit.pageUpAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_DOWN, 0),
					  DefaultEditorKit.pageDownAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_UP,
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionUpAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionDownAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
					  DefaultEditorKit.insertBreakAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0),
					  DefaultEditorKit.insertTabAction)
	};

        // *** Buttons
        Object buttonBorder = new UIDefaults.LazyValue() {
          public Object createValue(UIDefaults table) {
            return new BorderUIResource(new CompoundBorder(
                                           WindowsBorderFactory.getButtonBorder(),
                                           BasicMarginBorder.getMarginBorder()));
          }
        };

        Object buttonToggleBorder = new UIDefaults.LazyValue() {
          public Object createValue(UIDefaults table) {
            return new BorderUIResource(new CompoundBorder(
                                      WindowsBorderFactory.getToggleButtonBorder(),
                                      BasicMarginBorder.getMarginBorder()));
          }
        };


        Object checkBoxIcon = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return WindowsIconFactory.getCheckBoxIcon();
            }
        };

        Object radioButtonIcon = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return WindowsIconFactory.getRadioButtonIcon();
            }
        };


	// *** ProgressBar
	Object progressBarBorder = new BorderUIResource(new CompoundBorder(
	    WindowsBorderFactory.getProgressBarBorder(),
	    new EmptyBorder(1,1,1,1)
	    ) );


        // *** ToolTips
        Object toolTipBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return BorderUIResource.getBlackLineBorderUIResource();
            }
        };

        Object radioButtonBorder = new UIDefaults.LazyValue() {
          public Object createValue(UIDefaults table) {
            return new BorderUIResource(new CompoundBorder(
                                      WindowsBorderFactory.getRadioButtonBorder(),
                                      BasicMarginBorder.getMarginBorder()));
          }
        };

        Object menuItemCheckIcon = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return WindowsIconFactory.getMenuItemCheckIcon();
            }
        };

        Object menuItemArrowIcon = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return WindowsIconFactory.getMenuItemArrowIcon();
            }
        };

        Object menuArrowIcon = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return WindowsIconFactory.getMenuArrowIcon();
            }
        };

        Object menuMarginBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
              // REMIND: should be in WindowsBorderFactory
                return new BorderUIResource(BasicMarginBorder.getMarginBorder());
            }
        };

        Object[] defaults = {
	    "TextField.keyBindings", fieldBindings,
	    "PasswordField.keyBindings", fieldBindings,
	    "TextArea.keyBindings", multilineBindings,
	    "TextPane.keyBindings", multilineBindings,
	    "EditorPane.keyBindings", multilineBindings,

            "Button.border", buttonBorder,
            "Button.background", table.get("control"),
            "Button.foreground", table.get("controlText"),
            "Button.focus", table.get("controlText"),
            "Button.font", dialogPlain12,
            "Button.pressed", table.get("control"),

            "CheckBox.icon", checkBoxIcon,

            "Menu.border", menuMarginBorder,
            "Menu.font", dialogPlain12,
            "Menu.foreground", table.get("menuText"),
            "Menu.background", table.get("menu"),
            "Menu.pressedForeground", menuItemPressedForeground,
            "Menu.pressedBackground", menuItemPressedBackground,
            "Menu.arrowIcon", menuArrowIcon,

            "MenuItem.border", menuMarginBorder,
            "MenuItem.font", dialogPlain12,
            "MenuItem.foreground", table.get("menuText"),
            "MenuItem.background", table.get("menu"),
            "MenuItem.pressedForeground", menuItemPressedForeground,
            "MenuItem.pressedBackground", menuItemPressedBackground,
            "MenuItem.checkIcon", menuItemCheckIcon,
            "MenuItem.arrowIcon", menuItemArrowIcon,

            "ToggleButton.border", buttonToggleBorder,
            "ToggleButton.background", table.get("control"),
            "ToggleButton.foreground", table.get("controlText"),
            "ToggleButton.focus", table.get("controlText"),
            "ToggleButton.font", dialogPlain12,

            "SplitPane.background", table.get("control"),
            "SplitPane.highlight", table.get("controllHighlight"),
            "SplitPane.shadow", table.get("controlShadow"),
	    "SplitPane.dividerSize", new Integer(3),

            "RadioButton.background", table.get("control"),
            "RadioButton.foreground", table.get("controlText"),
            "RadioButton.font", dialogPlain12,
            "RadioButton.icon", radioButtonIcon,
            "RadioButton.border", radioButtonBorder,
            "RadioButton.focus", black,

            "ToolTip.font", sansSerifPlain12,
            "ToolTip.border", toolTipBorder,
            "ToolTip.background", table.get("info"),
            "ToolTip.foreground", table.get("infoText"),

            "ProgressBar.font", dialogPlain12,
            "ProgressBar.foreground",  table.get("textHighlight"), 
            "ProgressBar.background", table.get("control"), 
	    "ProgressBar.border", progressBarBorder,
            "ProgressBar.cellLength", new Integer(7),
            "ProgressBar.cellSpacing", new Integer(2),

            "Tree.background", white,
            "Tree.hash", gray,
            "Tree.borderSelectionColor", yellow,
            "Tree.backgroundSelectionColor", treeSelection,
            "Tree.backgroundNonSelectionColor", white,
            "Tree.expandedIcon", treeExpandedIcon,
            "Tree.collapsedIcon", treeCollapsedIcon,

	    "FileChooser.newFolderIcon", LookAndFeel.makeIcon(getClass(), "icons/NewFolder.gif"),
	    "FileChooser.upFolderIcon", LookAndFeel.makeIcon(getClass(), "icons/UpFolder.gif"),
	    "FileChooser.homeFolderIcon", LookAndFeel.makeIcon(getClass(), "icons/HomeFolder.gif"),
	    "FileChooser.detailsViewIcon", LookAndFeel.makeIcon(getClass(), "icons/DetailsView.gif"),
	    "FileChooser.listViewIcon", LookAndFeel.makeIcon(getClass(), "icons/ListView.gif"),

	    "FileView.directoryIcon", LookAndFeel.makeIcon(getClass(), "icons/Directory.gif"),
	    "FileView.fileIcon", LookAndFeel.makeIcon(getClass(), "icons/File.gif"),
	    "FileView.computerIcon", LookAndFeel.makeIcon(getClass(), "icons/Computer.gif"),
	    "FileView.hardDriveIcon", LookAndFeel.makeIcon(getClass(), "icons/HardDrive.gif"),
	    "FileView.floppyDriveIcon", LookAndFeel.makeIcon(getClass(), "icons/FloppyDrive.gif"),

            "InternalFrame.maximizeIcon", 
                WindowsIconFactory.createFrameMaximizeIcon(),
            "InternalFrame.minimizeIcon", 
                WindowsIconFactory.createFrameMinimizeIcon(),
            "InternalFrame.iconifyIcon", 
                WindowsIconFactory.createFrameIconifyIcon(),
            "InternalFrame.closeIcon", 
                WindowsIconFactory.createFrameCloseIcon(),

        };

        table.putDefaults(defaults);
    }
}
