/*
 * @(#)WindowsDesktopPaneUI.java	1.6 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.plaf.ComponentUI;
import java.awt.event.*;

/**
 * Windows desktop pane.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version %i% 02/02/98
 * @author unknown
 */
public class WindowsDesktopPaneUI extends BasicDesktopPaneUI
{
    public static ComponentUI createUI(JComponent c) {
        return new WindowsDesktopPaneUI();
    }

    protected void installDesktopManager() {
	if(desktop.getDesktopManager() == null) {
	    desktopManager = new WindowsDesktopManager();
	    desktop.setDesktopManager(desktopManager);
	}
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        installKeyboardActions(c);
    }

    public void uninstallUI(JComponent c) {
        uninstallKeyboardActions(c);
        super.uninstallUI(c);
    }

    void switchFrame(boolean next) {
        WindowsDesktopManager dm = 
            (WindowsDesktopManager)desktop.getDesktopManager();
        if (dm == null) {
            return;
        }
        if (next) {
            dm.activateNextFrame();
        } else {
            dm.activatePreviousFrame();
        }
    }

    protected void installKeyboardActions(JComponent c) {
        c.registerKeyboardAction(
            new AbstractAction() {
                public void actionPerformed(ActionEvent e) {
                    switchFrame(true);
                }
                public boolean isEnabled() { 
                    return true; 
                }
            },
            KeyStroke.getKeyStroke(KeyEvent.VK_F6, InputEvent.ALT_MASK), 
            JComponent.WHEN_IN_FOCUSED_WINDOW);
        c.registerKeyboardAction(
            new AbstractAction() {
                public void actionPerformed(ActionEvent e) {
                    switchFrame(false);
                }
                public boolean isEnabled() { 
                    return true; 
                }
            },
            KeyStroke.getKeyStroke(KeyEvent.VK_F6, 
                                   InputEvent.ALT_MASK | InputEvent.SHIFT_MASK), 
            JComponent.WHEN_IN_FOCUSED_WINDOW);
        
        // Request focus if it isn't set.
        if(!c.requestDefaultFocus()) {
            c.requestFocus();
        }
    }

    protected void uninstallKeyboardActions(JComponent c) {
        c.resetKeyboardActions();
    }
}

