/*
 * @(#)WindowsComboBoxUI.java	1.7 98/04/21
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.*;
import java.awt.event.*;
import java.awt.*;


/**
 * Windows combo box.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.7 04/21/98
 * @author Tom Santos
 */

public class WindowsComboBoxUI extends BasicComboBoxUI {

    public static ComponentUI createUI(JComponent c) {
        return new WindowsComboBoxUI();
    }  

    public void installUI( JComponent c ) {
        super.installUI( c );
        comboBox.setRequestFocusEnabled( true );
    }

    protected void installDefaults( JComponent c ) {
        super.installDefaults( c );
        comboBox.setBorder( new ComboBoxBorder() );
    }

    public void paint(Graphics g, JComponent c) {
        //Rectangle b = c.getBounds();
        //BasicGraphicsUtils.drawEtchedRect(g,0,0,b.width,b.height);
        super.paint( g, c );
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    } 

    protected void addKeyAccelerators(JComponent comp) {
        super.addKeyAccelerators( comp );

        final JComboBox cBox = comboBox;

        AbstractAction downAction = new AbstractAction() {
            public void actionPerformed( ActionEvent e ) {
                if ( !cBox.isEditable() ||
                     (cBox.isEditable() && popupIsVisible()) ) {
                    selectNextPossibleValue();
                }
            }
            public boolean isEnabled() {
                return cBox.isEnabled();
            }
        };

        comp.registerKeyboardAction( downAction,
                                     KeyStroke.getKeyStroke( KeyEvent.VK_DOWN, 0 ),
                                     JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

        AbstractAction upAction = new AbstractAction() {
            public void actionPerformed( ActionEvent e ) {
                if ( !cBox.isEditable() ||
                     (cBox.isEditable() && popupIsVisible()) ) {
                    selectPreviousPossibleValue();
                }
            }
            public boolean  isEnabled() {
                return cBox.isEnabled();
            }        
        };

        comp.registerKeyboardAction( upAction,
                                     KeyStroke.getKeyStroke( KeyEvent.VK_UP, 0 ),
                                     JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
    }

    protected void removeKeyAccelerators(JComponent comp) {
        super.removeKeyAccelerators( comp );
        comp.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,0));
        comp.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_UP,0));
    }

    protected class ComboBoxBorder implements Border, UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height){
            Rectangle b = c.getBounds();
            BasicGraphicsUtils.drawEtchedRect(g,0,0,b.width,b.height);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets( 2, 2, 2, 2 );
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    protected ComboPopup createPopup() {
        return new WindowsComboPopup( comboBox );
    }

    protected class WindowsComboPopup extends BasicComboPopup {
        // This is here because the compiler isn't currently letting this
        // inner class have access to its parent's inherited data members.
        JComboBox comboBox;

        public WindowsComboPopup( JComboBox cBox ) {
            super( cBox );
            comboBox = cBox;
        }

        protected KeyListener createKeyListener() {
            return new WindowsKeyListener();
        }

        protected class WindowsKeyListener extends KeyAdapter {
            public void keyReleased( KeyEvent e ) {
                if ( e.isShiftDown() && e.getKeyCode() != KeyEvent.VK_SHIFT ) {
                    if ( e.getKeyCode() == KeyEvent.VK_UP ||
                         e.getKeyCode() == KeyEvent.VK_DOWN ) {
                        if ( isVisible() ) {
                            hide();
                        }
                        else {
                            show();
                        }
                    }
                }
                else if ( comboBox.isEditable() &&
                          !isVisible() &&
                          (e.getKeyCode() == KeyEvent.VK_UP ||
                           e.getKeyCode() == KeyEvent.VK_DOWN) ) {
                    show();
                }
            }
        }
    }
}

