/*
 * @(#)WindowsButtonUI.java	1.8 98/04/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.*;

import java.awt.*;

/**
 * Windows button.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 */
public class WindowsButtonUI extends BasicButtonUI
{
  /**
   * border & margin
   */
  protected final static Insets defaultMargin = new Insets(2,14,2,14);

  protected WindowsButtonListener windowsButtonListener = new WindowsButtonListener(null);
  
  private final static WindowsButtonUI windowsButtonUI = new WindowsButtonUI();


  public static ComponentUI createUI(JComponent c){
    return windowsButtonUI;
  }
 
  protected BasicButtonListener createListener(JComponent c){
    return new WindowsButtonListener((AbstractButton)c); // windowsButtonListener;
  }


  protected void paintFocus(Graphics g, AbstractButton b,
			    Rectangle viewRect, Rectangle textRect, Rectangle iconRect){
    // focus painted same color as text on Basic??
    int width = b.getWidth();
    int height = b.getHeight();
    g.setColor( getFocusColor() );
    BasicGraphicsUtils.drawDashedRect(g, 5, 4, width-10, height - 8);
  }


  protected void paintButtonPressed(Graphics g, AbstractButton b){
    setTextShiftOffset(1);
  }

  public Insets getDefaultMargin(AbstractButton b){
    return defaultMargin;
  }


}

