/*
 * @(#)WindowsBorderFactory.java	1.4 98/04/09
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.*;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Dimension;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;


/**
 * Factory object that can vend Borders appropriate for the Windows 95 L & F.
 * @version 1.4 04/09/98
 * @author Rich Schiavi
 */

public class WindowsBorderFactory
{

  private static Border buttonBorder;
  private static Border toggleButtonBorder;
  private static Border radioButtonBorder;
  
  public static Border getButtonBorder() {
    if (buttonBorder == null) {
      buttonBorder = new WindowsButtonBorder();
    }
    return buttonBorder;
  }

  public static Border getToggleButtonBorder() {
    if (toggleButtonBorder == null) {
      toggleButtonBorder = new WindowsToggleBorder();
    }
    return toggleButtonBorder;
  }

  public static Border getRadioButtonBorder() {
    if (radioButtonBorder == null) {
      radioButtonBorder = new WindowsRadioBorder();
    }
    return radioButtonBorder;
  }

  public static Border getProgressBarBorder() {
    return new WindowsProgressBarBorder();
  }

  private static class WindowsToggleBorder extends AbstractBorder {

        public void paintBorder(Component c, Graphics g, int x, int y, 
                                int width, int height) {
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                ButtonModel model = b.getModel();

                if (model.isArmed() && model.isPressed() || model.isSelected()) {
                    BasicGraphicsUtils.drawLoweredBezel(g, x, y, width, height);
                } else {
                    BasicGraphicsUtils.drawBezel(g, x, y, width, height, 
                                         false, b.isFocusPainted() && b.hasFocus());
                }
            } else {	
                BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, false);
            }
        }

        public Insets getBorderInsets(Component c)       {
            return new Insets(2, 2, 2, 2);
        }
    }


  private static class WindowsButtonBorder extends AbstractBorder {
    public void paintBorder(Component c, Graphics g, int x, int y, 
                            int width, int height) {
      boolean isPressed = false;
      boolean isDefault = false;
      
      if (c instanceof AbstractButton) {
	AbstractButton b = (AbstractButton)c;
	ButtonModel model = b.getModel();
	
	isPressed = model.isPressed() && model.isArmed();
/*
	hasFocus = (model.isArmed() && isPressed) || 
	  (b.isFocusPainted() && b.hasFocus());
          */
        isDefault = (b instanceof JButton && ((JButton)b).isDefaultButton());
      }	
      BasicGraphicsUtils.drawBezel(g, x, y, width, height, 
				   isPressed, isDefault);
    }
    public Insets getBorderInsets(Component c)       {
      return new Insets(2, 2, 2, 2);
    }
  }

    private static class WindowsRadioBorder extends AbstractBorder {

        public void paintBorder(Component c, Graphics g, int x, int y, 
                                int width, int height) {

            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                ButtonModel model = b.getModel();

                if (model.isArmed() && model.isPressed() || model.isSelected()) {
                    BasicGraphicsUtils.drawLoweredBezel(g, x, y, width, height);
                } else {
                    BasicGraphicsUtils.drawBezel(g, x, y, width, height, 
                                         false, b.isFocusPainted() && b.hasFocus());
                }
            } else {	
                BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, false);
            }
        }

        public Insets getBorderInsets(Component c)       {
            return new Insets(2, 2, 2, 2);
        }
    }

  private static class WindowsProgressBarBorder extends AbstractBorder {

        public void paintBorder(Component c, Graphics g, int x, int y, 
                                int width, int height) {
	    g.setColor(Color.gray);
	    g.drawLine(x,y, width-1,y); // draw top
	    g.drawLine(x,y, x,height-1); // draw left
	    g.setColor(Color.white);
	    g.drawLine(x,height-1, width-1,height-1); // draw bottom
	    g.drawLine(width-1,y, width-1,height-1); // draw right
        }

        public Insets getBorderInsets(Component c)       {
            return new Insets(1,1,1,1);
        }
    }


}
