/*
 * @(#)OrganicUtilities.java	1.5 98/02/04
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;


/*
 * @version 1.5 02/04/98
 * @author Michael C. Albers
 */
public class OrganicUtilities
{
    /** Draw a string with the graphics g at location (x,y) just like g.drawString() would.
     *  The first occurence of underlineChar in text will be underlined. The matching is
     *  not case sensitive.
     */
  public static void drawString(Graphics g,String text,
				int underlinedChar,int x,int y) {

    char b[] = new char[1];
    String s;
    char lc,uc;
    int index=-1,lci,uci;
    
    if(underlinedChar != '\0') {
      b[0] = (char)underlinedChar;
      s = new String(b).toUpperCase();
      uc = s.charAt(0);
      
      s = new String(b).toLowerCase();
      lc = s.charAt(0);
      
      uci = text.indexOf(uc);
      lci = text.indexOf(lc);
      
      if(uci == -1)
	index = lci;
      else if(lci == -1)
	index = uci;
      else
	index = (lci < uci) ? lci : uci;
    }
    
    g.drawString(text,x,y);
    if(index != -1) {
      FontMetrics fm = g.getFontMetrics();
      Rectangle underlineRect = new Rectangle();
      underlineRect.x = x + fm.stringWidth(text.substring(0,index));
      underlineRect.y = y;
      underlineRect.width = fm.charWidth(text.charAt(index));
      underlineRect.height = 1;
      g.fillRect(underlineRect.x,underlineRect.y + fm.getDescent() - 1,
		 underlineRect.width,underlineRect.height);
    }
  }
  

  
  public static void drawDashedRect(Graphics g,int x,int y,int width,int height) {
    int vx,vy;
    
    // draw upper and lower horizontal dashes
    for (vx = x; vx < (x + width); vx+=2) {
      g.drawLine(vx, y, vx, y);
      g.drawLine(vx, y + height-1, vx, y + height-1);
    }
    
    // draw left and right vertical dashes
    for (vy = y; vy < (y + height); vy+=2) {
      g.drawLine(x, vy, x, vy);
      g.drawLine(x+width-1, vy, x + width-1, vy);
    }
  }

    public static void paintMenuItem(Graphics g, JComponent c,
				     Icon checkIcon, Icon arrowIcon,
				     Color background, Color foreground,
				     int defaultTextIconGap)
    {
        JMenuItem b = (JMenuItem) c;
        ButtonModel model = b.getModel();

        Dimension size = b.getSize();

	Insets i = c.getInsets();

        Rectangle viewRect = new Rectangle(size);

	viewRect.x += i.left;
	viewRect.y += i.top;
	viewRect.width -= (i.right + viewRect.x);
	viewRect.height -= (i.bottom + viewRect.y);

        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle acceleratorRect = new Rectangle();
        Rectangle checkRect = new Rectangle();
        Rectangle arrowRect = new Rectangle();

	Font holdf = g.getFont();
	Font f = c.getFont();
	g.setFont( f );
        FontMetrics fm = g.getFontMetrics( f );
	FontMetrics fmAccel = g.getFontMetrics( UIManager.getFont("MenuItem.acceleratorFont") );

	// Paint background
	Color holdc = g.getColor();

	g.setColor( b.getBackground() );
	g.fillRect( 0, 0, size.width, size.height );

	if ( model.isArmed() || ( c instanceof JMenu && model.isSelected() ) )
	{
	    g.setColor( background );

	    if ( c.getParent() instanceof JMenuBar )
	    {
	      g.fillRect(0,0, size.width, size.height);
	    }
	    else
	    {
	      g.fillRect( 2, 2, size.width - 4, size.height - 4 );
	    }
	}

	// get Accelerator text
	KeyStroke accelerator =  b.getAccelerator();
	String acceleratorText = "";
	if (accelerator != null) {
	    int modifiers = accelerator.getModifiers();
	    if (modifiers > 0) {
		acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
		acceleratorText += "+";
	  }
	    acceleratorText += KeyEvent.getKeyText(accelerator.getKeyCode());
	}

	// layout the text and icon
        String text = BasicGraphicsUtils.layoutMenuItem(
	    fm, b.getText(), fmAccel, acceleratorText, b.getIcon(),
	    checkIcon, arrowIcon,
	    b.getVerticalAlignment(), b.getHorizontalAlignment(),
	    b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
	    viewRect, iconRect, textRect, 
	    acceleratorRect, checkRect, arrowRect,
	    b.getText() == null ? 0 : defaultTextIconGap,
	    defaultTextIconGap
	);
	  
	// Paint the Check
	if (checkIcon != null) {
	    if(model.isArmed() || (c instanceof JMenu && model.isSelected())) {
		g.setColor(foreground);
	    } else {
		g.setColor(b.getForeground());
	    }
	    checkIcon.paintIcon(c, g, checkRect.x, checkRect.y);
	    g.setColor(holdc);
	}

	// Paint the Icon
        if(b.getIcon() != null) { 
            Icon icon;
            if(!model.isEnabled()) {
                icon = (Icon) b.getDisabledIcon();
            } else if(model.isPressed() && model.isArmed()) {
                icon = (Icon) b.getPressedIcon();
                if(icon == null) {
                    // Use default icon
                    icon = (Icon) b.getIcon();
                } 
            } else {
                icon = (Icon) b.getIcon();
            }
	      
	       
	    icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }

	// Draw the Text
        if ( text != null && !text.equals("") )
	{
            if ( !model.isEnabled() )
	    {
                // *** paint the text disabled
                g.setColor( UIManager.getColor("MenuItem.disabledForeground") );
                BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                              textRect.x, textRect.y + fm.getAscent());
            }
	    else
	    {
                // *** paint the text normally
		if ( model.isArmed() || ( c instanceof JMenu && model.isSelected() ) )
		{
		    if ( c.getParent() instanceof JMenuBar )
		    {
			g.setColor( UIManager.getColor("Menu.pressedForeground") );
		    }
		    else
		    {
			g.setColor( UIManager.getColor("MenuItem.pressedForeground") );
		    }
		}
		else
		{
		    if ( c.getParent() instanceof JMenuBar )
		    {
			g.setColor( UIManager.getColor("Menu.foreground") );
		    }
		    else
		    {
			g.setColor( UIManager.getColor("MenuItem.foreground") );
		    }
		}

                BasicGraphicsUtils.drawString(g,text, 
					      model.getMnemonic(),
                                              textRect.x,
                                              textRect.y + fm.getAscent());
            }
        }
	  
	// Draw the Accelerator Text
        if(acceleratorText != null && !acceleratorText.equals("")) {
	    g.setFont( UIManager.getFont("MenuItem.acceleratorFont") );
            if(!model.isEnabled()) {
                // *** paint the acceleratorText disabled
                g.setColor( UIManager.getColor("MenuItem.disabledForeground") );
                BasicGraphicsUtils.drawString(g,acceleratorText,model.getMnemonic(),
                                              acceleratorRect.x, acceleratorRect.y + fm.getAscent());
            } else {
                // *** paint the acceleratorText normally
		if (model.isArmed()|| (c instanceof JMenu && model.isSelected())) {
		    g.setColor( UIManager.getColor("MenuItem.acceleratorPressedForeground") );
		} else {
		    g.setColor( UIManager.getColor("MenuItem.acceleratorForeground") );
		}
                BasicGraphicsUtils.drawString(g,acceleratorText, 
					      model.getMnemonic(),
                                              acceleratorRect.x,
                                              acceleratorRect.y + fm.getAscent());
            }
        }

	// Paint the Arrow
	if (arrowIcon != null) {
	    if(model.isArmed() || (c instanceof JMenu &&model.isSelected()))
		g.setColor(foreground);
	    if( !(b.getParent() instanceof JMenuBar) )
		arrowIcon.paintIcon(c, g, arrowRect.x, arrowRect.y);
	}
	g.setColor(holdc);
	g.setFont(holdf);
    }

}

